/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import mx4j.log.Log;
import mx4j.log.Log4JLogger;
import mx4j.log.Logger;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.ServiceConfigFactory;
import org.opennms.netmgt.config.service.Argument;
import org.opennms.netmgt.config.service.Attribute;
import org.opennms.netmgt.config.service.Invoke;
import org.opennms.netmgt.config.service.Service;
import org.opennms.netmgt.config.service.types.InvokeAtType;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.vmmgr.DatabaseChecker;
import org.opennms.netmgt.vmmgr.ManagerMBean;
import org.opennms.netmgt.vmmgr.StatusGetter;
import org.opennms.protocols.icmp.IcmpSocket;

public class Manager
implements ManagerMBean {
    public static final String s_defaultInvokeUrl = "http://127.0.0.1:8181/invoke?objectname=OpenNMS%3AName=Manager";
    private static final String LOG4J_CATEGORY = "OpenNMS.Manager";

    public static javax.management.Attribute getAttribute(Attribute attrib) throws Exception {
        Class<?> attribClass = Class.forName(attrib.getValue().getType());
        Constructor<?> construct = attribClass.getConstructor(String.class);
        Object value = construct.newInstance(attrib.getValue().getContent());
        return new javax.management.Attribute(attrib.getName(), value);
    }

    public static Object getArgument(Argument arg) throws Exception {
        Class<?> argClass = Class.forName(arg.getType());
        Constructor<?> construct = argClass.getConstructor(String.class);
        return construct.newInstance(arg.getContent());
    }

    public static void start(MBeanServer server) {
        Manager.log().debug((Object)"Beginning startup");
        List resultInfo = Manager.getInstancesAndInvoke(server, true, InvokeAtType.START, false, true);
        InvokerResult result = (InvokerResult)resultInfo.get(resultInfo.size() - 1);
        if (result != null && result.getThrowable() != null) {
            Service service = result.getService();
            String name = service.getName();
            String className = service.getClassName();
            String message = "An error occurred while attempting to start the \"" + name + "\" service (class " + className + ").  " + "Shutting down and exiting.";
            Manager.log().fatal((Object)message, result.getThrowable());
            System.err.println(message);
            result.getThrowable().printStackTrace();
            Manager.stop(server);
            new Manager().doSystemExit();
            return;
        }
        Manager.log().debug((Object)"Startup complete");
    }

    public void stop() {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        for (MBeanServer server : servers) {
            Manager.stop(server);
        }
    }

    public static void stop(MBeanServer server) {
        Manager.log().debug((Object)"Beginning shutdown");
        Manager.getInstancesAndInvoke(server, false, InvokeAtType.STOP, true, false);
        Manager.log().debug((Object)"Shutdown complete");
    }

    public List status() {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        ArrayList result = new ArrayList();
        for (MBeanServer server : servers) {
            result.addAll(Manager.status(server));
        }
        return result;
    }

    public static List status(MBeanServer server) {
        Manager.log().debug((Object)"Beginning status check");
        List results = Manager.getInstancesAndInvoke(server, false, InvokeAtType.STATUS, false, false);
        ArrayList<String> statusInfo = new ArrayList<String>(results.size());
        for (InvokerResult invokerResult : results) {
            if (invokerResult.getThrowable() == null) {
                statusInfo.add("Status: " + invokerResult.getMbean().getObjectName() + " = " + invokerResult.getResult().toString());
                continue;
            }
            statusInfo.add("Status: " + invokerResult.getMbean().getObjectName() + " = STATUS_CHECK_ERROR");
        }
        Manager.log().debug((Object)"Status check complete");
        return statusInfo;
    }

    public static List getInstancesAndInvoke(MBeanServer server, boolean instantiate, InvokeAtType at, boolean reverse, boolean failFast) {
        ServiceConfigFactory sfact = null;
        try {
            ServiceConfigFactory.init();
            sfact = ServiceConfigFactory.getInstance();
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
        InvokerService[] services = InvokerService.createServiceArray(sfact.getServices());
        if (instantiate) {
            Manager.instantiateClasses(server, services);
        } else {
            Manager.getObjectInstances(server, services);
        }
        return Manager.invokeMethods(server, services, at, reverse, failFast);
    }

    private static void instantiateClasses(MBeanServer server, InvokerService[] invokerServices) {
        for (int i = 0; i < invokerServices.length; ++i) {
            Service service = invokerServices[i].getService();
            try {
                if (Manager.log().isDebugEnabled()) {
                    Manager.log().debug((Object)("loading class " + service.getClassName()));
                }
                Class<?> cinst = Class.forName(service.getClassName());
                if (Manager.log().isDebugEnabled()) {
                    Manager.log().debug((Object)("create new instance of " + service.getClassName()));
                }
                Object bean = cinst.newInstance();
                if (Manager.log().isDebugEnabled()) {
                    Manager.log().debug((Object)("registering mbean instance " + service.getName()));
                }
                ObjectName name = new ObjectName(service.getName());
                invokerServices[i].setMbean(server.registerMBean(bean, name));
                Attribute[] attribs = service.getAttribute();
                if (attribs == null) continue;
                for (int j = 0; j < attribs.length; ++j) {
                    if (Manager.log().isDebugEnabled()) {
                        Manager.log().debug((Object)("setting attribute " + attribs[j].getName()));
                    }
                    server.setAttribute(name, Manager.getAttribute(attribs[j]));
                }
                continue;
            }
            catch (Throwable t) {
                Manager.log().error((Object)("An error occured loading the mbean " + service.getName() + " of type " + service.getClassName() + " it will be skipped"), t);
                invokerServices[i].setBadThrowable(t);
            }
        }
    }

    public static void getObjectInstances(MBeanServer server, InvokerService[] invokerServices) {
        for (int i = 0; i < invokerServices.length; ++i) {
            Service service = invokerServices[i].getService();
            try {
                if (Manager.log().isDebugEnabled()) {
                    Manager.log().debug((Object)("finding mbean instance " + service.getName()));
                }
                ObjectName name = new ObjectName(service.getName());
                invokerServices[i].setMbean(server.getObjectInstance(name));
                continue;
            }
            catch (Throwable t) {
                Manager.log().error((Object)("An error occured loading the mbean " + service.getName() + " of type " + service.getClassName() + " it will be skipped"), t);
                invokerServices[i].setBadThrowable(t);
            }
        }
    }

    private static List invokeMethods(MBeanServer server, InvokerService[] invokerServices, InvokeAtType at, boolean reverse, boolean failFast) {
        Integer[] serviceIndexes = new Integer[invokerServices.length];
        for (int i = 0; i < invokerServices.length; ++i) {
            serviceIndexes[i] = !reverse ? new Integer(i) : new Integer(invokerServices.length - 1 - i);
        }
        ArrayList<InvokerResult> resultInfo = new ArrayList<InvokerResult>(invokerServices.length);
        int end = Manager.getEndPass(invokerServices);
        for (int pass = 0; pass <= end; ++pass) {
            if (Manager.log().isDebugEnabled()) {
                Manager.log().debug((Object)("starting pass " + pass));
            }
            for (int i = 0; i < serviceIndexes.length; ++i) {
                int j = serviceIndexes[i];
                String name = invokerServices[j].getService().getName();
                if (invokerServices[j].isBadService()) {
                    if (!Manager.log().isDebugEnabled()) break;
                    Manager.log().debug((Object)("pass " + pass + " on service " + name + " is bad: not invoking any more methods"));
                    break;
                }
                Invoke[] todo = invokerServices[j].getService().getInvoke();
                for (int k = 0; todo != null && k < todo.length; ++k) {
                    if (todo[k].getPass() != pass || !at.equals(todo[k].getAt())) continue;
                    Service service = invokerServices[j].getService();
                    ObjectInstance mbean = invokerServices[j].getMbean();
                    if (Manager.log().isDebugEnabled()) {
                        Manager.log().debug((Object)("pass " + pass + " on service " + name + " will invoke method \"" + todo[k].getMethod() + "\""));
                    }
                    try {
                        Object result = Manager.invoke(server, todo[k], mbean);
                        resultInfo.add(new InvokerResult(service, mbean, result, null));
                        continue;
                    }
                    catch (Throwable t) {
                        resultInfo.add(new InvokerResult(service, mbean, null, t));
                        if (!failFast) continue;
                        return resultInfo;
                    }
                }
            }
            if (!Manager.log().isDebugEnabled()) continue;
            Manager.log().debug((Object)("completed pass " + pass));
        }
        return resultInfo;
    }

    private static Category log() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return ThreadCategory.getInstance((String)LOG4J_CATEGORY);
    }

    private static int getEndPass(InvokerService[] invokerServices) {
        int end = 0;
        for (int i = 0; i < invokerServices.length; ++i) {
            Invoke[] todo = invokerServices[i].getService().getInvoke();
            for (int j = 0; todo != null && j < todo.length; ++j) {
                if (end >= todo[j].getPass()) continue;
                end = todo[j].getPass();
            }
        }
        return end;
    }

    private static Object invoke(MBeanServer server, Invoke invoke, ObjectInstance mbean) throws Throwable {
        try {
            Argument[] args = invoke.getArgument();
            Object[] parms = new Object[]{};
            String[] sig = new String[]{};
            if (args != null && args.length > 0) {
                parms = new Object[args.length];
                sig = new String[args.length];
                for (int k = 0; k < parms.length; ++k) {
                    parms[k] = Manager.getArgument(args[k]);
                    sig[k] = parms[k].getClass().getName();
                }
            }
            if (Manager.log().isDebugEnabled()) {
                Manager.log().debug((Object)("Invoking " + invoke.getMethod() + " on object " + mbean.getObjectName()));
            }
            return server.invoke(mbean.getObjectName(), invoke.getMethod(), parms, sig);
        }
        catch (Throwable t) {
            Manager.log().error((Object)("An error occured invoking operation " + invoke.getMethod() + " on MBean " + mbean.getObjectName()), t);
            throw t;
        }
    }

    public void doSystemExit() {
        Manager.log().debug((Object)"doSystemExit called... exiting.");
        System.exit(1);
    }

    public void doTestLoadLibraries() {
        IcmpSocket s = null;
        try {
            s = new IcmpSocket();
        }
        catch (Throwable t) {
            String message = "Could not initialize ICMP socket: " + t.getMessage();
            throw new UndeclaredThrowableException(t, message);
        }
        s.close();
        try {
            RrdUtils.initialize();
        }
        catch (Throwable t) {
            String message = "Could not initialize RRD subsystem: " + t.getMessage();
            throw new UndeclaredThrowableException(t, message);
        }
    }

    public static void main(String[] argv) {
        String command;
        String invokeUrl = s_defaultInvokeUrl;
        boolean verbose = false;
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        Authenticator.setDefault(Manager.getAuthenticator());
        Log.redirectTo((Logger)new Log4JLogger());
        Manager.loadGlobalProperties();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-h")) {
                System.out.println("Usage: java org.opennms.netmgt.vmmgr.Manager [<options>] <command>");
                System.out.println("Accepted options:");
                System.out.println("        -v              Verbose mode.");
                System.out.println("        -u <URL>        Alternate invoker URL.");
                System.out.println("");
                System.out.println("Accepted commands: start, stop, status");
                System.out.println("");
                System.out.println("The default invoker URL is: http://127.0.0.1:8181/invoke?objectname=OpenNMS%3AName=Manager");
                System.exit(0);
                continue;
            }
            if (argv[i].equals("-v")) {
                verbose = true;
                continue;
            }
            if (argv[i].equals("-u")) {
                invokeUrl = argv[i + 1];
                ++i;
                continue;
            }
            if (i == argv.length - 1) break;
            System.err.println("Invalid command-line option: \"" + argv[i] + "\".  Use \"-h\" option for help.");
            System.exit(1);
        }
        if (argv.length == 0) {
            System.err.println("You must specify a command.  Use \"-h\" option for help");
            System.exit(1);
        }
        if ("start".equals(command = argv[argv.length - 1])) {
            Manager.doStartCommand();
        } else if ("stop".equals(command)) {
            Manager.doStopCommand(verbose, invokeUrl);
        } else if ("status".equals(command)) {
            Manager.doStatusCommand(verbose, invokeUrl);
        } else if ("check".equals(command)) {
            Manager.doCheckCommand();
        } else if ("exit".equals(command)) {
            Manager.doExitCommand(verbose, invokeUrl);
        } else {
            System.err.println("Invalid command \"" + command + "\".");
            System.err.println("Use \"-h\" option for help.");
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadGlobalProperties() {
        File propertiesFile = Manager.getPropertiesFile();
        if (!propertiesFile.exists()) {
            return;
        }
        Properties props = new Properties(System.getProperties());
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(propertiesFile);
            props.load(fin);
        }
        catch (IOException e) {
            try {
                System.err.println("Error trying to read " + propertiesFile + ": " + e.getMessage());
                System.exit(1);
            }
            catch (Throwable throwable) {
                Manager.closeQuietly(fin);
                throw throwable;
            }
            Manager.closeQuietly(fin);
        }
        Manager.closeQuietly(fin);
        System.setProperties(props);
    }

    private static File getPropertiesFile() {
        String homeDir = System.getProperty("opennms.home");
        File etcDir = new File(homeDir, "etc");
        File propertiesFile = new File(etcDir, "opennms.properties");
        return propertiesFile;
    }

    private static void closeQuietly(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void doStartCommand() {
        MBeanServer server = MBeanServerFactory.createMBeanServer("OpenNMS");
        Manager.start(server);
    }

    private static void doStopCommand(boolean verbose, String invokeUrl) {
        Manager.invokeOperation(verbose, invokeUrl, "stop");
    }

    private static void doStatusCommand(boolean verbose, String invokeUrl) {
        try {
            StatusGetter statusGetter = new StatusGetter();
            statusGetter.setVerbose(verbose);
            statusGetter.setInvokeURL(new URL(invokeUrl + "&operation=status"));
            statusGetter.queryStatus();
            if (statusGetter.getStatus() == 3 || statusGetter.getStatus() == 4) {
                System.exit(3);
            } else if (statusGetter.getStatus() == 2) {
                System.exit(160);
            } else if (statusGetter.getStatus() == 1) {
                System.exit(0);
            } else {
                String message = "Unknown status returned from statusGetter.getStatus(): " + statusGetter.getStatus();
                System.err.println(message);
                Manager.log().error((Object)message);
                System.exit(1);
            }
        }
        catch (Throwable t) {
            Manager.log().error((Object)"error invoking status command", t);
            System.exit(1);
        }
    }

    private static void doCheckCommand() {
        try {
            DatabaseChecker checker = new DatabaseChecker();
            checker.check();
        }
        catch (Throwable t) {
            Manager.log().error((Object)"error invoking check command", t);
            System.err.println(t);
            System.exit(1);
        }
        System.exit(0);
    }

    private static void doExitCommand(boolean verbose, String invokeUrl) {
        Manager.invokeOperation(verbose, invokeUrl, "doSystemExit");
    }

    private static void invokeOperation(boolean verbose, String invokeUrl, String operation) {
        String urlString = invokeUrl + "&operation=" + operation;
        try {
            int ch;
            URL invoke = new URL(urlString);
            InputStream in = invoke.openStream();
            while ((ch = in.read()) != -1) {
                System.out.write((char)ch);
            }
            in.close();
            System.out.println("");
            System.out.flush();
            System.exit(0);
        }
        catch (ConnectException e) {
            Manager.log().error((Object)(e.getMessage() + " when attempting to fetch URL \"" + urlString + "\""));
            if (verbose) {
                System.out.println(e.getMessage() + " when attempting to fetch URL \"" + urlString + "\"");
            }
            System.exit(1);
        }
        catch (Throwable t) {
            Manager.log().error((Object)("error invoking " + operation + " operation"), t);
            System.out.println("error invoking " + operation + " operation");
            t.printStackTrace();
            System.exit(1);
        }
    }

    private static Authenticator getAuthenticator() {
        ServiceConfigFactory sfact = null;
        try {
            ServiceConfigFactory.init();
            sfact = ServiceConfigFactory.getInstance();
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
        Service[] services = sfact.getServices();
        Service service = null;
        for (int i = 0; i < services.length; ++i) {
            if (!services[i].getName().equals(":Name=HttpAdaptorMgmt")) continue;
            service = services[i];
            break;
        }
        if (service == null) {
            return null;
        }
        Attribute[] attribs = service.getAttribute();
        if (attribs == null) {
            return null;
        }
        boolean usingBasic = false;
        for (int j = 0; j < attribs.length; ++j) {
            if (!attribs[j].getName().equals("AuthenticationMethod")) continue;
            if (!attribs[j].getValue().getContent().equals("basic")) {
                Manager.log().error((Object)("AuthenticationMethod is \"" + attribs[j].getValue() + "\", but only \"basic\" is supported"));
                return null;
            }
            usingBasic = true;
            break;
        }
        if (!usingBasic) {
            return null;
        }
        String username = null;
        String password = null;
        Invoke[] invokes = service.getInvoke();
        for (int j = 0; invokes != null && j < invokes.length; ++j) {
            Argument[] args;
            if (!invokes[j].getMethod().equals("addAuthorization") || (args = invokes[j].getArgument()) == null || args.length != 2 || !args[0].getContent().equals("manager")) continue;
            username = args[0].getContent();
            password = args[1].getContent();
            break;
        }
        if (username == null || password == null) {
            return null;
        }
        final String username_f = username;
        final String password_f = password;
        return new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username_f, password_f.toCharArray());
            }
        };
    }

    private static class InvokerResult {
        private Service m_service;
        private ObjectInstance m_mbean;
        private Object m_result;
        private Throwable m_throwable;

        private InvokerResult(Service service, ObjectInstance mbean, Object result, Throwable throwable) {
            this.m_service = service;
            this.m_mbean = mbean;
            this.m_result = result;
            this.m_throwable = throwable;
        }

        private ObjectInstance getMbean() {
            return this.m_mbean;
        }

        private Object getResult() {
            return this.m_result;
        }

        private Throwable getThrowable() {
            return this.m_throwable;
        }

        private Service getService() {
            return this.m_service;
        }
    }

    private static class InvokerService {
        private Service m_service;
        private ObjectInstance m_mbean;
        private Throwable m_badThrowable;

        private InvokerService() {
        }

        private static InvokerService[] createServiceArray(Service[] services) {
            InvokerService[] invokerServices = new InvokerService[services.length];
            for (int i = 0; i < services.length; ++i) {
                invokerServices[i] = new InvokerService();
                invokerServices[i].setService(services[i]);
            }
            return invokerServices;
        }

        private void setBadThrowable(Throwable badThrowable) {
            this.m_badThrowable = badThrowable;
        }

        private ObjectInstance getMbean() {
            return this.m_mbean;
        }

        private void setMbean(ObjectInstance mbean) {
            this.m_mbean = mbean;
        }

        private Service getService() {
            return this.m_service;
        }

        private void setService(Service service) {
            this.m_service = service;
        }

        public boolean isBadService() {
            return this.m_badThrowable != null;
        }
    }
}

