/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vacuumd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.VacuumdConfigFactory;
import org.opennms.netmgt.config.vacuumd.Automation;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.vacuumd.AutomationInterval;
import org.opennms.netmgt.vacuumd.AutomationProcessor;

public class Vacuumd
extends AbstractServiceDaemon
implements Runnable {
    private static Vacuumd m_singleton;
    private Thread m_thread;
    private long m_startTime;
    private boolean m_stopped = false;
    private LegacyScheduler m_scheduler;
    private EventIpcManager m_eventMgr;

    public static synchronized Vacuumd getSingleton() {
        if (m_singleton == null) {
            m_singleton = new Vacuumd();
        }
        return m_singleton;
    }

    public Vacuumd() {
        super("OpenNMS.Vacuumd");
    }

    protected void onInit() {
        try {
            this.log().info((Object)"Loading the configuration file.");
            VacuumdConfigFactory.reload();
        }
        catch (MarshalException ex) {
            this.log().error((Object)"Failed to load outage configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().error((Object)"Failed to load outage configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().error((Object)"Failed to load outage configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        this.log().info((Object)"Vaccumd initialization complete");
        this.createScheduler();
        this.scheduleAutomations();
    }

    protected void onStart() {
        this.m_startTime = System.currentTimeMillis();
        this.m_thread = new Thread((Runnable)this, "Vacuumd-Thread");
        this.m_thread.start();
        this.m_scheduler.start();
    }

    protected void onStop() {
        this.m_stopped = true;
    }

    protected void onPause() {
        this.m_scheduler.pause();
        this.onStop();
    }

    protected void onResume() {
        this.m_thread = new Thread((Runnable)this, "Vacuumd-Thread");
        this.m_scheduler.resume();
        this.m_thread.start();
    }

    public void run() {
        ThreadCategory.setPrefix((String)this.getName());
        Category log = ThreadCategory.getInstance(this.getClass());
        log.info((Object)"Vacuumd scheduling started");
        this.setStatus(2);
        long now = System.currentTimeMillis();
        long period = VacuumdConfigFactory.getInstance().getPeriod();
        log.info((Object)("Vacuumd sleeping until time to execute statements period = " + period));
        long waitTime = 500L;
        while (!this.m_stopped) {
            try {
                now = this.waitPeriod(log, now, period, waitTime);
                log.info((Object)"Vacuumd beginning to execute statements");
                this.executeStatements();
                this.m_startTime = System.currentTimeMillis();
            }
            catch (Exception e) {
                log.error((Object)"Unexpected exception: ", (Throwable)e);
            }
        }
    }

    private void executeStatements() {
        if (!this.m_stopped) {
            String[] stmts = VacuumdConfigFactory.getInstance().getStatements();
            for (int i = 0; i < stmts.length; ++i) {
                this.runUpdate(stmts[i]);
            }
        }
    }

    private long waitPeriod(Category log, long now, long period, long waitTime) {
        int count = 0;
        while (!this.m_stopped && now - this.m_startTime < period) {
            try {
                if (count % 100 == 0) {
                    log.debug((Object)("Vacuumd: " + (period - now + this.m_startTime) + " millis remaining to execution."));
                }
                Thread.sleep(waitTime);
                now = System.currentTimeMillis();
                ++count;
            }
            catch (InterruptedException e) {}
        }
        return now;
    }

    private ResultSet runTrigger(String sql) {
        return null;
    }

    private void runAction(String sql) {
        this.runUpdate(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runUpdate(String sql) {
        Category log = ThreadCategory.getInstance(this.getClass());
        log.info((Object)("Vacuumd executing statement: " + sql));
        Connection dbConn = null;
        boolean commit = false;
        try {
            dbConn = DataSourceFactory.getInstance().getConnection();
            dbConn.setAutoCommit(false);
            PreparedStatement stmt = dbConn.prepareStatement(sql);
            int count = stmt.executeUpdate();
            stmt.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Vacuumd: Ran update " + sql + ": this affected " + count + " rows"));
            }
            commit = true;
            return;
        }
        catch (SQLException ex) {
            log.error((Object)("Vacuumd:  Database error execuating statement  " + sql), (Throwable)ex);
            return;
        }
        finally {
            block38: {
                if (dbConn == null) break block38;
                try {
                    if (commit) {
                        dbConn.commit();
                    } else {
                        dbConn.rollback();
                    }
                    if (dbConn == null) break block38;
                }
                catch (SQLException ex) {
                    if (dbConn == null) break block38;
                    try {
                        dbConn.close();
                    }
                    catch (Exception e) {}
                    break block38;
                    catch (Throwable throwable) {
                        if (dbConn == null) throw throwable;
                        try {
                            dbConn.close();
                            throw throwable;
                        }
                        catch (Exception e) {}
                    }
                }
                try {
                    dbConn.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void createScheduler() {
        Category log = ThreadCategory.getInstance(this.getClass());
        try {
            log.debug((Object)"init: Creating Vacuumd scheduler");
            this.m_scheduler = new LegacyScheduler("Vacuumd", 2);
        }
        catch (RuntimeException e) {
            log.fatal((Object)"init: Failed to create Vacuumd scheduler", (Throwable)e);
            throw e;
        }
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    private void scheduleAutomations() {
        Collection autos = VacuumdConfigFactory.getInstance().getAutomations();
        Iterator it = autos.iterator();
        while (it.hasNext()) {
            this.scheduleAutomation((Automation)it.next());
        }
    }

    private void scheduleAutomation(Automation auto) {
        if (auto.getActive()) {
            AutomationProcessor ap = new AutomationProcessor();
            ap.setAutomation(auto);
            Schedule s = new Schedule(ap, new AutomationInterval(auto.getInterval()), this.m_scheduler);
            ap.setSchedule(s);
            s.schedule();
        }
    }

    public EventIpcManager getEventManager() {
        return this.m_eventMgr;
    }

    public void setEventManager(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }
}

