/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vacuumd;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.VacuumdConfigFactory;
import org.opennms.netmgt.config.vacuumd.Automation;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.vacuumd.Vacuumd;
import org.opennms.netmgt.xml.event.Event;

public class AutomationProcessor
implements ReadyRunnable {
    private Automation m_automation;
    private boolean m_ready = true;
    private Schedule m_schedule;
    private boolean m_triggerSuccessful;
    private boolean m_actionSuccessful;
    private boolean m_triggerInAutomation;
    private Statement m_triggerStatement;
    private ResultSet m_triggerResultSet;
    private Collection m_actionColumns;
    private Connection m_conn;

    public void run() {
        long startDate = System.currentTimeMillis();
        if (AutomationProcessor.log().isDebugEnabled()) {
            AutomationProcessor.log().debug((Object)("Start Scheduled automation " + this));
        }
        if (this.getAutomation() != null) {
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    AutomationProcessor.this.setReady(false);
                    try {
                        AutomationProcessor.this.runAutomation(AutomationProcessor.this.getAutomation());
                    }
                    catch (SQLException e) {
                        AutomationProcessor.log().warn((Object)("Error running automation: " + AutomationProcessor.this.getAutomation().getName() + ", " + e.getMessage()));
                    }
                    finally {
                        AutomationProcessor.this.setReady(true);
                    }
                }
            };
            r.run();
        }
        if (AutomationProcessor.log().isDebugEnabled()) {
            AutomationProcessor.log().debug((Object)("run: Finished automation " + this.m_automation.getName() + ", started at " + new Date(startDate)));
        }
    }

    public static boolean triggerRowCheck(int trigRowCount, String trigOp, int resultRows) {
        if (trigRowCount == 0 || trigOp == null) {
            if (AutomationProcessor.log().isDebugEnabled()) {
                AutomationProcessor.log().debug((Object)("triggerRowCheck: trigger has no row-count restrictions: operator is: " + trigOp + ", row-count is: " + trigRowCount));
            }
            return true;
        }
        if (AutomationProcessor.log().isDebugEnabled()) {
            AutomationProcessor.log().debug((Object)("triggerRowCheck: Verifying trigger resulting row count " + resultRows + " is " + trigOp + " " + trigRowCount));
        }
        boolean runAction = false;
        if ("<".equals(trigOp)) {
            if (resultRows < trigRowCount) {
                runAction = true;
            }
        } else if ("<=".equals(trigOp)) {
            if (resultRows <= trigRowCount) {
                runAction = true;
            }
        } else if ("=".equals(trigOp)) {
            if (resultRows == trigRowCount) {
                runAction = true;
            }
        } else if (">=".equals(trigOp)) {
            if (resultRows >= trigRowCount) {
                runAction = true;
            }
        } else if (">".equals(trigOp) && resultRows > trigRowCount) {
            runAction = true;
        }
        if (AutomationProcessor.log().isDebugEnabled()) {
            AutomationProcessor.log().debug((Object)("Row count verification is: " + runAction));
        }
        return runAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runAutomation(Automation auto) throws SQLException {
        if (AutomationProcessor.log().isDebugEnabled()) {
            AutomationProcessor.log().debug((Object)("runAutomation: " + auto.getName() + " running..."));
        }
        this.setTriggerInAutomation(AutomationProcessor.hasTrigger(auto));
        if (AutomationProcessor.log().isDebugEnabled()) {
            if (this.isTriggerInAutomation()) {
                AutomationProcessor.log().debug((Object)("runAutomation: " + auto.getName() + " trigger statement is: " + AutomationProcessor.getTriggerSQL(auto)));
            }
            AutomationProcessor.log().debug((Object)("runAutomation: " + auto.getName() + " action statement is: " + this.getActionSQL(auto)));
        }
        this.setFields(auto);
        if (AutomationProcessor.log().isDebugEnabled()) {
            AutomationProcessor.log().debug((Object)("runAutomation: Executing trigger: " + auto.getTriggerName()));
        }
        try {
            this.setConn(DataSourceFactory.getInstance().getConnection());
            this.processTrigger(auto);
            if (!this.isTriggerSuccessful()) {
                boolean bl = false;
                return bl;
            }
            Statement actionStatement = null;
            try {
                this.setActionSuccessful(false);
                this.processAction(auto);
            }
            catch (SQLException e) {
                this.getConn().rollback();
                AutomationProcessor.log().warn((Object)("runAutomation: Could not execute update on action: " + auto.getActionName()));
                AutomationProcessor.log().warn((Object)e.getMessage());
            }
            finally {
                if (actionStatement != null) {
                    AutomationProcessor.log().debug((Object)"runAutomation: closing action statement.");
                    actionStatement.close();
                }
            }
        }
        catch (SQLException e) {
            AutomationProcessor.log().warn((Object)("runAutomation: Could not execute trigger: " + auto.getTriggerName()), (Throwable)e);
        }
        finally {
            AutomationProcessor.log().debug((Object)"runAutomation: Closing trigger resultset.");
            if (this.isTriggerInAutomation()) {
                AutomationProcessor.log().debug((Object)"runAutomation: Closing trigger statement.");
                if (this.getTriggerResultSet() != null) {
                    this.getTriggerResultSet().close();
                }
            }
            AutomationProcessor.log().debug((Object)"runAutomation: Closing database connection.");
            this.getConn().close();
        }
        return this.isActionSuccessful();
    }

    private void processAction(Automation auto) throws SQLException {
        if (AutomationProcessor.log().isDebugEnabled()) {
            AutomationProcessor.log().debug((Object)("runAutomation: running action(s): " + auto.getActionName()));
        }
        this.getConn().setAutoCommit(false);
        if (this.isTriggerInAutomation()) {
            this.getTriggerResultSet().beforeFirst();
            while (this.getTriggerResultSet().next()) {
                this.processActionStatement(this.getActionSQL(auto), this.getTriggerResultSet());
            }
            this.setActionSuccessful(true);
            this.sendAutoEvent(auto);
        } else if (this.getTokenCount(this.getActionSQL(auto)) != 0) {
            AutomationProcessor.log().info((Object)("runAutomation: not running action: " + auto.getActionName() + ".  Action contains tokens in an automation (" + auto.getName() + ") with no trigger."));
            this.setActionSuccessful(false);
        } else {
            this.processActionStatement(this.getActionSQL(auto), this.getTriggerResultSet());
            this.sendAutoEvent(auto);
            this.setActionSuccessful(true);
        }
        this.getConn().commit();
    }

    private void processTrigger(Automation auto) throws SQLException {
        if (this.isTriggerInAutomation()) {
            this.setTriggerStatement(this.getConn().createStatement(1005, 1007));
            this.setTriggerResultSet(this.getTriggerStatement().executeQuery(AutomationProcessor.getTriggerSQL(auto)));
            if (!this.verifyRowCount(auto, this.getTriggerResultSet()) || !this.resultSetHasRequiredActionColumns(this.getTriggerResultSet(), this.getActionColumns())) {
                this.setTriggerSuccessful(false);
            } else {
                this.setTriggerSuccessful(true);
            }
        } else {
            this.setTriggerSuccessful(true);
        }
    }

    private void setFields(Automation auto) {
        this.setActionColumns(this.getTokenizedColumns(this.getActionSQL(auto)));
        this.setConn(null);
        this.setTriggerStatement(null);
        this.setTriggerResultSet(null);
    }

    private void sendAutoEvent(Automation auto) {
        if (AutomationProcessor.log().isDebugEnabled()) {
            AutomationProcessor.log().debug((Object)("runAutomation: Sending any possible configured event for automation: " + auto.getName()));
        }
        if (AutomationProcessor.hasEvent(auto)) {
            String uei = this.getUei(auto);
            if (AutomationProcessor.log().isDebugEnabled()) {
                AutomationProcessor.log().debug((Object)("runAutomation: Sending event: " + uei + " for automation: " + auto.getName()));
            }
            Event e = AutomationProcessor.createEvent("Automation", uei);
            Vacuumd.getSingleton().getEventManager().sendNow(e);
        } else if (AutomationProcessor.log().isDebugEnabled()) {
            AutomationProcessor.log().debug((Object)("runAutomation: No event configured automation: " + auto.getName()));
        }
    }

    private String getUei(Automation auto) {
        if (AutomationProcessor.hasEvent(auto)) {
            return VacuumdConfigFactory.getInstance().getAutoEvent(auto.getAutoEventName()).getUei().getContent();
        }
        return null;
    }

    private static Event createEvent(String source, String uei) {
        Event event = new Event();
        event.setSource(source);
        event.setUei(uei);
        String eventTime = EventConstants.formatToString(new Date());
        event.setCreationTime(eventTime);
        event.setTime(eventTime);
        return event;
    }

    protected boolean verifyRowCount(Automation auto, ResultSet triggerResultSet) throws SQLException {
        boolean validRows = true;
        int resultRows = this.countRows(triggerResultSet);
        int triggerRowCount = VacuumdConfigFactory.getInstance().getTrigger(auto.getTriggerName()).getRowCount();
        String triggerOperator = VacuumdConfigFactory.getInstance().getTrigger(auto.getTriggerName()).getOperator();
        if (AutomationProcessor.log().isDebugEnabled()) {
            AutomationProcessor.log().debug((Object)("verifyRowCount: Verifying trigger result: " + resultRows + " is " + triggerOperator + " than " + triggerRowCount));
        }
        if (!AutomationProcessor.triggerRowCheck(triggerRowCount, triggerOperator, resultRows)) {
            validRows = false;
        }
        return validRows;
    }

    private void processActionStatement(String actionSQL, ResultSet triggerResultSet) throws SQLException {
        PreparedStatement actionStatement = this.convertActionToPreparedStatement(triggerResultSet, actionSQL);
        actionStatement.executeUpdate();
    }

    private String getActionSQL(Automation auto) {
        return VacuumdConfigFactory.getInstance().getAction(auto.getActionName()).getStatement().getContent();
    }

    public static String getTriggerSQL(Automation auto) {
        if (AutomationProcessor.hasTrigger(auto)) {
            return VacuumdConfigFactory.getInstance().getTrigger(auto.getTriggerName()).getStatement().getContent();
        }
        return null;
    }

    private static boolean hasTrigger(Automation auto) {
        return auto.getTriggerName() != null;
    }

    private static boolean hasEvent(Automation auto) {
        return auto.getAutoEventName() != null;
    }

    public boolean resultSetHasRequiredActionColumns(ResultSet rs, String actionSQL) {
        Collection actionColumns = this.getTokenizedColumns(actionSQL);
        return this.resultSetHasRequiredActionColumns(rs, actionColumns);
    }

    public boolean resultSetHasRequiredActionColumns(ResultSet rs, Collection actionColumns) {
        if (AutomationProcessor.log().isDebugEnabled()) {
            AutomationProcessor.log().debug((Object)"resultSetHasRequiredActionColumns: Verifying required action columns in trigger ResultSet...");
        }
        boolean verified = true;
        String actionColumnName2 = null;
        for (String actionColumnName2 : actionColumns) {
            try {
                if (rs.findColumn(actionColumnName2) <= 0) continue;
            }
            catch (SQLException e) {
                AutomationProcessor.log().warn((Object)("resultSetHasRequiredActionColumns: Trigger ResultSet does NOT have required action columns.  Missing: " + actionColumnName2));
                AutomationProcessor.log().warn((Object)e.getMessage());
                verified = false;
            }
        }
        return verified;
    }

    public Collection getTokenizedColumns(String targetString) {
        String expression = "\\$\\{(\\w+)\\}";
        Pattern pattern = Pattern.compile(expression);
        Matcher matcher = pattern.matcher(targetString);
        if (AutomationProcessor.log().isDebugEnabled()) {
            AutomationProcessor.log().debug((Object)("getTokenizedColumns: processing string: " + targetString));
        }
        ArrayList<String> tokens = new ArrayList<String>();
        int count = 0;
        while (matcher.find()) {
            ++count;
            if (AutomationProcessor.log().isDebugEnabled()) {
                AutomationProcessor.log().debug((Object)("getTokenizedColumns: Token " + count + ": " + matcher.group(1)));
            }
            tokens.add(matcher.group(1));
        }
        return tokens;
    }

    public int getTokenCount(String targetString) {
        String expression = "(\\$\\{\\w+\\})";
        Pattern pattern = Pattern.compile(expression, 2);
        Matcher matcher = pattern.matcher(targetString);
        if (AutomationProcessor.log().isDebugEnabled()) {
            AutomationProcessor.log().debug((Object)("getTokenCount: processing string: " + targetString));
        }
        int count = 0;
        while (matcher.find()) {
            ++count;
            if (!AutomationProcessor.log().isDebugEnabled()) continue;
            AutomationProcessor.log().debug((Object)("getTokenCount: Token " + count + ": " + matcher.group(1)));
        }
        return count;
    }

    public int countRows(ResultSet rs) throws SQLException {
        int rows = 0;
        while (rs.next()) {
            ++rows;
        }
        rs.beforeFirst();
        return rows;
    }

    public PreparedStatement convertActionToPreparedStatement(ResultSet rs, String actionSQL) throws SQLException {
        String actionJDBC = actionSQL.replaceAll("\\$\\{\\w+\\}", "?");
        if (AutomationProcessor.log().isDebugEnabled()) {
            AutomationProcessor.log().debug((Object)("convertActionToPreparedStatement: This action SQL: " + actionSQL + "\nTurned into this: " + actionJDBC));
        }
        PreparedStatement stmt = this.getConn().prepareStatement(actionJDBC);
        ArrayList actionColumns = (ArrayList)this.getTokenizedColumns(actionSQL);
        Iterator it = actionColumns.iterator();
        String actionColumnName = null;
        int i = 0;
        while (it.hasNext()) {
            actionColumnName = (String)it.next();
            stmt.setObject(++i, rs.getObject(actionColumnName));
        }
        return stmt;
    }

    public boolean containsTokens(String targetString) {
        return this.getTokenCount(targetString) > 0;
    }

    public Automation getAutomation() {
        return this.m_automation;
    }

    public void setAutomation(Automation automation) {
        this.m_automation = automation;
    }

    public boolean isReady() {
        return this.m_ready;
    }

    public Schedule getSchedule() {
        return this.m_schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.m_schedule = schedule;
    }

    private static Category log() {
        return ThreadCategory.getInstance(AutomationProcessor.class);
    }

    private void setActionSuccessful(boolean actionStatus) {
        this.m_actionSuccessful = actionStatus;
    }

    private boolean isActionSuccessful() {
        return this.m_actionSuccessful;
    }

    private void setTriggerInAutomation(boolean triggerInAuto) {
        this.m_triggerInAutomation = triggerInAuto;
    }

    private boolean isTriggerInAutomation() {
        return this.m_triggerInAutomation;
    }

    private void setTriggerStatement(Statement triggerStatement) {
        this.m_triggerStatement = triggerStatement;
    }

    private Statement getTriggerStatement() {
        return this.m_triggerStatement;
    }

    private void setTriggerResultSet(ResultSet triggerResultSet) {
        this.m_triggerResultSet = triggerResultSet;
    }

    private ResultSet getTriggerResultSet() {
        return this.m_triggerResultSet;
    }

    private void setActionColumns(Collection actionColumns) {
        this.m_actionColumns = actionColumns;
    }

    private Collection getActionColumns() {
        return this.m_actionColumns;
    }

    private void setConn(Connection conn) {
        this.m_conn = conn;
    }

    private Connection getConn() {
        return this.m_conn;
    }

    public void setReady(boolean ready) {
        this.m_ready = ready;
    }

    private void setTriggerSuccessful(boolean triggerSuccessful) {
        this.m_triggerSuccessful = triggerSuccessful;
    }

    private boolean isTriggerSuccessful() {
        return this.m_triggerSuccessful;
    }
}

