/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.opennms.core.utils.ThreadCategory;

public class ParameterMap {
    public static int getKeyedInteger(Map map, String key, int defValue) {
        int value = defValue;
        Object oValue = map.get(key);
        if (oValue != null && oValue instanceof String) {
            try {
                value = Integer.parseInt((String)oValue);
            }
            catch (NumberFormatException ne) {
                value = defValue;
                ThreadCategory.getInstance(ParameterMap.class).info((Object)("getIntByKey: Failed to convert value " + oValue + " for key " + key));
            }
            map.put(key, new Integer(value));
        } else if (oValue != null) {
            value = (Integer)oValue;
        }
        return value;
    }

    public static final int[] getKeyedIntegerArray(Map map, String key, int[] defValues) {
        int[] result = defValues;
        Object oValue = map.get(key);
        if (oValue != null && oValue instanceof int[]) {
            result = (int[])oValue;
        } else if (oValue != null) {
            int x;
            ArrayList<Integer> tmpList = new ArrayList<Integer>(5);
            StringTokenizer ints = new StringTokenizer(oValue.toString(), " ;:,");
            while (ints.hasMoreElements()) {
                try {
                    x = Integer.parseInt(ints.nextToken());
                    tmpList.add(new Integer(x));
                }
                catch (NumberFormatException e) {
                    ThreadCategory.getInstance(ParameterMap.class).warn((Object)("getKeyedIntegerList: list member for key " + key + " is malformed"), (Throwable)e);
                }
            }
            result = new int[tmpList.size()];
            for (x = 0; x < result.length; ++x) {
                result[x] = (Integer)tmpList.get(x);
            }
            map.put(key, result);
        }
        return result;
    }

    public static String getKeyedString(Map map, String key, String defValue) {
        String value = defValue;
        Object oValue = map.get(key);
        if (oValue != null && oValue instanceof String) {
            value = (String)oValue;
        } else if (oValue != null) {
            value = oValue.toString();
            map.put(key, value);
        }
        return value;
    }

    public static boolean getKeyedBoolean(Map map, String key, boolean defValue) {
        boolean value = defValue;
        Object oValue = map.get(key);
        if (oValue != null && oValue instanceof String) {
            oValue = new Boolean((String)oValue);
        }
        if (oValue != null && oValue instanceof Boolean) {
            try {
                value = (Boolean)oValue;
            }
            catch (NumberFormatException ne) {
                value = defValue;
                ThreadCategory.getInstance(ParameterMap.class).info((Object)("getBoolByKey: Failed to convert value " + oValue + " for key " + key));
            }
            map.put(key, new Boolean(value));
        } else if (oValue != null) {
            value = (Boolean)oValue;
        }
        return value;
    }
}

