/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.utils.JavaMailerConfig;
import org.opennms.netmgt.utils.JavaMailerException;

public class JavaMailer {
    private final String DEFAULT_FROM_ADDRESS = JavaMailerConfig.getProperty("org.opennms.core.utils.fromAddress", "root@[127.0.0.1]");
    private final String DEFAULT_MAIL_HOST = JavaMailerConfig.getProperty("org.opennms.core.utils.mailHost", "127.0.0.1");
    private final boolean DEFAULT_AUTHENTICATE = JavaMailerConfig.getProperty("org.opennms.core.utils.authenticate", false);
    private final String DEFAULT_AUTHENTICATE_USER = JavaMailerConfig.getProperty("org.opennms.core.utils.authenticateUser", "opennms");
    private final String DEFAULT_AUTHENTICATE_PASSWORD = JavaMailerConfig.getProperty("org.opennms.core.utils.authenticatePassword", "opennms");
    private final String DEFAULT_MAILER = JavaMailerConfig.getProperty("org.opennms.core.utils.mailer", "smtpsend");
    private final String DEFAULT_TRANSPORT = JavaMailerConfig.getProperty("org.opennms.core.utils.transport", "smtp");
    private final boolean DEFAULT_MAILER_DEBUG = JavaMailerConfig.getProperty("org.opennms.core.utils.debug", true);
    private final boolean DEFAULT_USE_JMTA = JavaMailerConfig.getProperty("org.opennms.core.utils.useJMTA", true);
    private String _mailHost = this.DEFAULT_MAIL_HOST;
    private boolean _useJMTA = this.DEFAULT_USE_JMTA;
    private String _mailer = this.DEFAULT_MAILER;
    private String _transport = this.DEFAULT_TRANSPORT;
    private String _to;
    private String _from = this.DEFAULT_FROM_ADDRESS;
    private boolean _authenticate = this.DEFAULT_AUTHENTICATE;
    private String _user = this.DEFAULT_AUTHENTICATE_USER;
    private String _password = this.DEFAULT_AUTHENTICATE_PASSWORD;
    private String _subject;
    private String _messageText;
    private String _fileName;

    public String getFrom() {
        return this._from;
    }

    public void setFrom(String from) {
        this._from = from;
    }

    public boolean isAuthenticate() {
        return this._authenticate;
    }

    public void setAuthenticate(boolean authenticate) {
        this._authenticate = authenticate;
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String fileName) {
        this._fileName = fileName;
    }

    public String getMailHost() {
        return this._mailHost;
    }

    public void setMailHost(String mail_host) {
        this._mailHost = mail_host;
    }

    public String getMailer() {
        return this._mailer;
    }

    public void setMailer(String mailer) {
        this._mailer = mailer;
    }

    public String getMessageText() {
        return this._messageText;
    }

    public void setMessageText(String messageText) {
        this._messageText = messageText;
    }

    public String getSubject() {
        return this._subject;
    }

    public void setSubject(String subject) {
        this._subject = subject;
    }

    public String getTo() {
        return this._to;
    }

    public void setTo(String to) {
        this._to = to;
    }

    public void mailSend() throws JavaMailerException {
        Properties props = System.getProperties();
        if (this._mailHost != null) {
            props.put("mail.smtp.host", this._mailHost);
        }
        if (this._authenticate) {
            props.put("mail.smtp.auth", "true");
        }
        Session session = Session.getInstance((Properties)props, null);
        session.setDebug(this.DEFAULT_MAILER_DEBUG);
        MimeMessage message = new MimeMessage(session);
        try {
            this.buildMsgHeader(this.log(), (Message)message);
            if (this._fileName != null) {
                MimeBodyPart mbp1 = new MimeBodyPart();
                mbp1.setText(this._messageText);
                MimeMultipart mp = new MimeMultipart();
                mp.addBodyPart((BodyPart)mbp1);
                this.log().debug((Object)"_file is not null");
                this.mimeAttachFile(mp);
                message.setContent((Multipart)mp);
            } else {
                message.setText(this._messageText);
            }
            message.setHeader("X-Mailer", this._mailer);
            message.setSentDate(new Date());
            if (this.isUseJMTA()) {
                Transport aTransport = session.getTransport("mta");
                aTransport.sendMessage((Message)message, null);
            } else {
                this.localMtaSend(session, (Message)message);
            }
        }
        catch (AddressException e) {
            throw new JavaMailerException("Java Mailer Addressing exception: ", e);
        }
        catch (MessagingException e) {
            ThreadCategory.getInstance(this.getClass()).error((Object)"Java Mailer messaging exception: ", (Throwable)e);
            throw new JavaMailerException("Java Mailer messaging exception: ", e);
        }
    }

    private void buildMsgHeader(Category log, Message _msg) throws MessagingException, AddressException {
        if (this._from != null) {
            _msg.setFrom((Address)new InternetAddress(this._from));
        } else {
            _msg.setFrom();
        }
        if (this._to == null) {
            log.debug((Object)"_to is null");
            this._to = "root@[127.0.0.1]";
        }
        log.debug((Object)("To is: " + this._to));
        _msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this._to, (boolean)false));
        if (this._subject == null) {
            log.debug((Object)"_subject is null");
            this._subject = "Subject was null";
        }
        log.debug((Object)("Subject is: " + this._subject));
        _msg.setSubject(this._subject);
        if (this._messageText == null) {
            log.debug((Object)"_messageText is null");
            this._messageText = "Message Text was null";
        }
        log.debug((Object)("Message text is: " + this._messageText));
    }

    private void mimeAttachFile(MimeMultipart mp) throws MessagingException {
        MimeBodyPart mbp2 = new MimeBodyPart();
        FileDataSource fds = new FileDataSource(this._fileName);
        mbp2.setDataHandler(new DataHandler((DataSource)fds));
        mbp2.setFileName(fds.getName());
        mp.addBodyPart((BodyPart)mbp2);
    }

    private void localMtaSend(Session session, Message _msg) throws JavaMailerException {
        Transport t = null;
        try {
            t = session.getTransport(this._transport);
            if (this._authenticate) {
                t.connect(this._mailHost, this._user, this._password);
            } else {
                t.connect();
            }
            t.sendMessage(_msg, _msg.getAllRecipients());
        }
        catch (NoSuchProviderException e) {
            throw new JavaMailerException("Couldn't get a transport: ", e);
        }
        catch (MessagingException e) {
            ThreadCategory.getInstance(this.getClass()).error((Object)"Java Mailer messaging exception: ", (Throwable)e);
            throw new JavaMailerException("Java Mailer messaging exception: ", e);
        }
        finally {
            try {
                t.close();
            }
            catch (MessagingException e1) {
                throw new JavaMailerException("Java Mailer messaging exception on transport close: ", e1);
            }
        }
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public String getUser() {
        return this._user;
    }

    public void setUser(String user) {
        this._user = user;
    }

    public boolean isUseJMTA() {
        return this._useJMTA;
    }

    public void setUseJMTA(boolean useMTA) {
        this._useJMTA = useMTA;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

