/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.util.Date;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

public class EventBuilder {
    private Event m_event = new Event();

    public EventBuilder(String uei, String source) {
        this.m_event.setUei(uei);
        Date date = new Date();
        this.setTime(date);
        this.setCreationTime(date);
        this.setSource(source);
    }

    public Event getEvent() {
        return this.m_event;
    }

    public EventBuilder setTime(Date date) {
        this.m_event.setTime(EventConstants.formatToString(date));
        return this;
    }

    public EventBuilder setCreationTime(Date date) {
        this.m_event.setCreationTime(EventConstants.formatToString(date));
        return this;
    }

    public EventBuilder setSource(String source) {
        this.m_event.setSource(source);
        return this;
    }

    public EventBuilder setNodeid(int nodeid) {
        this.m_event.setNodeid((long)nodeid);
        return this;
    }

    public EventBuilder setInterface(String ipAddress) {
        this.m_event.setInterface(ipAddress);
        return this;
    }

    public EventBuilder setService(String serviceName) {
        this.m_event.setService(serviceName);
        return this;
    }

    public EventBuilder addParam(String parmName, String val) {
        Value value = new Value();
        value.setContent(val);
        Parm parm = new Parm();
        parm.setParmName(parmName);
        parm.setValue(value);
        if (this.m_event.getParms() == null) {
            Parms parms = new Parms();
            this.m_event.setParms(parms);
        }
        this.m_event.getParms().addParm(parm);
        return this;
    }

    public EventBuilder addParam(String parmName, int val) {
        return this.addParam(parmName, Integer.toString(val));
    }

    public EventBuilder setNode(OnmsNode node) {
        this.m_event.setNodeid(node.getId().longValue());
        return this;
    }

    public EventBuilder setIpInterface(OnmsIpInterface iface) {
        this.m_event.setNodeid(iface.getNode().getId().longValue());
        this.m_event.setInterface(iface.getIpAddress());
        return this;
    }

    public EventBuilder setMonitoredService(OnmsMonitoredService monitoredService) {
        this.m_event.setNodeid(monitoredService.getNodeId().longValue());
        this.m_event.setInterface(monitoredService.getIpAddress());
        this.m_event.setService(monitoredService.getServiceName());
        return this;
    }
}

