/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.queue.FifoQueueImpl;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.TrapdConfig;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.TrapNotification;
import org.opennms.netmgt.snmp.TrapNotificationListener;
import org.opennms.netmgt.snmp.TrapProcessor;
import org.opennms.netmgt.snmp.TrapProcessorFactory;
import org.opennms.netmgt.trapd.BroadcastEventProcessor;
import org.opennms.netmgt.trapd.EventCreator;
import org.opennms.netmgt.trapd.TrapQueueProcessor;

public class TrapHandler
implements PausableFiber,
TrapProcessorFactory,
TrapNotificationListener {
    private static final String LOG4J_CATEGORY = "OpenNMS.Trapd";
    private static final TrapHandler m_singleton = new TrapHandler();
    private TrapdConfig m_trapdConfig;
    private EventIpcManager m_eventMgr;
    private String m_name = "OpenNMS.Trapd";
    private int m_status = 0;
    private FifoQueue m_backlogQ;
    private Map m_knownIps;
    private TrapQueueProcessor m_processor;
    private BroadcastEventProcessor m_eventReader;

    public void setTrapdConfig(TrapdConfig trapdConfig) {
        this.m_trapdConfig = trapdConfig;
    }

    public TrapProcessor createTrapProcessor() {
        return new EventCreator();
    }

    public void trapReceived(TrapNotification trapNotification) {
        this.addTrap(trapNotification);
    }

    private void addTrap(TrapNotification o) {
        Category log = ThreadCategory.getInstance(this.getClass());
        try {
            this.m_backlogQ.add((Object)o);
        }
        catch (InterruptedException e) {
            log.warn((Object)"snmpReceivedTrap: Error adding trap to queue, it was interrupted", (Throwable)e);
        }
        catch (FifoQueueException e) {
            log.warn((Object)"snmpReceivedTrap: Error adding trap to queue", (Throwable)e);
        }
    }

    public synchronized void init() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        Category log = ThreadCategory.getInstance();
        try {
            boolean m_newSuspect = this.m_trapdConfig.getNewSuspectOnTrap();
            this.m_backlogQ = new FifoQueueImpl();
            this.m_processor = new TrapQueueProcessor(this.m_backlogQ, m_newSuspect, this.m_eventMgr);
            log.debug((Object)"start: Creating the trap queue processor");
            SnmpUtils.registerForTraps((TrapNotificationListener)this, (TrapProcessorFactory)this, (int)this.m_trapdConfig.getSnmpTrapPort());
            log.debug((Object)"start: Creating the trap session");
        }
        catch (IOException e) {
            log.error((Object)"Failed to setup SNMP trap port", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        try {
            this.m_eventReader = new BroadcastEventProcessor();
            this.m_eventReader.setEventManager(this.m_eventMgr);
            this.m_eventReader.open();
        }
        catch (Exception e) {
            ThreadCategory.getInstance().error((Object)"Failed to create event reader", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    public synchronized void start() {
        this.m_status = 1;
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        Category log = ThreadCategory.getInstance();
        log.debug((Object)"start: Initializing the trapd config factory");
        this.m_processor.start();
        this.m_status = 2;
        log.debug((Object)"start: Trapd ready to receive traps");
    }

    public void pause() {
        if (this.m_status != 2) {
            return;
        }
        this.m_status = 5;
        Category log = ThreadCategory.getInstance(this.getClass());
        log.debug((Object)"Calling pause on processor");
        this.m_processor.pause();
        log.debug((Object)"Processor paused");
        this.m_status = 6;
        log.debug((Object)"Trapd paused");
    }

    public void resume() {
        if (this.m_status != 6) {
            return;
        }
        this.m_status = 7;
        Category log = ThreadCategory.getInstance(this.getClass());
        log.debug((Object)"Calling resume on processor");
        this.m_processor.resume();
        log.debug((Object)"Processor resumed");
        this.m_status = 2;
        log.debug((Object)"Trapd resumed");
    }

    public synchronized void stop() {
        Category log = ThreadCategory.getInstance(this.getClass());
        this.m_status = 3;
        log.debug((Object)"exit: closing communication paths.");
        try {
            log.debug((Object)"stop: Closing SNMP trap session.");
            SnmpUtils.unregisterForTraps((TrapNotificationListener)this, (int)this.m_trapdConfig.getSnmpTrapPort());
            log.debug((Object)"stop: SNMP trap session closed.");
        }
        catch (IOException e) {
            log.warn((Object)"stop: exception occurred closing session", (Throwable)e);
        }
        catch (IllegalStateException e) {
            log.debug((Object)"stop: The SNMP session was already closed");
        }
        log.debug((Object)"stop: Stopping queue processor.");
        this.m_processor.stop();
        this.m_eventReader.close();
        this.m_status = 4;
        log.debug((Object)"stop: Trapd stopped");
    }

    public synchronized int getStatus() {
        return this.m_status;
    }

    public static TrapHandler getInstance() {
        return m_singleton;
    }

    public String getName() {
        return this.m_name;
    }

    public EventIpcManager getEventManager() {
        return this.m_eventMgr;
    }

    public void setEventManager(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    public void trapError(int error, String msg) {
        Category log = ThreadCategory.getInstance(this.getClass());
        log.warn((Object)("Error Processing Received Trap: error = " + error + (msg != null ? ", ref = " + msg : "")));
    }
}

