/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.util.Date;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.threshd.LatencyInterface;
import org.opennms.netmgt.threshd.LatencyParameters;
import org.opennms.netmgt.threshd.ThresholdingException;
import org.opennms.netmgt.xml.event.Events;

final class ThresholdEntity
implements Cloneable {
    static final int NONE_TRIGGERED = 0;
    static final int HIGH_TRIGGERED = 1;
    static final int LOW_TRIGGERED = 2;
    static final int HIGH_AND_LOW_TRIGGERED = 3;
    static final int HIGH_REARMED = 4;
    static final int LOW_REARMED = 5;
    static final int HIGH_AND_LOW_REARMED = 6;
    static final String HIGH_THRESHOLD = "high";
    static final String LOW_THRESHOLD = "low";
    private Threshold m_highThreshold = null;
    private Threshold m_lowThreshold = null;
    private int m_highCount;
    private int m_lowCount;
    private boolean m_highArmed;
    private boolean m_lowArmed;

    ThresholdEntity() {
    }

    void setHighThreshold(Threshold threshold) {
        if (this.m_highThreshold != null) {
            throw new IllegalStateException("High threshold already set.");
        }
        this.m_highThreshold = threshold;
        this.m_highCount = 0;
        this.m_highArmed = true;
    }

    void setLowThreshold(Threshold threshold) {
        if (this.m_lowThreshold != null) {
            throw new IllegalStateException("Low threshold already set.");
        }
        this.m_lowThreshold = threshold;
        this.m_lowCount = 0;
        this.m_lowArmed = true;
    }

    boolean hasHighThreshold() {
        return this.m_highThreshold != null;
    }

    boolean hasLowThreshold() {
        return this.m_lowThreshold != null;
    }

    Threshold getHighThreshold() {
        return this.m_highThreshold;
    }

    Threshold getLowThreshold() {
        return this.m_lowThreshold;
    }

    String getDatasourceName() {
        if (this.hasHighThreshold()) {
            return this.m_highThreshold.getDsName();
        }
        if (this.hasLowThreshold()) {
            return this.m_lowThreshold.getDsName();
        }
        throw new IllegalStateException("Neither high nor low threshold set.");
    }

    String getDatasourceType() {
        if (this.hasHighThreshold()) {
            return this.m_highThreshold.getDsType();
        }
        if (this.hasLowThreshold()) {
            return this.m_lowThreshold.getDsType();
        }
        throw new IllegalStateException("Neither high nor low threshold set.");
    }

    double getHighValue() {
        if (this.m_highThreshold == null) {
            throw new IllegalStateException("High threshold not set.");
        }
        return this.m_highThreshold.getValue();
    }

    double getLowValue() {
        if (this.m_lowThreshold == null) {
            throw new IllegalStateException("Low threshold not set.");
        }
        return this.m_lowThreshold.getValue();
    }

    double getHighRearm() {
        if (this.m_highThreshold == null) {
            throw new IllegalStateException("High threshold not set.");
        }
        return this.m_highThreshold.getRearm();
    }

    double getLowRearm() {
        if (this.m_lowThreshold == null) {
            throw new IllegalStateException("Low threshold not set.");
        }
        return this.m_lowThreshold.getRearm();
    }

    int getHighTrigger() {
        if (this.m_highThreshold == null) {
            throw new IllegalStateException("High threshold not set.");
        }
        return this.m_highThreshold.getTrigger();
    }

    int getLowTrigger() {
        if (this.m_lowThreshold == null) {
            throw new IllegalStateException("Low threshold not set.");
        }
        return this.m_lowThreshold.getTrigger();
    }

    String getDatasourceLabel() {
        if (this.hasHighThreshold()) {
            return this.m_highThreshold.getDsLabel();
        }
        if (this.hasLowThreshold()) {
            return this.m_lowThreshold.getDsLabel();
        }
        return null;
    }

    public Object clone() {
        ThresholdEntity clone = new ThresholdEntity();
        if (this.hasHighThreshold()) {
            clone.setHighThreshold(this.m_highThreshold);
        }
        if (this.hasLowThreshold()) {
            clone.setLowThreshold(this.m_lowThreshold);
        }
        return clone;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (!this.hasHighThreshold() && !this.hasLowThreshold()) {
            return buffer.toString();
        }
        buffer.append("dsName=").append(this.getDatasourceName());
        buffer.append(",dsType=").append(this.getDatasourceType()).append(":");
        if (this.hasHighThreshold()) {
            buffer.append(" highVal=").append(this.m_highThreshold.getValue());
            buffer.append(",highRearm=").append(this.m_highThreshold.getRearm());
            buffer.append(",highTrigger=").append(this.m_highThreshold.getTrigger());
        }
        if (this.hasLowThreshold()) {
            buffer.append(",lowVal=").append(this.m_lowThreshold.getValue());
            buffer.append(",lowRearm=").append(this.m_lowThreshold.getRearm());
            buffer.append(",lowTrigger=").append(this.m_lowThreshold.getTrigger());
        }
        return buffer.toString();
    }

    int evaluate(double dsValue) {
        Category log = ThreadCategory.getInstance(this.getClass());
        boolean highTriggered = false;
        boolean lowTriggered = false;
        boolean highRearmed = false;
        boolean lowRearmed = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("evaluate: value= " + dsValue + " against threshold: " + this));
        }
        if (this.hasHighThreshold()) {
            if (dsValue >= this.m_highThreshold.getValue()) {
                if (this.m_highArmed) {
                    ++this.m_highCount;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("evaluate: high threshold exceeded, count=" + this.m_highCount));
                    }
                    if (this.m_highCount >= this.m_highThreshold.getTrigger()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"evaluate: high threshold triggered!");
                        }
                        highTriggered = true;
                        this.m_highCount = 0;
                        this.m_highArmed = false;
                    }
                }
            } else if (dsValue <= this.m_highThreshold.getRearm()) {
                if (!this.m_highArmed) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"evaluate: high threshold rearmed!");
                    }
                    this.m_highArmed = true;
                    highRearmed = true;
                    this.m_highCount = 0;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"evaluate: resetting high threshold count to 0");
                }
                this.m_highCount = 0;
            }
        }
        if (this.hasLowThreshold()) {
            if (dsValue <= this.m_lowThreshold.getValue()) {
                if (this.m_lowArmed) {
                    ++this.m_lowCount;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("evaluate: low threshold exceeded, count=" + this.m_lowCount));
                    }
                    if (this.m_lowCount >= this.m_lowThreshold.getTrigger()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"evaluate: low threshold triggered!");
                        }
                        lowTriggered = true;
                        this.m_lowCount = 0;
                        this.m_lowArmed = false;
                    }
                }
            } else if (dsValue >= this.m_lowThreshold.getRearm()) {
                if (!this.m_lowArmed) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"evaluate: low threshold rearmed!");
                    }
                    this.m_lowArmed = true;
                    lowRearmed = true;
                    this.m_lowCount = 0;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"evaluate: resetting low threshold count to 0");
                }
                this.m_lowCount = 0;
            }
        }
        if (lowTriggered && highTriggered) {
            return 3;
        }
        if (lowTriggered) {
            return 2;
        }
        if (highTriggered) {
            return 1;
        }
        if (lowRearmed && highRearmed) {
            return 6;
        }
        if (lowRearmed) {
            return 5;
        }
        if (highRearmed) {
            return 4;
        }
        return 0;
    }

    private final Category log() {
        return ThreadCategory.getInstance(ThresholdEntity.class);
    }

    Double fetchLastValue(LatencyInterface latIface, LatencyParameters latParms) throws ThresholdingException {
        String datasource = this.getDatasourceName();
        Double dsValue = null;
        try {
            if (this.getDatasourceType().equals("if")) {
                this.log().debug((Object)("Fetching last value from dataSource '" + datasource + "'"));
                File rrdFile = new File(latIface.getLatencyDir(), datasource + RrdUtils.getExtension());
                if (!rrdFile.exists()) {
                    this.log().info((Object)("rrd file " + rrdFile + " does not exist"));
                    return null;
                }
                if (!rrdFile.canRead()) {
                    this.log().error((Object)("Unable to read existing rrd file " + rrdFile));
                    return null;
                }
                dsValue = latParms.getRange() == 0 ? RrdUtils.fetchLastValue((String)rrdFile.getAbsolutePath(), (int)latParms.getInterval()) : RrdUtils.fetchLastValueInRange((String)rrdFile.getAbsolutePath(), (int)latParms.getInterval(), (int)latParms.getRange());
            } else {
                throw new ThresholdingException("expr types not yet implemented", 2);
            }
            this.log().debug((Object)("Last value from dataSource '" + datasource + "' was " + dsValue));
        }
        catch (NumberFormatException nfe) {
            this.log().warn((Object)("Unable to convert retrieved value for datasource '" + datasource + "' to a double, skipping evaluation."));
        }
        catch (RrdException e) {
            this.log().error((Object)("An error occurred retriving the last value for datasource '" + datasource + "'"), (Throwable)e);
        }
        return dsValue;
    }

    void evaluateThreshold(Double dsValue, Events events, Date date, LatencyInterface latIface) throws ThresholdingException {
        int result;
        if (dsValue != null && !dsValue.isNaN() && (result = this.evaluate(dsValue)) != 0) {
            if (result == 3 || result == 1) {
                events.addEvent(latIface.createEvent(dsValue, this.getHighThreshold(), "uei.opennms.org/threshold/highThresholdExceeded", date));
            }
            if (result == 3 || result == 2) {
                events.addEvent(latIface.createEvent(dsValue, this.getLowThreshold(), "uei.opennms.org/threshold/lowThresholdExceeded", date));
            }
            if (result == 6 || result == 4) {
                events.addEvent(latIface.createEvent(dsValue, this.getHighThreshold(), "uei.opennms.org/threshold/highThresholdRearmed", date));
            }
            if (result == 6 || result == 5) {
                events.addEvent(latIface.createEvent(dsValue, this.getLowThreshold(), "uei.opennms.org/threshold/lowThresholdRearmed", date));
            }
        }
    }

    void setThreshold(Threshold thresh) {
        if (thresh.getType().equals(HIGH_THRESHOLD)) {
            this.setHighThreshold(thresh);
        } else if (thresh.getType().equals(LOW_THRESHOLD)) {
            this.setLowThreshold(thresh);
        }
    }
}

