/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.dao.support.RrdFileConstants;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.threshd.ServiceThresholder;
import org.opennms.netmgt.threshd.SnmpThresholdConfiguration;
import org.opennms.netmgt.threshd.SnmpThresholdInterface;
import org.opennms.netmgt.threshd.SnmpThresholderState;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdResourceType;
import org.opennms.netmgt.utils.EventProxy;
import org.opennms.netmgt.utils.EventProxyException;
import org.opennms.netmgt.utils.IfLabel;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SnmpThresholder
implements ServiceThresholder {
    static final String SQL_GET_NODEID = "SELECT nodeid,ifindex,issnmpprimary FROM ipinterface WHERE ipAddr=? AND ismanaged!='D'";
    private static final String SERVICE_NAME = "SNMP";

    SnmpThresholder() {
    }

    public String serviceName() {
        return SERVICE_NAME;
    }

    @Override
    public void initialize(Map parameters) {
        try {
            RrdUtils.initialize();
        }
        catch (RrdException e) {
            this.log().error((Object)"initialize: Unable to initialize RrdUtils", (Throwable)e);
            throw new RuntimeException("Unable to initialize RrdUtils", e);
        }
        this.log().debug((Object)"initialize: successfully instantiated JNI interface to RRD...");
    }

    @Override
    public void release() {
    }

    @Override
    public void initialize(NetworkInterface netIface, Map parms) {
        SnmpThresholdInterface snmpIface = SnmpThresholdInterface.get(netIface);
        SnmpThresholdConfiguration thresholdConfiguration = SnmpThresholdConfiguration.get(netIface, parms);
        if (!snmpIface.isIPV4()) {
            throw new RuntimeException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: dumping node thresholds defined for " + snmpIface.getIpAddress() + "/" + thresholdConfiguration.getGroupName() + ":"));
            Iterator<ThresholdEntity> iter = thresholdConfiguration.getNodeResourceType().getThresholdMap().values().iterator();
            while (iter.hasNext()) {
                this.log().debug((Object)iter.next());
            }
            this.log().debug((Object)("initialize: dumping interface thresholds defined for " + snmpIface.getIpAddress() + "/" + thresholdConfiguration.getGroupName() + ":"));
            iter = thresholdConfiguration.getIfResourceType().getThresholdMap().values().iterator();
            while (iter.hasNext()) {
                this.log().debug((Object)iter.next());
            }
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: initialization completed for " + snmpIface.getIpAddress()));
        }
    }

    @Override
    public void release(NetworkInterface iface) {
    }

    @Override
    public int check(NetworkInterface netIface, EventProxy eproxy, Map parms) {
        File nodeDirectory;
        SnmpThresholdInterface snmpIface = SnmpThresholdInterface.get(netIface);
        SnmpThresholdConfiguration thresholdConfiguration = SnmpThresholdConfiguration.get(netIface, parms);
        SnmpThresholderState thresholderState = SnmpThresholderState.get(netIface, parms);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("check: service= SNMP address= " + snmpIface.getIpAddress() + " thresholding-group=" + thresholdConfiguration.getGroupName() + " interval=" + thresholdConfiguration.getInterval() + "ms range=" + thresholdConfiguration.getRange() + " mS"));
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("check: rrd repository=" + thresholdConfiguration.getRrdRepository()));
        }
        if (!RrdFileConstants.isValidRRDNodeDir((File)(nodeDirectory = new File(thresholdConfiguration.getRrdRepository(), snmpIface.getNodeId().toString())))) {
            this.log().info((Object)("Node directory for " + snmpIface.getNodeId() + "/" + snmpIface.getIpAddress() + " does not exist or is not a valid RRD node directory."));
            this.log().info((Object)("Threshold checking failed for primary SNMP interface " + snmpIface.getIpAddress()));
            return 2;
        }
        Events events = new Events();
        Date dateStamp = new Date();
        try {
            this.checkNodeDir(nodeDirectory, snmpIface, thresholdConfiguration, dateStamp, events);
        }
        catch (IllegalArgumentException e) {
            this.log().info((Object)("check: Threshold checking failed for primary SNMP interface " + snmpIface.getIpAddress()), (Throwable)e);
            return 2;
        }
        File[] files = nodeDirectory.listFiles(RrdFileConstants.INTERFACE_DIRECTORY_FILTER);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    this.checkIfDir(files[i], snmpIface, thresholdConfiguration, dateStamp, thresholderState.getAllInterfaceMap(), events);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.log().info((Object)("check: Threshold checking failed for primary SNMP interface " + snmpIface.getIpAddress()), (Throwable)e);
                    return 2;
                }
            }
        }
        if (events.getEventCount() > 0) {
            try {
                Log eventLog = new Log();
                eventLog.setEvents(events);
                eproxy.send(eventLog);
            }
            catch (EventProxyException e) {
                this.log().info((Object)"check: Failed sending threshold events via event proxy...", (Throwable)e);
                return 2;
            }
        }
        return 1;
    }

    private void checkNodeDir(File directory, SnmpThresholdInterface snmpIface, SnmpThresholdConfiguration thresholdConfiguration, Date date, Events events) throws IllegalArgumentException {
        File[] files;
        ThresholdResourceType resourceType = thresholdConfiguration.getNodeResourceType();
        Map<String, ThresholdEntity> thresholdMap = resourceType.getThresholdMap();
        if (directory == null || snmpIface.getNodeId() == null || snmpIface.getInetAddress() == null || date == null || thresholdMap == null || events == null) {
            throw new IllegalArgumentException("Null parameters not permitted.");
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("checkNodeDir: threshold checking node dir: " + directory.getAbsolutePath()));
        }
        if ((files = directory.listFiles(RrdFileConstants.RRD_FILENAME_FILTER)) == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            int result;
            String filename = files[i].getName();
            String datasource = filename.substring(0, filename.indexOf(RrdUtils.getExtension()));
            ThresholdEntity threshold = thresholdMap.get(datasource);
            if (threshold == null) continue;
            String dsLabelValue = "Unknown";
            String propertiesFile = directory + "/strings.properties";
            Properties stringProps = new Properties();
            try {
                stringProps.load(new FileInputStream(propertiesFile));
                dsLabelValue = stringProps.getProperty(threshold.getDatasourceLabel());
            }
            catch (FileNotFoundException e) {
                this.log().debug((Object)("Label: No strings.properties file found for node id: " + snmpIface.getNodeId() + " looking here: " + propertiesFile));
            }
            catch (NullPointerException e) {
                this.log().debug((Object)("Label: No data source label for node id: " + snmpIface.getNodeId()));
            }
            catch (IOException e) {
                this.log().debug((Object)("Label: I/O exception when looking for strings.properties file for node id: " + snmpIface.getNodeId() + " looking here: " + propertiesFile));
            }
            Double dsValue = null;
            try {
                if (thresholdConfiguration.getRange() != 0) {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("checking values within " + thresholdConfiguration.getRange() + " mS of last possible PDP"));
                    }
                    dsValue = RrdUtils.fetchLastValueInRange((String)files[i].getAbsolutePath(), (int)thresholdConfiguration.getInterval(), (int)thresholdConfiguration.getRange());
                } else {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)"checking value of last possible PDP only");
                    }
                    dsValue = RrdUtils.fetchLastValue((String)files[i].getAbsolutePath(), (int)thresholdConfiguration.getInterval());
                }
            }
            catch (NumberFormatException nfe) {
                this.log().warn((Object)("Unable to convert retrieved value for datasource '" + datasource + "' to a double, skipping evaluation."));
            }
            catch (RrdException e) {
                this.log().info((Object)("An error occurred retriving the last value for datasource '" + datasource + "'"), (Throwable)e);
            }
            if (dsValue == null || dsValue.isNaN() || (result = threshold.evaluate(dsValue)) == 0) continue;
            if (result == 3 || result == 1) {
                events.addEvent(this.createEvent(snmpIface.getNodeId(), snmpIface.getInetAddress(), null, dsValue, threshold.getHighThreshold(), "uei.opennms.org/threshold/highThresholdExceeded", date, dsLabelValue));
            }
            if (result == 3 || result == 2) {
                events.addEvent(this.createEvent(snmpIface.getNodeId(), snmpIface.getInetAddress(), null, dsValue, threshold.getLowThreshold(), "uei.opennms.org/threshold/lowThresholdExceeded", date, dsLabelValue));
            }
            if (result == 6 || result == 4) {
                events.addEvent(this.createEvent(snmpIface.getNodeId(), snmpIface.getInetAddress(), null, dsValue, threshold.getHighThreshold(), "uei.opennms.org/threshold/highThresholdRearmed", date, dsLabelValue));
            }
            if (result != 6 && result != 5) continue;
            events.addEvent(this.createEvent(snmpIface.getNodeId(), snmpIface.getInetAddress(), null, dsValue, threshold.getLowThreshold(), "uei.opennms.org/threshold/lowThresholdRearmed", date, dsLabelValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfDir(File directory, SnmpThresholdInterface snmpIface, SnmpThresholdConfiguration thresholdConfiguration, Date date, Map allIfThresholdMap, Events events) throws IllegalArgumentException {
        File[] files;
        Map<String, ThresholdEntity> thresholdMap;
        ThresholdResourceType resourceType = thresholdConfiguration.getIfResourceType();
        if (directory == null || snmpIface.getNodeId() == null || snmpIface.getInetAddress() == null || date == null || resourceType.getThresholdMap() == null || allIfThresholdMap == null || events == null) {
            throw new IllegalArgumentException("Null parameters not permitted.");
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("checkIfDir: threshold checking interface dir: " + directory.getAbsolutePath()));
        }
        String ifLabel = directory.getName();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("checkIfDir: ifLabel=" + ifLabel));
        }
        if ((thresholdMap = (Map<String, ThresholdEntity>)allIfThresholdMap.get(ifLabel)) == null) {
            thresholdMap = this.getAttributeMap(resourceType);
            allIfThresholdMap.put(ifLabel, thresholdMap);
        }
        if ((files = directory.listFiles(RrdFileConstants.RRD_FILENAME_FILTER)) == null || files.length == 0) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("checkIfDir: no RRD files in dir: " + directory));
            }
            return;
        }
        Map<String, String> ifDataMap = null;
        for (int i = 0; i < files.length; ++i) {
            int result;
            ThresholdEntity threshold;
            String filename = files[i].getName();
            String datasource = filename.substring(0, filename.indexOf(RrdUtils.getExtension()));
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("checkIfDir: looking up datasource: " + datasource));
            }
            if ((threshold = thresholdMap.get(datasource)) == null) continue;
            String dsLabelValue = "Unknown";
            Double dsValue = null;
            try {
                if (thresholdConfiguration.getRange() != 0) {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("checking values within " + thresholdConfiguration.getRange() + " mS of last possible PDP"));
                    }
                    dsValue = RrdUtils.fetchLastValueInRange((String)files[i].getAbsolutePath(), (int)thresholdConfiguration.getInterval(), (int)thresholdConfiguration.getRange());
                } else {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)"checking value of last possible PDP only");
                    }
                    dsValue = RrdUtils.fetchLastValue((String)files[i].getAbsolutePath(), (int)thresholdConfiguration.getInterval());
                }
            }
            catch (NumberFormatException nfe) {
                this.log().warn((Object)("Unable to convert retrieved value for datasource '" + datasource + "' to a double, skipping evaluation."));
            }
            catch (RrdException e) {
                this.log().info((Object)("An error occurred retriving the last value for datasource '" + datasource + "'"), (Throwable)e);
            }
            if (dsValue == null || dsValue.isNaN() || (result = threshold.evaluate(dsValue)) == 0) continue;
            if (ifLabel != null && ifDataMap == null) {
                Connection dbConn = null;
                try {
                    dbConn = DataSourceFactory.getInstance().getConnection();
                }
                catch (SQLException sqlE) {
                    this.log().error((Object)"checkIfDir: Failed getting connection to the database.", (Throwable)sqlE);
                    throw new UndeclaredThrowableException(sqlE);
                }
                try {
                    ifDataMap = IfLabel.getInterfaceInfoFromIfLabel(dbConn, snmpIface.getNodeId(), ifLabel);
                }
                catch (SQLException e) {
                    this.log().warn((Object)("Failed to retrieve interface info from database using ifLabel '" + ifLabel));
                    ifDataMap = new HashMap<String, String>();
                }
                finally {
                    try {
                        if (dbConn != null) {
                            dbConn.close();
                        }
                    }
                    catch (SQLException sqle) {
                        this.log().info((Object)"checkIfDir: SQLException while closing database connection", (Throwable)sqle);
                    }
                }
                ifDataMap.put("iflabel", ifLabel);
            }
            if (result == 3 || result == 1) {
                events.addEvent(this.createEvent(snmpIface.getNodeId(), snmpIface.getInetAddress(), ifDataMap, dsValue, threshold.getHighThreshold(), "uei.opennms.org/threshold/highThresholdExceeded", date, dsLabelValue));
            }
            if (result == 3 || result == 2) {
                events.addEvent(this.createEvent(snmpIface.getNodeId(), snmpIface.getInetAddress(), ifDataMap, dsValue, threshold.getLowThreshold(), "uei.opennms.org/threshold/lowThresholdExceeded", date, dsLabelValue));
            }
            if (result == 6 || result == 4) {
                events.addEvent(this.createEvent(snmpIface.getNodeId(), snmpIface.getInetAddress(), ifDataMap, dsValue, threshold.getHighThreshold(), "uei.opennms.org/threshold/highThresholdRearmed", date, dsLabelValue));
            }
            if (result != 6 && result != 5) continue;
            events.addEvent(this.createEvent(snmpIface.getNodeId(), snmpIface.getInetAddress(), ifDataMap, dsValue, threshold.getLowThreshold(), "uei.opennms.org/threshold/lowThresholdRearmed", date, dsLabelValue));
        }
    }

    private Map<String, ThresholdEntity> getAttributeMap(ThresholdResourceType resourceType) {
        HashMap<String, ThresholdEntity> thresholdMap = new HashMap<String, ThresholdEntity>();
        for (ThresholdEntity entity : resourceType.getThresholdMap().values()) {
            thresholdMap.put(entity.getDatasourceName(), (ThresholdEntity)entity.clone());
        }
        return thresholdMap;
    }

    private Event createEvent(Integer nodeId, InetAddress primary, Map ifDataMap, double dsValue, Threshold threshold, String uei, Date date, String label) {
        if (nodeId == null || primary == null || threshold == null) {
            throw new IllegalArgumentException("nodeid, primary, and threshold cannot be null.");
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("createEvent: nodeId=" + nodeId + " primaryAddr=" + primary + " ds=" + threshold.getDsName() + " uei=" + uei));
            if (ifDataMap != null) {
                this.log().debug((Object)("createEvent: specific interface data: ifAddr=" + (String)ifDataMap.get("ipaddr") + " macAddr=" + (String)ifDataMap.get("snmpphysaddr") + " ifName=" + (String)ifDataMap.get("snmpifname") + " ifDescr=" + (String)ifDataMap.get("snmpifdescr") + " ifIndex=" + (String)ifDataMap.get("snmpifindex") + " ifLabel=" + (String)ifDataMap.get("iflabel")));
            }
        }
        Event newEvent = new Event();
        newEvent.setUei(uei);
        newEvent.setNodeid(nodeId.longValue());
        newEvent.setService(this.serviceName());
        newEvent.setSource("OpenNMS.Threshd." + threshold.getDsName());
        if (ifDataMap == null || ifDataMap.get("ipaddr") == null) {
            if (primary != null) {
                newEvent.setInterface(primary.getHostAddress());
            }
        } else {
            String ifAddr = (String)ifDataMap.get("ipaddr");
            newEvent.setInterface(ifAddr);
        }
        try {
            newEvent.setHost(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException uhE) {
            newEvent.setHost("unresolved.host");
            this.log().warn((Object)"Failed to resolve local hostname", (Throwable)uhE);
        }
        newEvent.setTime(EventConstants.formatToString(date));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("ds");
        parmValue = new Value();
        parmValue.setContent(threshold.getDsName());
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("value");
        parmValue = new Value();
        parmValue.setContent(Double.toString(dsValue));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("threshold");
        parmValue = new Value();
        parmValue.setContent(Double.toString(threshold.getValue()));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("trigger");
        parmValue = new Value();
        parmValue.setContent(Integer.toString(threshold.getTrigger()));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("rearm");
        parmValue = new Value();
        parmValue.setContent(Double.toString(threshold.getRearm()));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        if (label != null) {
            eventParm = new Parm();
            eventParm.setParmName("label");
            parmValue = new Value();
            parmValue.setContent(label);
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (ifDataMap != null && ifDataMap.get("iflabel") != null) {
            eventParm = new Parm();
            eventParm.setParmName("ifLabel");
            parmValue = new Value();
            parmValue.setContent((String)ifDataMap.get("iflabel"));
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (ifDataMap != null && ifDataMap.get("snmpifindex") != null) {
            eventParm = new Parm();
            eventParm.setParmName("ifIndex");
            parmValue = new Value();
            parmValue.setContent((String)ifDataMap.get("snmpifindex"));
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        newEvent.setParms(eventParms);
        return newEvent;
    }

    Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

