/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.net.InetAddress;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.utils.Querier;
import org.opennms.netmgt.utils.RowProcessor;

public class SnmpThresholdInterface {
    private static final String SNMP_THRESH_IFACE_KEY = SnmpThresholdInterface.class.getName();
    private NetworkInterface m_netInterface;
    static final String NODE_ID_KEY = "org.opennms.netmgt.collectd.SnmpThresholder.NodeId";
    static final String PRIMARY_IFINDEX_KEY = "org.opennms.netmgt.collectd.SnmpThresholder.primaryIfIndex";
    static final String IS_SNMP_PRIMARY_KEY = "org.opennms.netmgt.collectd.SnmpThresholder.isSnmpPrimary";
    static final String ALL_IF_THRESHOLD_MAP_KEY = "org.opennms.netmgt.collectd.SnmpThresholder.AllIfThresholdMap";

    public static SnmpThresholdInterface get(NetworkInterface iface) {
        SnmpThresholdInterface snmpIface = (SnmpThresholdInterface)iface.getAttribute(SNMP_THRESH_IFACE_KEY);
        if (snmpIface == null) {
            snmpIface = new SnmpThresholdInterface(iface);
            iface.setAttribute(SNMP_THRESH_IFACE_KEY, snmpIface);
        }
        return snmpIface;
    }

    public SnmpThresholdInterface(NetworkInterface iface) {
        this.m_netInterface = iface;
        this.initialize();
    }

    public NetworkInterface getNetworkInterface() {
        return this.m_netInterface;
    }

    boolean isIPV4() {
        return this.getNetworkInterface().getType() == 1;
    }

    InetAddress getInetAddress() {
        return (InetAddress)this.getNetworkInterface().getAddress();
    }

    String getIpAddress() {
        return this.getInetAddress().getHostAddress();
    }

    void setNodeId(Integer nodeId) {
        this.getNetworkInterface().setAttribute(NODE_ID_KEY, nodeId);
    }

    Integer getNodeId() {
        return (Integer)this.getNetworkInterface().getAttribute(NODE_ID_KEY);
    }

    void setPrimaryIfIndex(Integer primaryIfIndex) {
        this.getNetworkInterface().setAttribute(PRIMARY_IFINDEX_KEY, primaryIfIndex);
    }

    Integer getPrimaryIfIndex() {
        return (Integer)this.getNetworkInterface().getAttribute(PRIMARY_IFINDEX_KEY);
    }

    void setIsSnmpPrimary(String isSnmpPrimary) {
        if (isSnmpPrimary == null || isSnmpPrimary.length() < 1) {
            this.setIsSnmpPrimary('N');
        } else {
            this.setIsSnmpPrimary(isSnmpPrimary.charAt(0));
        }
    }

    void setIsSnmpPrimary(char isSnmpPrimary) {
        this.getNetworkInterface().setAttribute(IS_SNMP_PRIMARY_KEY, new Character(isSnmpPrimary));
    }

    char getIsSnmpPrimary() {
        Character val = (Character)this.getNetworkInterface().getAttribute(IS_SNMP_PRIMARY_KEY);
        return val == null ? (char)'N' : (char)val.charValue();
    }

    void initialize() {
        Querier querier = new Querier(DataSourceFactory.getDataSource(), "SELECT nodeid,ifindex,issnmpprimary FROM ipinterface WHERE ipAddr=? AND ismanaged!='D'", new RowProcessor(){

            public void processRow(ResultSet rs) throws SQLException {
                SnmpThresholdInterface.this.setNodeId(SnmpThresholdInterface.getInteger(rs, 1));
                SnmpThresholdInterface.this.setPrimaryIfIndex(SnmpThresholdInterface.getInteger(rs, 2));
                SnmpThresholdInterface.this.setIsSnmpPrimary(rs.getString(3));
            }
        });
        querier.execute(this.getIpAddress());
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: db retrieval info: nodeid = " + this.getNodeId() + ", address = " + this.getIpAddress() + ", ifIndex = " + this.getPrimaryIfIndex() + ", isSnmpPrimary = " + this.getIsSnmpPrimary()));
        }
        if (this.getNodeId() == null) {
            throw new RuntimeException("Unable to retrieve node id for interface " + this.getIpAddress());
        }
        if (this.getPrimaryIfIndex() == null && this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: db retrieval info: node " + this.getNodeId() + " does not have a legitimate primaryIfIndex. Assume node does not supply ipAddrTable and continue..."));
        }
        if (this.getIsSnmpPrimary() != 'P') {
            throw new RuntimeException("Interface " + this.getIpAddress() + " is not the primary SNMP interface for nodeid " + this.getNodeId());
        }
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    static Integer getInteger(ResultSet rs, int columnIndex) throws SQLException {
        int val = rs.getInt(columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        return new Integer(val);
    }
}

