/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.threshd.DefaultThresholdsDao;
import org.opennms.netmgt.threshd.ThresholdGroup;
import org.opennms.netmgt.threshd.ThresholdResourceType;
import org.opennms.netmgt.utils.ParameterMap;

public class SnmpThresholdConfiguration {
    private static final int DEFAULT_INTERVAL = 300000;
    private static final int DEFAULT_RANGE = 0;
    private static final String THRESHD_SERVICE_CONFIG_KEY = SnmpThresholdConfiguration.class.getName();
    private Map m_parms;
    private ThresholdGroup m_thresholdGroup;

    public static SnmpThresholdConfiguration get(NetworkInterface iface, Map parms) {
        SnmpThresholdConfiguration config = (SnmpThresholdConfiguration)iface.getAttribute(THRESHD_SERVICE_CONFIG_KEY);
        if (config == null) {
            config = new SnmpThresholdConfiguration(parms);
            iface.setAttribute(THRESHD_SERVICE_CONFIG_KEY, config);
        }
        return config;
    }

    private SnmpThresholdConfiguration(Map parms) {
        this.m_parms = parms;
        DefaultThresholdsDao dao = new DefaultThresholdsDao();
        this.m_thresholdGroup = dao.get(ParameterMap.getKeyedString(this.m_parms, "thresholding-group", "default"));
    }

    File getRrdRepository() {
        return this.m_thresholdGroup.getRrdRepository();
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public String getGroupName() {
        return this.m_thresholdGroup.getName();
    }

    public int getRange() {
        return ParameterMap.getKeyedInteger(this.m_parms, "range", 0);
    }

    public int getInterval() {
        return ParameterMap.getKeyedInteger(this.m_parms, "interval", 300000);
    }

    public ThresholdResourceType getIfResourceType() {
        return this.m_thresholdGroup.getIfResourceType();
    }

    public ThresholdResourceType getNodeResourceType() {
        return this.m_thresholdGroup.getNodeResourceType();
    }

    public void setIfResourceType(ThresholdResourceType ifResourceType) {
        this.m_thresholdGroup.setIfResourceType(ifResourceType);
    }

    public void setNodeResourceType(ThresholdResourceType nodeResourceType) {
        this.m_thresholdGroup.setNodeResourceType(nodeResourceType);
    }
}

