/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.threshd.ThresholdEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpThresholdConfig {
    private ThresholdingConfigFactory m_thresholdConfig;

    public SnmpThresholdConfig(ThresholdingConfigFactory instance) {
        this.m_thresholdConfig = instance;
    }

    Map<String, ThresholdEntity> createThresholdMap(String groupName, String dsType) {
        HashMap<String, ThresholdEntity> thresholdMap = new HashMap<String, ThresholdEntity>();
        for (Threshold thresh : ThresholdingConfigFactory.getInstance().getThresholds(groupName)) {
            if (!thresh.getDsType().equals(dsType)) continue;
            ThresholdEntity thresholdEntity = (ThresholdEntity)thresholdMap.get(thresh.getDsName());
            if (thresholdEntity == null) {
                thresholdEntity = new ThresholdEntity();
                thresholdMap.put(thresh.getDsName(), thresholdEntity);
            }
            try {
                thresholdEntity.setThreshold(thresh);
            }
            catch (IllegalStateException e) {
                this.log().warn((Object)("Encountered duplicate " + thresh.getType() + " for datasource " + thresh.getDsName()), (Throwable)e);
            }
        }
        return thresholdMap;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    String getRrdRepository(String groupName) {
        return ThresholdingConfigFactory.getInstance().getRrdRepository(groupName);
    }
}

