/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.threshd.LatencyInterface;
import org.opennms.netmgt.threshd.LatencyParameters;
import org.opennms.netmgt.threshd.ServiceThresholder;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdingException;
import org.opennms.netmgt.utils.EventProxy;
import org.opennms.netmgt.utils.EventProxyException;
import org.opennms.netmgt.utils.ParameterMap;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;

final class LatencyThresholder
implements ServiceThresholder {
    private static final String SQL_GET_NODEID = "SELECT nodeid FROM ipinterface WHERE ipAddr=? AND ismanaged!='D'";
    static final int DEFAULT_INTERVAL = 300000;
    static final int DEFAULT_RANGE = 0;
    static final String RRD_REPOSITORY_KEY = "org.opennms.netmgt.collectd.LatencyThresholder.RrdRepository";
    static final String THRESHOLD_MAP_KEY = "org.opennms.netmgt.collectd.LatencyThresholder.ThresholdMap";
    static final String NODE_ID_KEY = "org.opennms.netmgt.collectd.SnmpThresholder.NodeId";
    private String m_svcName;
    private String m_host;

    LatencyThresholder() {
    }

    public String serviceName() {
        return this.m_svcName;
    }

    public void initialize(Map parameters) {
        Category log = this.log();
        this.m_svcName = (String)parameters.get("svcName");
        if (log.isDebugEnabled()) {
            log.debug((Object)("initialize: latency thresholder for service '" + this.m_svcName + "'"));
        }
        try {
            this.m_host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            if (log.isEnabledFor(Priority.WARN)) {
                log.warn((Object)"initialize: Unable to resolve local host name.", (Throwable)e);
            }
            this.m_host = "unresolved.host";
        }
        try {
            RrdUtils.initialize();
        }
        catch (RrdException e) {
            if (log.isEnabledFor(Priority.ERROR)) {
                log.error((Object)"initialize: Unable to initialize RrdUtils", (Throwable)e);
            }
            throw new RuntimeException("Unable to initialize RrdUtils", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"initialize: successfully instantiated JNI interface to RRD...");
        }
    }

    public void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(NetworkInterface iface, Map parameters) {
        Category log = this.log();
        if (iface.getType() != 1) {
            throw new RuntimeException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        InetAddress ipAddr = (InetAddress)iface.getAddress();
        String groupName = ParameterMap.getKeyedString(parameters, "thresholding-group", "default");
        String repository = null;
        try {
            repository = ThresholdingConfigFactory.getInstance().getRrdRepository(groupName);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Thresholding group '" + groupName + "' does not exist.");
        }
        iface.setAttribute(RRD_REPOSITORY_KEY, repository);
        Connection dbConn = null;
        try {
            dbConn = DataSourceFactory.getInstance().getConnection();
        }
        catch (SQLException sqlE) {
            if (log.isEnabledFor(Priority.ERROR)) {
                log.error((Object)"initialize: Failed getting connection to the database.", (Throwable)sqlE);
            }
            throw new UndeclaredThrowableException(sqlE);
        }
        int nodeId = -1;
        try {
            PreparedStatement stmt = null;
            try {
                stmt = dbConn.prepareStatement(SQL_GET_NODEID);
                stmt.setString(1, ipAddr.getHostAddress());
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    nodeId = rs.getInt(1);
                    if (rs.wasNull()) {
                        nodeId = -1;
                    }
                }
                rs.close();
            }
            catch (SQLException sqle) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"initialize: SQL exception!!", (Throwable)sqle);
                }
                throw new RuntimeException("SQL exception while attempting to retrieve node id for interface " + ipAddr.getHostAddress());
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("initialize: db retrieval info: nodeid = " + nodeId + ", address = " + ipAddr.getHostAddress()));
            }
            if (nodeId == -1) {
                throw new RuntimeException("Unable to retrieve node id for interface " + ipAddr.getHostAddress());
            }
        }
        finally {
            block42: {
                try {
                    dbConn.close();
                }
                catch (SQLException sqle) {
                    if (!log.isEnabledFor(Priority.INFO)) break block42;
                    log.info((Object)"initialize: SQLException while closing database connection", (Throwable)sqle);
                }
            }
        }
        iface.setAttribute(NODE_ID_KEY, new Integer(nodeId));
        HashMap<String, ThresholdEntity> thresholdMap = new HashMap<String, ThresholdEntity>();
        try {
            for (Threshold thresh : ThresholdingConfigFactory.getInstance().getThresholds(groupName)) {
                boolean newEntity = false;
                ThresholdEntity thresholdEntity = null;
                if (!thresh.getDsType().equals("if") && !thresh.getDsType().equals("expr")) {
                    log.warn((Object)"initialize: invalid datasource type, latency thresholder only supports interface level datasources.");
                    continue;
                }
                thresholdEntity = (ThresholdEntity)thresholdMap.get(thresh.getDsName());
                if (thresholdEntity == null) {
                    newEntity = true;
                    thresholdEntity = new ThresholdEntity();
                }
                try {
                    if (thresh.getType().equals("high")) {
                        thresholdEntity.setHighThreshold(thresh);
                    } else if (thresh.getType().equals("low")) {
                        thresholdEntity.setLowThreshold(thresh);
                    }
                }
                catch (IllegalStateException e) {
                    log.warn((Object)("Encountered duplicate " + thresh.getType() + " for datasource " + thresh.getDsName()), (Throwable)e);
                }
                if (!newEntity) continue;
                thresholdMap.put(thresh.getDsName(), thresholdEntity);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Thresholding group '" + groupName + "' does not exist.");
        }
        iface.setAttribute(THRESHOLD_MAP_KEY, thresholdMap);
        if (log.isDebugEnabled()) {
            log.debug((Object)("initialize: dumping interface thresholds defined for " + ipAddr.getHostAddress() + "/" + groupName + ":"));
            Iterator<Object> iter = thresholdMap.values().iterator();
            while (iter.hasNext()) {
                log.debug((Object)((ThresholdEntity)iter.next()));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("initialize: initialization completed for " + ipAddr.getHostAddress()));
        }
    }

    public void release(NetworkInterface iface) {
    }

    public int check(NetworkInterface iface, EventProxy eproxy, Map parameters) {
        LatencyInterface latIface = new LatencyInterface(iface, this.m_svcName);
        LatencyParameters latParms = new LatencyParameters(parameters, this.m_svcName);
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("check: service= " + this.m_svcName + " interface= " + latIface.getHostName() + " nodeId= " + latIface.getNodeId() + " thresholding-group=" + latParms.getGroupName() + " interval=" + latParms.getInterval() + "ms"));
            }
            Events events = this.checkRrdDir(latIface, latParms);
            this.sendEvents(eproxy, events);
            return 1;
        }
        catch (ThresholdingException e) {
            this.log().error((Object)e.getMessage());
            return e.getFailureCode();
        }
        catch (EventProxyException e) {
            this.log().error((Object)"check: Failed sending threshold events via event proxy...", (Throwable)e);
            return 2;
        }
    }

    private void sendEvents(EventProxy eproxy, Events events) throws EventProxyException {
        if (events != null && events.getEventCount() > 0) {
            Log eventLog = new Log();
            eventLog.setEvents(events);
            eproxy.send(eventLog);
        }
    }

    Events checkRrdDir(LatencyInterface latIface, LatencyParameters latParms) throws IllegalArgumentException, ThresholdingException {
        Map thresholdMap = latIface.getThresholdMap();
        if (latIface.getInetAddress() == null || thresholdMap == null) {
            throw new ThresholdingException("check: Threshold checking failed for " + this.m_svcName + "/" + latIface.getHostName(), 2);
        }
        Events events = new Events();
        Date date = new Date();
        for (String datasource : thresholdMap.keySet()) {
            ThresholdEntity threshold = (ThresholdEntity)thresholdMap.get(datasource);
            if (threshold == null) continue;
            Double dsValue = threshold.fetchLastValue(latIface, latParms);
            threshold.evaluateThreshold(dsValue, events, date, latIface);
        }
        return events;
    }

    public final Category log() {
        return ThreadCategory.getInstance(LatencyThresholder.class);
    }
}

