/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.dao.support.RrdFileConstants;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.threshd.ServiceThresholder;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.utils.EventProxy;
import org.opennms.netmgt.utils.EventProxyException;
import org.opennms.netmgt.utils.IfLabel;
import org.opennms.netmgt.utils.ParameterMap;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

public abstract class JMXThresholder
implements ServiceThresholder {
    private static final String SQL_GET_NODEID = "SELECT nodeid FROM ipinterface WHERE ipAddr=? AND ismanaged!='D'";
    private static final int DEFAULT_INTERVAL = 300000;
    private static final int DEFAULT_RANGE = 0;
    static final String NODE_ID_KEY = "org.opennms.netmgt.collectd.JMXThresholder.NodeId";
    static final String RRD_REPOSITORY_KEY = "org.opennms.netmgt.collectd.JMXThresholder.RrdRepository";
    static final String NODE_THRESHOLD_MAP_KEY = "org.opennms.netmgt.collectd.JMXThresholder.NodeThresholdMap";
    static final String BASE_IF_THRESHOLD_MAP_KEY = "org.opennms.netmgt.collectd.JMXThresholder.IfThresholdMap";
    static final String ALL_IF_THRESHOLD_MAP_KEY = "org.opennms.netmgt.collectd.JMXThresholder.AllIfThresholdMap";
    private String serviceName = null;
    private boolean useFriendlyName = false;

    public void setServiceName(String name) {
        this.serviceName = name;
    }

    public String serviceName() {
        return this.serviceName.toUpperCase();
    }

    public void initialize(Map parameters) {
        Category log = ThreadCategory.getInstance(this.getClass());
        try {
            RrdUtils.initialize();
        }
        catch (RrdException e) {
            if (log.isEnabledFor(Priority.ERROR)) {
                log.error((Object)"initialize: Unable to initialize RrdUtils", (Throwable)e);
            }
            throw new RuntimeException("Unable to initialize RrdUtils", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"initialize: successfully instantiated JNI interface to RRD...");
        }
    }

    public void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(NetworkInterface iface, Map parameters) {
        Category log = ThreadCategory.getInstance(this.getClass());
        if (iface.getType() != 1) {
            throw new RuntimeException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        InetAddress ipAddr = (InetAddress)iface.getAddress();
        String groupName = ParameterMap.getKeyedString(parameters, "thresholding-group", this.serviceName);
        String repository = null;
        try {
            repository = ThresholdingConfigFactory.getInstance().getRrdRepository(groupName);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Thresholding group '" + groupName + "' does not exist.");
        }
        iface.setAttribute(RRD_REPOSITORY_KEY, repository);
        HashMap<String, ThresholdEntity> nodeMap = new HashMap<String, ThresholdEntity>();
        HashMap<String, ThresholdEntity> baseIfMap = new HashMap<String, ThresholdEntity>();
        try {
            for (Threshold thresh : ThresholdingConfigFactory.getInstance().getThresholds(groupName)) {
                boolean newEntity = false;
                ThresholdEntity thresholdEntity = null;
                if (thresh.getDsType().equals("node")) {
                    thresholdEntity = (ThresholdEntity)nodeMap.get(thresh.getDsName());
                } else if (thresh.getDsType().equals("if")) {
                    thresholdEntity = (ThresholdEntity)baseIfMap.get(thresh.getDsName());
                }
                if (thresholdEntity == null) {
                    newEntity = true;
                    thresholdEntity = new ThresholdEntity();
                }
                try {
                    if (thresh.getType().equals("high")) {
                        thresholdEntity.setHighThreshold(thresh);
                    } else if (thresh.getType().equals("low")) {
                        thresholdEntity.setLowThreshold(thresh);
                    }
                }
                catch (IllegalStateException e) {
                    log.warn((Object)("Encountered duplicate " + thresh.getType() + " for datasource " + thresh.getDsName()), (Throwable)e);
                }
                if (!newEntity) continue;
                if (thresh.getDsType().equals("node")) {
                    nodeMap.put(thresh.getDsName(), thresholdEntity);
                    continue;
                }
                if (!thresh.getDsType().equals("if")) continue;
                baseIfMap.put(thresh.getDsName(), thresholdEntity);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Thresholding group '" + groupName + "' does not exist.");
        }
        iface.setAttribute(NODE_THRESHOLD_MAP_KEY, nodeMap);
        iface.setAttribute(BASE_IF_THRESHOLD_MAP_KEY, baseIfMap);
        iface.setAttribute(ALL_IF_THRESHOLD_MAP_KEY, new HashMap());
        Connection dbConn = null;
        try {
            dbConn = DataSourceFactory.getInstance().getConnection();
        }
        catch (SQLException sqlE) {
            if (log.isEnabledFor(Priority.ERROR)) {
                log.error((Object)"initialize: Failed getting connection to the database.", (Throwable)sqlE);
            }
            throw new UndeclaredThrowableException(sqlE);
        }
        int nodeId = -1;
        try {
            PreparedStatement stmt = null;
            try {
                stmt = dbConn.prepareStatement(SQL_GET_NODEID);
                stmt.setString(1, ipAddr.getHostAddress());
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    nodeId = rs.getInt(1);
                    if (rs.wasNull()) {
                        nodeId = -1;
                    }
                }
                rs.close();
            }
            catch (SQLException sqle) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"initialize: SQL exception!!", (Throwable)sqle);
                }
                throw new RuntimeException("SQL exception while attempting to retrieve node id for interface " + ipAddr.getHostAddress());
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
            if (nodeId == -1) {
                throw new RuntimeException("Unable to retrieve node id for interface " + ipAddr.getHostAddress());
            }
        }
        finally {
            block45: {
                try {
                    dbConn.close();
                }
                catch (SQLException sqle) {
                    if (!log.isEnabledFor(Priority.INFO)) break block45;
                    log.info((Object)"initialize: SQLException while closing database connection", (Throwable)sqle);
                }
            }
        }
        iface.setAttribute(NODE_ID_KEY, new Integer(nodeId));
        if (log.isDebugEnabled()) {
            log.debug((Object)("initialize: dumping node thresholds defined for " + ipAddr.getHostAddress() + "/" + groupName + ":"));
            Iterator iter = nodeMap.values().iterator();
            while (iter.hasNext()) {
                log.debug((Object)((ThresholdEntity)iter.next()));
            }
            log.debug((Object)("initialize: dumping interface thresholds defined for " + ipAddr.getHostAddress() + "/" + groupName + ":"));
            iter = baseIfMap.values().iterator();
            while (iter.hasNext()) {
                log.debug((Object)((ThresholdEntity)iter.next()));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("initialize: initialization completed for " + ipAddr.getHostAddress()));
        }
    }

    public void release(NetworkInterface iface) {
    }

    public int check(NetworkInterface iface, EventProxy eproxy, Map parameters) {
        Category log = ThreadCategory.getInstance(this.getClass());
        String dsDir = this.serviceName;
        String port = ParameterMap.getKeyedString(parameters, "port", null);
        String friendlyName = ParameterMap.getKeyedString(parameters, "friendly-name", port);
        int range = ParameterMap.getKeyedInteger(parameters, "range", 0);
        if (this.useFriendlyName) {
            dsDir = friendlyName;
        }
        InetAddress primary = (InetAddress)iface.getAddress();
        String groupName = ParameterMap.getKeyedString(parameters, "thresholding-group", this.serviceName);
        int interval = ParameterMap.getKeyedInteger(parameters, "interval", 300000);
        if (log.isDebugEnabled()) {
            log.debug((Object)("check: service= " + this.serviceName.toUpperCase() + " address= " + primary.getHostAddress() + " thresholding-group=" + groupName + " interval=" + interval + "mS range =  " + range + " mS"));
        }
        String repository = (String)iface.getAttribute(RRD_REPOSITORY_KEY);
        if (log.isDebugEnabled()) {
            log.debug((Object)("check: rrd repository=" + repository));
        }
        Integer nodeId = (Integer)iface.getAttribute(NODE_ID_KEY);
        Map nodeMap = (Map)iface.getAttribute(NODE_THRESHOLD_MAP_KEY);
        Map baseIfMap = (Map)iface.getAttribute(BASE_IF_THRESHOLD_MAP_KEY);
        Map allIfMap = (Map)iface.getAttribute(ALL_IF_THRESHOLD_MAP_KEY);
        File nodeDirectory = new File(repository + File.separator + nodeId.toString() + "/" + dsDir);
        Events events = new Events();
        Date dateStamp = new Date();
        try {
            this.checkNodeDir(nodeDirectory, nodeId, primary, range, interval, dateStamp, nodeMap, events);
        }
        catch (IllegalArgumentException e) {
            log.info((Object)("check: Threshold checking failed for primary " + this.serviceName + " interface " + primary.getHostAddress()), (Throwable)e);
            return 2;
        }
        File[] files = nodeDirectory.listFiles(RrdFileConstants.INTERFACE_DIRECTORY_FILTER);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    this.checkIfDir(files[i], nodeId, primary, interval, range, dateStamp, baseIfMap, allIfMap, events);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    log.info((Object)("check: Threshold checking failed for primary " + this.serviceName + " interface " + primary.getHostAddress()), (Throwable)e);
                    return 2;
                }
            }
        }
        if (events.getEventCount() > 0) {
            try {
                Log eventLog = new Log();
                eventLog.setEvents(events);
                eproxy.send(eventLog);
            }
            catch (EventProxyException e) {
                log.warn((Object)"check: Failed sending threshold events via event proxy...", (Throwable)e);
                return 2;
            }
        }
        return 1;
    }

    private void checkNodeDir(File directory, Integer nodeId, InetAddress primary, int interval, int range, Date date, Map thresholdMap, Events events) throws IllegalArgumentException {
        File[] files;
        Category log = ThreadCategory.getInstance(this.getClass());
        if (directory == null || nodeId == null || primary == null || date == null || thresholdMap == null || events == null) {
            throw new IllegalArgumentException("Null parameters not permitted.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("checkNodeDir: threshold checking node dir: " + directory.getAbsolutePath()));
        }
        if ((files = directory.listFiles(RrdFileConstants.RRD_FILENAME_FILTER)) == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            int result;
            String filename = files[i].getName();
            String datasource = filename.substring(0, filename.indexOf(RrdUtils.getExtension()));
            ThresholdEntity threshold = (ThresholdEntity)thresholdMap.get(datasource);
            if (threshold == null) continue;
            Double dsValue = null;
            try {
                if (range != 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("checking values within " + range + " mS of last possible PDP"));
                    }
                    dsValue = RrdUtils.fetchLastValueInRange((String)files[i].getAbsolutePath(), (int)interval, (int)range);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"checking value of last possible PDP only");
                    }
                    dsValue = RrdUtils.fetchLastValue((String)files[i].getAbsolutePath(), (int)interval);
                }
            }
            catch (NumberFormatException nfe) {
                log.warn((Object)("Unable to convert retrieved value for datasource '" + datasource + "' to a double, skipping evaluation."));
            }
            catch (RrdException e) {
                log.info((Object)("An error occurred retriving the last value for datasource '" + datasource + "'"), (Throwable)e);
            }
            if (dsValue == null || dsValue.isNaN() || (result = threshold.evaluate(dsValue)) == 0) continue;
            if (result == 3 || result == 1) {
                events.addEvent(this.createEvent(nodeId, primary, null, dsValue, threshold.getHighThreshold(), "uei.opennms.org/threshold/highThresholdExceeded", date));
            }
            if (result == 3 || result == 2) {
                events.addEvent(this.createEvent(nodeId, primary, null, dsValue, threshold.getLowThreshold(), "uei.opennms.org/threshold/lowThresholdExceeded", date));
            }
            if (result == 6 || result == 4) {
                events.addEvent(this.createEvent(nodeId, primary, null, dsValue, threshold.getHighThreshold(), "uei.opennms.org/threshold/highThresholdRearmed", date));
            }
            if (result != 6 && result != 5) continue;
            events.addEvent(this.createEvent(nodeId, primary, null, dsValue, threshold.getLowThreshold(), "uei.opennms.org/threshold/lowThresholdRearmed", date));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfDir(File directory, Integer nodeId, InetAddress primary, int interval, int range, Date date, Map baseIfThresholdMap, Map allIfThresholdMap, Events events) throws IllegalArgumentException {
        File[] files;
        HashMap<String, Object> thresholdMap;
        Category log = ThreadCategory.getInstance(this.getClass());
        if (directory == null || nodeId == null || primary == null || date == null || baseIfThresholdMap == null || allIfThresholdMap == null || events == null) {
            throw new IllegalArgumentException("Null parameters not permitted.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("checkIfDir: threshold checking interface dir: " + directory.getAbsolutePath()));
        }
        String ifLabel = directory.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("checkIfDir: ifLabel=" + ifLabel));
        }
        if ((thresholdMap = (HashMap<String, Object>)allIfThresholdMap.get(ifLabel)) == null) {
            thresholdMap = new HashMap<String, Object>();
            for (ThresholdEntity entity : baseIfThresholdMap.values()) {
                thresholdMap.put(entity.getDatasourceName(), entity.clone());
            }
            allIfThresholdMap.put(ifLabel, thresholdMap);
        }
        if ((files = directory.listFiles(RrdFileConstants.RRD_FILENAME_FILTER)) == null || files.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("checkIfDir: no RRD files in dir: " + directory));
            }
            return;
        }
        Map<String, String> ifDataMap = null;
        for (int i = 0; i < files.length; ++i) {
            int result;
            ThresholdEntity threshold;
            String filename = files[i].getName();
            String datasource = filename.substring(0, filename.indexOf(RrdUtils.getExtension()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("checkIfDir: looking up datasource: " + datasource));
            }
            if ((threshold = (ThresholdEntity)thresholdMap.get(datasource)) == null) continue;
            Double dsValue = null;
            try {
                if (range != 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("checking values within " + range + " mS of last possible PDP"));
                    }
                    dsValue = RrdUtils.fetchLastValueInRange((String)files[i].getAbsolutePath(), (int)interval, (int)range);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"checking value of last possible PDP only");
                    }
                    dsValue = RrdUtils.fetchLastValue((String)files[i].getAbsolutePath(), (int)interval);
                }
            }
            catch (NumberFormatException nfe) {
                log.warn((Object)("Unable to convert retrieved value for datasource '" + datasource + "' to a double, skipping evaluation."));
            }
            catch (RrdException e) {
                log.info((Object)("An error occurred retriving the last value for datasource '" + datasource + "'"), (Throwable)e);
            }
            if (dsValue == null || dsValue.isNaN() || (result = threshold.evaluate(dsValue)) == 0) continue;
            if (ifLabel != null && ifDataMap == null) {
                Connection dbConn = null;
                try {
                    dbConn = DataSourceFactory.getInstance().getConnection();
                }
                catch (SQLException sqlE) {
                    if (log.isEnabledFor(Priority.ERROR)) {
                        log.error((Object)"checkIfDir: Failed getting connection to the database.", (Throwable)sqlE);
                    }
                    throw new UndeclaredThrowableException(sqlE);
                }
                try {
                    ifDataMap = IfLabel.getInterfaceInfoFromIfLabel(dbConn, nodeId, ifLabel);
                }
                catch (SQLException e) {
                    log.warn((Object)("Failed to retrieve interface info from database using ifLabel '" + ifLabel));
                    ifDataMap = new HashMap<String, String>();
                }
                finally {
                    block36: {
                        try {
                            if (dbConn != null) {
                                dbConn.close();
                            }
                        }
                        catch (SQLException sqle) {
                            if (!log.isEnabledFor(Priority.INFO)) break block36;
                            log.info((Object)"checkIfDir: SQLException while closing database connection", (Throwable)sqle);
                        }
                    }
                }
                ifDataMap.put("iflabel", ifLabel);
            }
            if (result == 3 || result == 1) {
                events.addEvent(this.createEvent(nodeId, primary, ifDataMap, dsValue, threshold.getHighThreshold(), "uei.opennms.org/threshold/highThresholdExceeded", date));
            }
            if (result == 3 || result == 2) {
                events.addEvent(this.createEvent(nodeId, primary, ifDataMap, dsValue, threshold.getLowThreshold(), "uei.opennms.org/threshold/lowThresholdExceeded", date));
            }
            if (result == 6 || result == 4) {
                events.addEvent(this.createEvent(nodeId, primary, ifDataMap, dsValue, threshold.getHighThreshold(), "uei.opennms.org/threshold/highThresholdRearmed", date));
            }
            if (result != 6 && result != 5) continue;
            events.addEvent(this.createEvent(nodeId, primary, ifDataMap, dsValue, threshold.getLowThreshold(), "uei.opennms.org/threshold/lowThresholdRearmed", date));
        }
    }

    private Event createEvent(Integer nodeId, InetAddress primary, Map ifDataMap, double dsValue, Threshold threshold, String uei, Date date) {
        Category log = ThreadCategory.getInstance(this.getClass());
        if (nodeId == null || primary == null || threshold == null) {
            throw new IllegalArgumentException("nodeid, primary, and threshold cannot be null.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("createEvent: nodeId=" + nodeId + " primaryAddr=" + primary + " ds=" + threshold.getDsName() + " uei=" + uei));
            if (ifDataMap != null) {
                log.debug((Object)("createEvent: specific interface data: ifAddr=" + (String)ifDataMap.get("ipaddr") + " macAddr=" + (String)ifDataMap.get("snmpphysaddr") + " ifName=" + (String)ifDataMap.get("snmpifname") + " ifDescr=" + (String)ifDataMap.get("snmpifdescr") + " ifIndex=" + (String)ifDataMap.get("snmpifindex") + " ifLabel=" + (String)ifDataMap.get("iflabel")));
            }
        }
        Event newEvent = new Event();
        newEvent.setUei(uei);
        newEvent.setNodeid(nodeId.longValue());
        newEvent.setService(this.serviceName());
        newEvent.setSource("OpenNMS.Threshd." + threshold.getDsName());
        if (ifDataMap == null || ifDataMap.get("ipaddr") == null) {
            if (primary != null) {
                newEvent.setInterface(primary.getHostAddress());
            }
        } else {
            String ifAddr = (String)ifDataMap.get("ipaddr");
            newEvent.setInterface(ifAddr);
        }
        try {
            newEvent.setHost(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException uhE) {
            newEvent.setHost("unresolved.host");
            log.warn((Object)"Failed to resolve local hostname", (Throwable)uhE);
        }
        newEvent.setTime(EventConstants.formatToString(date));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("ds");
        parmValue = new Value();
        parmValue.setContent(threshold.getDsName());
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("value");
        parmValue = new Value();
        parmValue.setContent(Double.toString(dsValue));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("threshold");
        parmValue = new Value();
        parmValue.setContent(Double.toString(threshold.getValue()));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("trigger");
        parmValue = new Value();
        parmValue.setContent(Integer.toString(threshold.getTrigger()));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("rearm");
        parmValue = new Value();
        parmValue.setContent(Double.toString(threshold.getRearm()));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        if (ifDataMap != null && ifDataMap.get("iflabel") != null) {
            eventParm = new Parm();
            eventParm.setParmName("ifLabel");
            parmValue = new Value();
            parmValue.setContent((String)ifDataMap.get("iflabel"));
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public void setUseFriendlyName(boolean useFriendlyName) {
        this.useFriendlyName = useFriendlyName;
    }
}

