/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdGroup;
import org.opennms.netmgt.threshd.ThresholdResourceType;
import org.opennms.netmgt.threshd.ThresholdsDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultThresholdsDao
implements ThresholdsDao {
    @Override
    public ThresholdGroup get(String name) {
        File rrdRepository = new File(ThresholdingConfigFactory.getInstance().getRrdRepository(name));
        ThresholdGroup group = new ThresholdGroup(name);
        group.setRrdRepository(rrdRepository);
        ThresholdResourceType nodeType = this.createType(name, "node");
        group.setNodeResourceType(nodeType);
        ThresholdResourceType ifType = this.createType(name, "if");
        group.setIfResourceType(ifType);
        return group;
    }

    private ThresholdResourceType createType(String groupName, String type) {
        ThresholdResourceType resourceType = new ThresholdResourceType(type);
        resourceType.setThresholdMap(this.createThresholdStateMap(type, groupName));
        return resourceType;
    }

    public Map<String, ThresholdEntity> createThresholdStateMap(String type, String groupName) {
        HashMap<String, ThresholdEntity> thresholdMap = new HashMap<String, ThresholdEntity>();
        for (Threshold thresh : ThresholdingConfigFactory.getInstance().getThresholds(groupName)) {
            if (!thresh.getDsType().equals(type)) continue;
            ThresholdEntity thresholdEntity = (ThresholdEntity)thresholdMap.get(thresh.getDsName());
            if (thresholdEntity == null) {
                thresholdEntity = new ThresholdEntity();
                thresholdMap.put(thresh.getDsName(), thresholdEntity);
            }
            try {
                thresholdEntity.setThreshold(thresh);
            }
            catch (IllegalStateException e) {
                this.log().warn((Object)("Encountered duplicate " + thresh.getType() + " for datasource " + thresh.getDsName()), (Throwable)e);
            }
        }
        return thresholdMap;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

