/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.syslogd.SyslogDefs;
import org.opennms.netmgt.syslogd.SyslogTimeStamp;
import org.opennms.netmgt.syslogd.SyslogdIPMgr;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.event.Logmsg;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

final class ConvertToEvent {
    static final String LOG4J_CATEGORY = "OpenNMS.Syslogd";
    private static String m_localAddr;
    private static String m_logPrefix;
    private String m_eventXML;
    private static Event e;
    private Log m_log;
    private InetAddress m_sender;
    private int m_port;
    private List m_ackEvents;
    private Event m_event;

    private ConvertToEvent() {
    }

    static ConvertToEvent make(DatagramPacket packet) throws UnsupportedEncodingException {
        return ConvertToEvent.make(packet.getAddress(), packet.getPort(), packet.getData(), packet.getLength());
    }

    static ConvertToEvent make(InetAddress addr, int port, byte[] data, int len) throws UnsupportedEncodingException {
        String timestamp;
        ConvertToEvent e = new ConvertToEvent();
        e.m_sender = addr;
        e.m_port = port;
        e.m_eventXML = new String(data, 0, len, "US-ASCII");
        e.m_ackEvents = new ArrayList(16);
        e.m_log = null;
        m_logPrefix = LOG4J_CATEGORY;
        ThreadCategory.setPrefix((String)m_logPrefix);
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        Category log = ThreadCategory.getInstance();
        log.debug((Object)("In the make part of UdpReceivedSyslog " + e.toString()));
        Event event = new Event();
        event.setSource("syslogd");
        long nodeId = SyslogdIPMgr.getNodeId(addr.toString().replaceAll("/", ""));
        if (nodeId != -1L) {
            event.setNodeid(nodeId);
        }
        try {
            event.setHost(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException uhE) {
            event.setHost("unresolved.host");
            log.warn((Object)"Failed to resolve local hostname", (Throwable)uhE);
        }
        event.setInterface(addr.toString().replaceAll("/", ""));
        event.setTime(EventConstants.formatToString(new Date()));
        Logmsg logmsg = new Logmsg();
        logmsg.setDest("logndisplay");
        String message = new String(data, 0, len, "US-ASCII");
        int lbIdx = message.indexOf(60);
        int rbIdx = message.indexOf(62);
        if (lbIdx < 0 || rbIdx < 0 || lbIdx >= rbIdx - 1) {
            log.warn((Object)"Syslogd received an unparsable message!");
        }
        int priCode = 0;
        String priStr = message.substring(lbIdx + 1, rbIdx);
        try {
            priCode = Integer.parseInt(priStr);
        }
        catch (NumberFormatException ex) {
            log.debug((Object)("ERROR Bad priority code '" + priStr + "'"));
        }
        int facility = SyslogDefs.extractFacility(priCode);
        int priority = SyslogDefs.extractPriority(priCode);
        String priorityTxt = SyslogDefs.getPriorityName(priority);
        String facilityTxt = SyslogDefs.getFacilityName(facility);
        event.setUei("uei.opennms.org/syslogd/" + facilityTxt + "/" + priorityTxt);
        message = message.substring(rbIdx + 1, message.length());
        boolean stdMsg = true;
        if (message.length() < 16) {
            stdMsg = false;
        } else if (message.charAt(3) != ' ' || message.charAt(6) != ' ' || message.charAt(9) != ':' || message.charAt(12) != ':' || message.charAt(15) != ' ') {
            stdMsg = false;
        }
        if (!stdMsg) {
            try {
                timestamp = SyslogTimeStamp.getInstance().format(new Date());
            }
            catch (IllegalArgumentException ex) {
                log.debug((Object)"ERROR INTERNAL DATE ERROR!");
                timestamp = "";
            }
        } else {
            timestamp = message.substring(0, 15);
            message = message.substring(16);
        }
        Pattern bsdForward = Pattern.compile("^Forwarded from (\\d+\\.\\d+\\.\\d+\\.\\d+): (.*)");
        Matcher m = bsdForward.matcher(message);
        m = bsdForward.matcher(message);
        if (m.matches()) {
            nodeId = SyslogdIPMgr.getNodeId(m.group(1).toString().replaceAll("/", ""));
            if (nodeId != -1L) {
                event.setNodeid(nodeId);
            }
            event.setInterface(m.group(1));
            message = m.group(2);
            log.debug((Object)("Forwarded message: " + message));
        }
        lbIdx = message.indexOf(91);
        rbIdx = message.indexOf(93);
        int colonIdx = message.indexOf(58);
        int spaceIdx = message.indexOf(32);
        int processId = 0;
        String processName = "";
        String processIdStr = "";
        if (lbIdx < rbIdx - 1 && colonIdx == rbIdx + 1 && spaceIdx == colonIdx + 1) {
            processName = message.substring(0, lbIdx);
            processIdStr = message.substring(lbIdx + 1, rbIdx);
            message = message.substring(colonIdx + 2);
            try {
                processId = Integer.parseInt(processIdStr);
            }
            catch (NumberFormatException ex) {
                log.debug((Object)("ERROR Bad process id '" + processIdStr + "'"));
                processId = 0;
            }
        } else if (lbIdx < 0 && rbIdx < 0 && colonIdx > 0 && spaceIdx == colonIdx + 1) {
            processName = message.substring(0, colonIdx);
            message = message.substring(colonIdx + 2);
        }
        logmsg.setContent(message);
        event.setLogmsg(logmsg);
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("syslogmessage");
        parmValue = new Value();
        parmValue.setContent(message);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("severity");
        parmValue = new Value();
        parmValue.setContent("" + priorityTxt);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("timestamp");
        parmValue = new Value();
        parmValue.setContent(timestamp);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("process");
        parmValue = new Value();
        parmValue.setContent(processName);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("service");
        parmValue = new Value();
        parmValue.setContent("" + facilityTxt);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("processid");
        parmValue = new Value();
        parmValue.setContent("" + processId);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        event.setParms(eventParms);
        e.m_event = event;
        return e;
    }

    Log unmarshal() throws ValidationException, MarshalException {
        if (this.m_log == null) {
            StringReader rdr = new StringReader(this.m_eventXML);
            this.m_log = (Log)Unmarshaller.unmarshal(Log.class, (Reader)rdr);
        }
        return this.m_log;
    }

    void ackEvent(Event e) {
        if (!this.m_ackEvents.contains(e)) {
            this.m_ackEvents.add(e);
        }
    }

    String getXmlData() {
        return this.m_eventXML;
    }

    InetAddress getSender() {
        return this.m_sender;
    }

    int getPort() {
        return this.m_port;
    }

    public List getAckedEvents() {
        return this.m_ackEvents;
    }

    public Event getEvent() {
        return this.m_event;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof ConvertToEvent) {
            ConvertToEvent e = (ConvertToEvent)o;
            return this == e || this.m_port == e.m_port && this.m_sender.equals(e.m_sender);
        }
        return false;
    }

    public int hashCode() {
        return this.m_port ^ this.m_sender.hashCode();
    }
}

