/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scheduler;

import java.util.Random;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.scheduler.PostponeNecessary;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.ScheduleInterval;
import org.opennms.netmgt.scheduler.ScheduleTimer;

public class Schedule {
    public static final Random random = new Random();
    private ReadyRunnable m_schedulable;
    private ScheduleInterval m_interval;
    private ScheduleTimer m_timer;
    private int m_currentExpirationCode;
    private long m_currentInterval;
    private boolean m_scheduled = false;

    public Schedule(ReadyRunnable schedulable, ScheduleInterval interval, ScheduleTimer timer) {
        this.m_schedulable = schedulable;
        this.m_interval = interval;
        this.m_timer = timer;
        this.m_currentExpirationCode = 0;
    }

    public void schedule() {
        this.m_scheduled = true;
        this.schedule(0L);
    }

    private void schedule(long interval) {
        if (interval >= 0L && this.m_scheduled) {
            this.m_timer.schedule(interval, new ScheduleEntry(++this.m_currentExpirationCode));
        }
    }

    public void run() {
        this.m_schedulable.run();
    }

    public void adjustSchedule() {
        this.schedule(this.m_interval.getInterval());
    }

    public void unschedule() {
        this.m_scheduled = false;
        ++this.m_currentExpirationCode;
    }

    class ScheduleEntry
    implements ReadyRunnable {
        private int m_expirationCode;

        public ScheduleEntry(int expirationCode) {
            this.m_expirationCode = expirationCode;
        }

        private boolean isExpired() {
            return this.m_expirationCode < Schedule.this.m_currentExpirationCode;
        }

        public boolean isReady() {
            return this.isExpired() || Schedule.this.m_schedulable.isReady();
        }

        public void run() {
            if (this.isExpired()) {
                ThreadCategory.getInstance(this.getClass()).debug((Object)("Schedule " + this + " expired.  No need to run."));
                return;
            }
            if (!Schedule.this.m_interval.scheduledSuspension()) {
                try {
                    Schedule.this.run();
                }
                catch (PostponeNecessary e) {
                    Schedule.this.m_timer.schedule(random.nextInt(10) * 1000 + 5000, this);
                    return;
                }
            }
            if (this.isExpired()) {
                ThreadCategory.getInstance(this.getClass()).debug((Object)("Schedule " + this + " expired.  No need to reschedule."));
                return;
            }
            long interval = Schedule.this.m_interval.getInterval();
            if (interval >= 0L && Schedule.this.m_scheduled) {
                Schedule.this.m_timer.schedule(interval, this);
            }
        }

        public String toString() {
            return "ScheduleEntry[expCode=" + this.m_expirationCode + "] for " + Schedule.this.m_schedulable;
        }
    }
}

