/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scheduler;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Category;
import org.opennms.core.concurrent.RunnableConsumerThreadPool;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.queue.FifoQueueImpl;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Scheduler;

public class LegacyScheduler
implements Runnable,
PausableFiber,
Scheduler {
    public Map m_queues;
    public int m_scheduled;
    public RunnableConsumerThreadPool m_runner;
    private String m_name;
    public int m_status;
    private Thread m_worker;

    public LegacyScheduler(String parent, int maxSize) {
        this.m_name = parent + "Scheduler-" + maxSize;
        this.m_status = 0;
        this.m_runner = new RunnableConsumerThreadPool(this.m_name + " Pool", 0.6f, 1.0f, maxSize);
        this.m_queues = Collections.synchronizedMap(new TreeMap());
        this.m_scheduled = 0;
        this.m_worker = null;
    }

    public LegacyScheduler(String parent, int maxSize, float lowMark, float hiMark) {
        this.m_name = parent + "Scheduler-" + maxSize;
        this.m_status = 0;
        this.m_runner = new RunnableConsumerThreadPool(this.m_name + " Pool", lowMark, hiMark, maxSize);
        this.m_queues = Collections.synchronizedMap(new TreeMap());
        this.m_scheduled = 0;
        this.m_worker = null;
    }

    public synchronized void schedule(ReadyRunnable runnable, long interval) {
        Long key;
        Category log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)("schedule: Adding ready runnable " + runnable + " at interval " + interval));
        }
        if (!this.m_queues.containsKey(key = new Long(interval))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"schedule: interval queue did not exist, a new one has been created");
            }
            this.m_queues.put(key, new PeekableFifoQueue());
        }
        try {
            ((FifoQueue)this.m_queues.get(key)).add((Object)runnable);
            if (this.m_scheduled++ == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"schedule: queue element added, calling notify all since none were scheduled");
                }
                this.notifyAll();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"schedule: queue element added, notification not performed");
            }
        }
        catch (InterruptedException ie) {
            if (log.isInfoEnabled()) {
                log.info((Object)("schedule: failed to add new ready runnable instance " + runnable + " to scheduler"), (Throwable)ie);
            }
            Thread.currentThread().interrupt();
        }
        catch (FifoQueueException ex) {
            if (log.isInfoEnabled()) {
                log.info((Object)("schedule: failed to add new ready runnable instance " + runnable + " to scheduler"), (Throwable)ex);
            }
            throw new UndeclaredThrowableException(ex);
        }
    }

    public synchronized void schedule(long interval, final ReadyRunnable runnable) {
        final long timeToRun = this.getCurrentTime() + interval;
        ReadyRunnable timeKeeper = new ReadyRunnable(){

            public boolean isReady() {
                return LegacyScheduler.this.getCurrentTime() >= timeToRun && runnable.isReady();
            }

            public void run() {
                runnable.run();
            }

            public String toString() {
                return runnable.toString() + " (ready in " + Math.max(0L, timeToRun - LegacyScheduler.this.getCurrentTime()) + "ms)";
            }
        };
        this.schedule(timeKeeper, interval);
    }

    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public synchronized void start() {
        if (this.m_worker != null) {
            throw new IllegalStateException("The fiber has already run or is running");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        this.m_runner.start();
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.start();
        this.m_status = 1;
        log.info((Object)"start: scheduler started");
    }

    public synchronized void stop() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        this.m_status = 3;
        this.m_worker.interrupt();
        this.m_runner.stop();
        log.info((Object)"stop: scheduler stopped");
    }

    public synchronized void pause() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        if (this.m_status == 4 || this.m_status == 3) {
            throw new IllegalStateException("The fiber is not running or a stop is pending");
        }
        if (this.m_status == 6) {
            return;
        }
        this.m_status = 5;
        this.notifyAll();
    }

    public synchronized void resume() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        if (this.m_status == 4 || this.m_status == 3) {
            throw new IllegalStateException("The fiber is not running or a stop is pending");
        }
        if (this.m_status == 2) {
            return;
        }
        this.m_status = 7;
        this.notifyAll();
    }

    public synchronized int getStatus() {
        if (this.m_worker != null && !this.m_worker.isAlive()) {
            this.m_status = 4;
        }
        return this.m_status;
    }

    public String getName() {
        return this.m_runner.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Category log = ThreadCategory.getInstance(this.getClass());
        LegacyScheduler legacyScheduler = this;
        synchronized (legacyScheduler) {
            this.m_status = 2;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"run: scheduler running");
        }
        while (true) {
            legacyScheduler = this;
            synchronized (legacyScheduler) {
                if (this.m_status != 2 && this.m_status != 6 && this.m_status != 5 && this.m_status != 7) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("run: status = " + this.m_status + ", time to exit"));
                    }
                    break;
                }
                while (this.m_status == 5 || this.m_status == 6) {
                    if (this.m_status == 5 && log.isDebugEnabled()) {
                        log.debug((Object)"run: pausing.");
                    }
                    this.m_status = 6;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                        break;
                    }
                }
                if (this.m_status == 7) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"run: resuming.");
                    }
                    this.m_status = 2;
                }
                if (this.m_scheduled == 0) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"run: no ready runnables scheduled, waiting...");
                        }
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
            int runned = 0;
            FifoQueue out = this.m_runner.getRunQueue();
            Object object = this.m_queues;
            synchronized (object) {
                Iterator iter = this.m_queues.entrySet().iterator();
                while (iter.hasNext()) {
                    PeekableFifoQueue in = (PeekableFifoQueue)((Object)iter.next().getValue());
                    ReadyRunnable readyRun = null;
                    int maxLoops = in.size();
                    do {
                        try {
                            readyRun = (ReadyRunnable)in.peek();
                            if (readyRun == null || !readyRun.isReady()) continue;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("run: found ready runnable " + readyRun));
                            }
                            in.remove();
                            out.add((Object)readyRun);
                            ++runned;
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                        catch (FifoQueueException qe) {
                            throw new UndeclaredThrowableException(qe);
                        }
                    } while (readyRun != null && readyRun.isReady() && --maxLoops > 0);
                }
            }
            object = this;
            synchronized (object) {
                this.m_scheduled -= runned;
                if (runned == 0) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"run: scheduler exiting, state = STOPPED");
        }
        LegacyScheduler legacyScheduler2 = this;
        synchronized (legacyScheduler2) {
            this.m_status = 4;
        }
    }

    public static final class PeekableFifoQueue
    extends FifoQueueImpl {
        private Object m_hold = null;

        PeekableFifoQueue() {
        }

        public synchronized Object peek() throws InterruptedException, FifoQueueException {
            if (this.m_hold == null) {
                this.m_hold = super.remove(1L);
            }
            return this.m_hold;
        }

        public synchronized Object remove() throws InterruptedException, FifoQueueException {
            Object rval = null;
            if (this.m_hold != null) {
                rval = this.m_hold;
                this.m_hold = null;
            } else {
                rval = super.remove();
            }
            return rval;
        }

        public synchronized Object remove(long timeout) throws InterruptedException, FifoQueueException {
            Object rval = null;
            if (this.m_hold != null) {
                rval = this.m_hold;
                this.m_hold = null;
            } else {
                rval = super.remove(timeout);
            }
            return rval;
        }
    }
}

