/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.concurrent.RunnableConsumerThreadPool;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.RTCConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.rtc.BroadcastEventProcessor;
import org.opennms.netmgt.rtc.DataManager;
import org.opennms.netmgt.rtc.DataSender;
import org.opennms.netmgt.rtc.datablock.RTCCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RTCManager
extends AbstractServiceDaemon {
    private static final RTCManager m_singleton = new RTCManager();
    private static final String LOWT_TASK = "lowTtask";
    private static final String HIGHT_TASK = "highTtask";
    private static final String USERTIMER = "userTimer";
    private static final int NUM_UPDATERS = 5;
    private static long m_rollingWindow = -1L;
    private Timer m_timer;
    private TimerTask m_lowTtask;
    private long m_lowThresholdInterval = -1L;
    private TimerTask m_highTtask;
    private long m_highThresholdInterval = -1L;
    private TimerTask m_userTask;
    private long m_userRefreshInterval = -1L;
    private int m_counter = -1;
    private int MAX_EVENTS_BEFORE_RESEND = -1;
    private BroadcastEventProcessor m_eventReceiver;
    private RunnableConsumerThreadPool m_updaterPool;
    private DataSender m_dataSender;
    private static DataManager m_dataMgr;

    private synchronized void timerTaskComplete(RTCTimerTask tt) {
        Category log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)("TimerTask '" + tt.getID() + "' complete, status: " + this.getStatus()));
        }
        if (tt.getID().equals(LOWT_TASK)) {
            boolean ret = this.m_userTask.cancel();
            if (log.isDebugEnabled()) {
                log.debug((Object)("timerTaskComplete: userTimer cancelled: " + ret));
            }
            if (this.m_highTtask != null) {
                ret = this.m_highTtask.cancel();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("timerTaskComplete: highTtask cancelled: " + ret));
                }
                this.m_highTtask = null;
            }
            if (this.isRunning()) {
                this.m_dataSender.notifyToSend();
            }
            this.m_lowTtask = null;
            this.m_counter = -1;
            this.m_userTask = new RTCTimerTask(USERTIMER);
            this.m_timer.schedule(this.m_userTask, 0L, this.m_userRefreshInterval);
            if (log.isDebugEnabled()) {
                log.debug((Object)"timerTaskComplete: userTimer scheduled");
            }
        } else if (tt.getID().equals(HIGHT_TASK)) {
            boolean ret = this.m_userTask.cancel();
            if (log.isDebugEnabled()) {
                log.debug((Object)("timerTaskComplete: userTimer cancelled: " + ret));
            }
            if (this.m_lowTtask != null) {
                ret = this.m_lowTtask.cancel();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("timerTaskComplete: lowTtask cancelled: " + ret));
                }
                this.m_lowTtask = null;
            }
            if (this.isRunning()) {
                this.m_dataSender.notifyToSend();
            }
            this.m_highTtask = null;
            this.m_counter = -1;
            this.m_userTask = new RTCTimerTask(USERTIMER);
            this.m_timer.schedule(this.m_userTask, 0L, this.m_userRefreshInterval);
            if (log.isDebugEnabled()) {
                log.debug((Object)"timerTaskComplete: userTimer scheduled");
            }
        } else if (tt.getID().equals(USERTIMER) && this.isRunning()) {
            this.m_dataSender.notifyToSend();
        }
    }

    public RTCManager() {
        super("OpenNMS.RTCManager");
    }

    public synchronized void checkTimerTasksOnEventReceipt() {
        Category log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)"checkTimerTasksOnEventReceipt: Checking if timer tasks need to be reset or data needs to be sent out");
        }
        boolean ret = this.m_userTask.cancel();
        if (log.isDebugEnabled()) {
            log.debug((Object)("checkTimerTasksOnEventReceipt: userTimer cancelled: " + ret));
        }
        if (this.m_counter == -1) {
            this.m_counter = 0;
            if (this.m_lowTtask == null) {
                try {
                    this.m_lowTtask = new RTCTimerTask(LOWT_TASK);
                    this.m_timer.schedule(this.m_lowTtask, this.m_lowThresholdInterval);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"checkTimerTasksOnEventReceipt: lowTtask scheduled");
                    }
                }
                catch (IllegalStateException isE) {
                    log.error((Object)"checkTimerTasksOnEventReceipt: Illegal State adding new RTCTimerTask", (Throwable)isE);
                }
            }
            if (this.m_highTtask == null) {
                try {
                    this.m_highTtask = new RTCTimerTask(HIGHT_TASK);
                    this.m_timer.schedule(this.m_highTtask, this.m_highThresholdInterval);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"checkTimerTasksOnEventReceipt: highTtask scheduled");
                    }
                }
                catch (IllegalStateException isE) {
                    log.error((Object)"checkTimerTasksOnEventReceipt: Illegal State adding new RTCTimerTask", (Throwable)isE);
                }
            }
        }
        if (this.MAX_EVENTS_BEFORE_RESEND > 0 && this.m_counter >= this.MAX_EVENTS_BEFORE_RESEND) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"checkTimerTasksOnEventReceipt: max events before resend limit reached, resetting timers");
            }
            if (this.m_lowTtask != null) {
                ret = this.m_lowTtask.cancel();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("checkTimerTasksOnEventReceipt: lowTtask cancelled: " + ret));
                }
                this.m_lowTtask = null;
            }
            if (this.m_highTtask != null) {
                ret = this.m_highTtask.cancel();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("checkTimerTasksOnEventReceipt: highTtask cancelled: " + ret));
                }
                this.m_highTtask = null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"checkTimerTasksOnEventReceipt: max events before resend limit reached, sending data to listeners");
            }
            this.m_dataSender.notifyToSend();
            if (log.isDebugEnabled()) {
                log.debug((Object)"checkTimerTasksOnEventReceipt: max events before resend limit reached, datasender notified to send data");
            }
            this.m_counter = -1;
        } else if (this.m_counter != 0) {
            if (this.m_lowTtask != null) {
                ret = this.m_lowTtask.cancel();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("checkTimerTasksOnEventReceipt: lowTtask cancelled: " + ret));
                }
                this.m_lowTtask = null;
            }
            try {
                this.m_lowTtask = new RTCTimerTask(LOWT_TASK);
                this.m_timer.schedule(this.m_lowTtask, this.m_lowThresholdInterval);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"checkTimerTasksOnEventReceipt: lowTtask scheduled");
                }
            }
            catch (IllegalStateException isE) {
                log.error((Object)"checkTimerTasksOnEventReceipt: Illegal State adding new RTCTimerTask", (Throwable)isE);
            }
        }
    }

    public synchronized void resetUserTimer() {
        if (this.m_userTask != null) {
            return;
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        try {
            this.m_userTask = new RTCTimerTask(USERTIMER);
            this.m_timer.schedule(this.m_userTask, 0L, this.m_userRefreshInterval);
            if (log.isDebugEnabled()) {
                log.debug((Object)"resetUserTimer: userTimer scheduled");
            }
        }
        catch (IllegalStateException isE) {
            log.error((Object)"dataReceived: Illegal State adding new RTCTimerTask", (Throwable)isE);
        }
    }

    @Override
    protected void onInit() {
        RTCConfigFactory rFactory = null;
        try {
            RTCConfigFactory.reload();
            rFactory = RTCConfigFactory.getInstance();
        }
        catch (IOException ex) {
            this.log().error((Object)"Failed to load rtc configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (MarshalException ex) {
            this.log().error((Object)"Failed to load rtc configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().error((Object)"Failed to load rtc configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        m_rollingWindow = rFactory.getRollingWindow();
        this.MAX_EVENTS_BEFORE_RESEND = rFactory.getMaxEventsBeforeResend();
        this.m_lowThresholdInterval = rFactory.getLowThresholdInterval();
        this.m_highThresholdInterval = rFactory.getHighThresholdInterval();
        String ur = rFactory.getUserRefreshIntervalStr();
        if (ur != null) {
            try {
                this.m_userRefreshInterval = rFactory.getUserRefreshInterval();
            }
            catch (Exception nfE) {
                this.log().warn((Object)"User refresh time has an incorrect format - using 1 minute instead");
                this.m_userRefreshInterval = 60000L;
            }
        } else {
            this.log().warn((Object)"User refresh time not specified - using 1 minute instead");
            this.m_userRefreshInterval = 60000L;
        }
        if (this.m_highThresholdInterval == this.m_lowThresholdInterval) {
            throw new RuntimeException("The values for the high and low threshold intervals CANNOT BE EQUAL");
        }
        if (this.m_highThresholdInterval < this.m_lowThresholdInterval) {
            this.log().warn((Object)"Swapping high and low threshold intervals..");
            long tmp = this.m_highThresholdInterval;
            this.m_highThresholdInterval = this.m_lowThresholdInterval;
            this.m_lowThresholdInterval = tmp;
        }
        this.log().info((Object)("Rolling Window: " + m_rollingWindow + "(milliseconds)"));
        this.log().info((Object)("Low Threshold Refresh Interval: " + this.m_lowThresholdInterval + "(milliseconds)"));
        this.log().info((Object)("High Threshold Refresh Interval: " + this.m_highThresholdInterval + "(milliseconds)"));
        this.log().info((Object)("User Refresh Interval: " + this.m_userRefreshInterval + "(milliseconds)"));
        try {
            m_dataMgr = new DataManager();
        }
        catch (Exception ex) {
            throw new UndeclaredThrowableException(ex);
        }
        this.m_updaterPool = new RunnableConsumerThreadPool("RTC Updater Pool", 0.6f, 1.0f, rFactory.getUpdaters());
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"Created updater pool");
        }
        this.m_eventReceiver = new BroadcastEventProcessor(this.m_updaterPool.getRunQueue());
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"Created event receiver");
        }
        this.m_dataSender = new DataSender(RTCManager.getCategories(), rFactory.getSenders());
        this.log().debug((Object)"Created DataSender");
        this.m_timer = new Timer();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"RTC ready to receive events");
        }
    }

    @Override
    protected void onStart() {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"Starting updater pool");
        }
        this.m_updaterPool.start();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"Starting data sender ");
        }
        this.m_dataSender.start();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"Updater threads and datasender started");
        }
        this.m_userTask = new RTCTimerTask(USERTIMER);
        this.m_timer.schedule(this.m_userTask, 0L, this.m_userRefreshInterval);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"userTimer scheduled");
        }
        try {
            this.m_eventReceiver.start();
        }
        catch (Throwable t) {
            this.m_dataSender.stop();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"DataSender shutdown");
            }
            this.m_updaterPool.stop();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"Updater pool shutdown");
            }
            this.m_timer.cancel();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"Timer cancelled");
            }
            throw new UndeclaredThrowableException(t);
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"RTC ready to receive events");
        }
    }

    @Override
    protected void onStop() {
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"Beginning shutdown process");
            }
            this.m_eventReceiver.close();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"Shutting down the data sender");
            }
            this.m_dataSender.stop();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"DataSender shutdown");
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"sending shutdown to updaters");
            }
            this.m_updaterPool.stop();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"RTC Updaters shutdown");
            }
            if (this.m_lowTtask != null) {
                this.m_lowTtask.cancel();
            }
            if (this.m_highTtask != null) {
                this.m_highTtask.cancel();
            }
            if (this.m_userTask != null) {
                this.m_userTask.cancel();
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"shutdown: Timer tasks Canceled");
            }
            this.m_timer.cancel();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"shutdown: Timer Canceled");
            }
        }
        catch (Exception e) {
            this.log().error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public synchronized void incrementCounter() {
        ++this.m_counter;
    }

    public DataSender getDataSender() {
        return this.m_dataSender;
    }

    public static Map<String, RTCCategory> getCategories() {
        return m_dataMgr.getCategories();
    }

    public static DataManager getDataManager() {
        return m_dataMgr;
    }

    public static void setDataManager(DataManager dataMgr) {
        m_dataMgr = dataMgr;
    }

    public static long getRollingWindow() {
        return m_rollingWindow;
    }

    public static RTCManager getInstance() {
        return m_singleton;
    }

    private class RTCTimerTask
    extends TimerTask {
        private String m_id;

        RTCTimerTask(String id) {
            this.m_id = id;
        }

        public String getID() {
            return this.m_id;
        }

        public void run() {
            RTCManager.this.timerTaskComplete(this);
        }
    }
}

