/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.OnmsMonitoringLocationDefinition;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.remote.ConfigurationChangedListener;
import org.opennms.netmgt.poller.remote.PollService;
import org.opennms.netmgt.poller.remote.PolledService;
import org.opennms.netmgt.poller.remote.Poller;
import org.opennms.netmgt.poller.remote.PollerBackEnd;
import org.opennms.netmgt.poller.remote.PollerConfiguration;
import org.opennms.netmgt.poller.remote.PollerFrontEnd;
import org.opennms.netmgt.poller.remote.PollerSettings;
import org.opennms.netmgt.poller.remote.ServicePollState;
import org.opennms.netmgt.poller.remote.ServicePollStateChangedEvent;
import org.opennms.netmgt.poller.remote.ServicePollStateChangedListener;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPollerFrontEnd
implements PollerFrontEnd,
InitializingBean,
DisposableBean {
    private PollerBackEnd m_backEnd;
    private PollService m_pollService;
    private PollerSettings m_pollerSettings;
    private PollerConfiguration m_pollerConfiguration;
    private Map<Integer, ServicePollState> m_pollState = new LinkedHashMap<Integer, ServicePollState>();
    private LinkedList<PropertyChangeListener> m_propertyChangeListeners = new LinkedList();
    private LinkedList<ServicePollStateChangedListener> m_servicePollStateChangedListeners = new LinkedList();
    private LinkedList<ConfigurationChangedListener> m_configChangeListeners = new LinkedList();
    private boolean m_initialized;
    private boolean m_started;

    public void setPollerBackEnd(PollerBackEnd backEnd) {
        this.m_backEnd = backEnd;
    }

    public void setPollerSettings(PollerSettings settings) {
        this.m_pollerSettings = settings;
    }

    public void setPollService(PollService pollService) {
        this.m_pollService = pollService;
    }

    public void afterPropertiesSet() throws Exception {
        this.assertNotNull(this.m_backEnd, "pollerBackEnd");
        this.assertNotNull(this.m_pollService, "pollService");
        this.assertNotNull(this.m_pollerSettings, "pollerSettings");
        this.m_initialized = true;
        if (this.isRegistered()) {
            this.initializePollState();
        }
    }

    public void destroy() throws Exception {
        if (this.isRegistered()) {
            this.stop();
        }
    }

    private void assertInitialized() {
        Assert.isTrue((boolean)this.m_initialized, (String)"afterProperties set has not been called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePollState() {
        Date oldTime;
        Date date = oldTime = this.m_pollerConfiguration == null ? null : this.m_pollerConfiguration.getConfigurationTimestamp();
        if (!this.isStarted()) {
            this.start();
        }
        this.m_pollService.setServiceMonitorLocators(this.m_backEnd.getServiceMonitorLocators(DistributionContext.REMOTE_MONITOR));
        this.m_pollerConfiguration = this.m_backEnd.getPollerConfiguration(this.getMonitorId());
        Map<Integer, ServicePollState> map = this.m_pollState;
        synchronized (map) {
            int i = 0;
            this.m_pollState.clear();
            for (PolledService service : this.m_pollerConfiguration.getPolledServices()) {
                this.m_pollService.initialize(service);
                this.m_pollState.put(service.getServiceId(), new ServicePollState(service, i++));
            }
        }
        this.fireConfigurationChange(oldTime, this.m_pollerConfiguration.getConfigurationTimestamp());
    }

    private void start() {
        this.assertRegistered();
        if (!this.m_backEnd.pollerStarting(this.getMonitorId(), this.getDetails())) {
            this.m_pollerSettings.setMonitorId(null);
            throw new IllegalStateException("Monitor no longers exists on server.  You need to reregister");
        }
        this.m_started = true;
    }

    public Map<String, String> getDetails() {
        HashMap<String, String> details = new HashMap<String, String>();
        Properties p = System.getProperties();
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            if (!e.getKey().toString().startsWith("os.") || e.getValue() == null) continue;
            details.put(e.getKey().toString(), e.getValue().toString());
        }
        try {
            InetAddress us = InetAddress.getLocalHost();
            details.put("org.opennms.netmgt.poller.remote.hostAddress", us.getHostAddress());
            details.put("org.opennms.netmgt.poller.remote.hostName", us.getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return details;
    }

    @Override
    public Collection<OnmsMonitoringLocationDefinition> getMonitoringLocations() {
        return this.m_backEnd.getMonitoringLocations();
    }

    @Override
    public Collection<PolledService> getPolledServices() {
        this.assertRegistered();
        return Arrays.asList(this.m_pollerConfiguration.getPolledServices());
    }

    private void assertRegistered() {
        this.assertInitialized();
        Assert.state((boolean)this.isRegistered(), (String)"The poller must be registered before we can poll or get its configuration");
    }

    @Override
    public boolean isRegistered() {
        return this.m_pollerSettings.getMonitorId() != null;
    }

    @Override
    public void register(String monitoringLocation) {
        this.assertInitialized();
        int monitorId = this.m_backEnd.registerLocationMonitor(monitoringLocation);
        this.m_pollerSettings.setMonitorId(monitorId);
        this.initializePollState();
        this.firePropertyChange("registered", false, true);
    }

    @Override
    public void setInitialPollTime(Integer polledServiceId, Date initialPollTime) {
        this.assertRegistered();
        ServicePollState pollState = this.getServicePollState(polledServiceId);
        pollState.setInitialPollTime(initialPollTime);
        this.fireServicePollStateChanged(pollState.getPolledService(), pollState.getIndex());
    }

    private void assertNotNull(Object propertyValue, String propertyName) {
        Assert.state((propertyValue != null ? 1 : 0) != 0, (String)(propertyName + " must be set for instances of " + Poller.class));
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public void pollService(Integer polledServiceId) {
        this.assertRegistered();
        PollStatus result = this.doPoll(polledServiceId);
        if (result == null) {
            return;
        }
        this.updateServicePollState(polledServiceId, result);
        this.m_backEnd.reportResult(this.getMonitorId(), polledServiceId, result);
    }

    private void updateServicePollState(Integer polledServiceId, PollStatus result) {
        this.assertRegistered();
        ServicePollState pollState = this.getServicePollState(polledServiceId);
        pollState.setLastPoll(result);
        this.fireServicePollStateChanged(pollState.getPolledService(), pollState.getIndex());
    }

    private PollStatus doPoll(Integer polledServiceId) {
        this.assertRegistered();
        PolledService polledService = this.getPolledService(polledServiceId);
        if (polledService == null) {
            return null;
        }
        PollStatus result = this.m_pollService.poll(polledService);
        return result;
    }

    private PolledService getPolledService(Integer polledServiceId) {
        this.assertRegistered();
        ServicePollState servicePollState = this.getServicePollState(polledServiceId);
        return servicePollState == null ? null : servicePollState.getPolledService();
    }

    public int getMonitorId() {
        return this.m_pollerSettings.getMonitorId();
    }

    private void fireServicePollStateChanged(PolledService polledService, int index) {
        ServicePollStateChangedEvent e = new ServicePollStateChangedEvent(polledService, index);
        for (ServicePollStateChangedListener l : this.m_servicePollStateChangedListeners) {
            l.pollStateChange(e);
        }
    }

    @Override
    public void addServicePollStateChangedListener(ServicePollStateChangedListener l) {
        this.m_servicePollStateChangedListeners.addFirst(l);
    }

    @Override
    public void removeServicePollStateChangedListener(ServicePollStateChangedListener l) {
        this.m_servicePollStateChangedListeners.remove(l);
    }

    public void checkConfig() {
        if (!this.isRegistered()) {
            return;
        }
        this.assertConfigured();
        if (this.m_backEnd.pollerCheckingIn(this.getMonitorId(), this.m_pollerConfiguration.getConfigurationTimestamp())) {
            this.initializePollState();
        }
    }

    private void assertConfigured() {
        this.assertRegistered();
        Assert.notNull((Object)this.m_pollerConfiguration, (String)"The poller has not been configured");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServicePollState getServicePollState(int polledServiceId) {
        this.assertRegistered();
        Map<Integer, ServicePollState> map = this.m_pollState;
        synchronized (map) {
            return this.m_pollState.get(polledServiceId);
        }
    }

    private void fireConfigurationChange(Date oldTime, Date newTime) {
        PropertyChangeEvent e = new PropertyChangeEvent(this, "configuration", oldTime, newTime);
        for (ConfigurationChangedListener l : this.m_configChangeListeners) {
            l.configurationChanged(e);
        }
    }

    @Override
    public void addConfigurationChangedListener(ConfigurationChangedListener l) {
        this.m_configChangeListeners.addFirst(l);
    }

    @Override
    public void removeConfigurationChangedListener(ConfigurationChangedListener l) {
        this.m_configChangeListeners.remove(l);
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent e = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (PropertyChangeListener l : this.m_propertyChangeListeners) {
            l.propertyChange(e);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_propertyChangeListeners.addFirst(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_propertyChangeListeners.remove(l);
    }

    @Override
    public boolean isStarted() {
        return this.m_started;
    }

    @Override
    public void stop() {
        this.m_backEnd.pollerStopping(this.getMonitorId());
        this.m_started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServicePollState> getPollerPollState() {
        Map<Integer, ServicePollState> map = this.m_pollState;
        synchronized (map) {
            return new LinkedList<ServicePollState>(this.m_pollState.values());
        }
    }

    @Override
    public String getMonitorName() {
        return this.isRegistered() ? this.m_backEnd.getMonitorName(this.getMonitorId()) : "";
    }
}

