/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.TimeKeeper;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.dao.LocationMonitorDao;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsMonitoringLocationDefinition;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.model.ServiceSelector;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.poller.remote.OnmsPollModel;
import org.opennms.netmgt.poller.remote.PolledService;
import org.opennms.netmgt.poller.remote.PollerBackEnd;
import org.opennms.netmgt.poller.remote.PollerConfiguration;
import org.opennms.netmgt.utils.EventBuilder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPollerBackEnd
implements PollerBackEnd,
InitializingBean {
    private LocationMonitorDao m_locMonDao;
    private MonitoredServiceDao m_monSvcDao;
    private EventIpcManager m_eventIpcManager;
    private PollerConfig m_pollerConfig;
    private TimeKeeper m_timeKeeper;
    private int m_unresponsiveTimeout;
    private Date m_configurationTimestamp = null;

    @Override
    public Collection<OnmsMonitoringLocationDefinition> getMonitoringLocations() {
        return this.m_locMonDao.findAllMonitoringLocationDefinitions();
    }

    @Override
    public PollerConfiguration getPollerConfiguration(int locationMonitorId) {
        OnmsLocationMonitor mon = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)Integer.valueOf(locationMonitorId));
        Package pkg = this.getPollingPackageForMonitor(mon);
        ServiceSelector selector = this.m_pollerConfig.getServiceSelectorForPackage(pkg);
        Collection services = this.m_monSvcDao.findMatchingServices(selector);
        ArrayList<PolledService> configs = new ArrayList<PolledService>(services.size());
        for (OnmsMonitoredService monSvc : services) {
            Service serviceConfig = this.m_pollerConfig.getServiceInPackage(monSvc.getServiceName(), pkg);
            long interval = serviceConfig.getInterval();
            Map parameters = this.getParameterMap(serviceConfig);
            configs.add(new PolledService(monSvc, parameters, new OnmsPollModel(interval)));
        }
        PolledService[] polledSvcs = configs.toArray(new PolledService[configs.size()]);
        return new SimplePollerConfiguration(this.getConfigurationTimestamp(), polledSvcs);
    }

    private Package getPollingPackageForMonitor(OnmsLocationMonitor mon) {
        OnmsMonitoringLocationDefinition def = this.m_locMonDao.findMonitoringLocationDefinition(mon.getDefinitionName());
        if (def == null) {
            throw new IllegalStateException("Location definition '" + mon.getDefinitionName() + "' could not be found for location monitor ID " + mon.getId());
        }
        String pollingPackageName = def.getPollingPackageName();
        Package pkg = this.m_pollerConfig.getPackage(pollingPackageName);
        if (pkg == null) {
            throw new IllegalStateException("Package " + pollingPackageName + " does not exist as defined for monitoring location " + mon.getDefinitionName());
        }
        return pkg;
    }

    private Map getParameterMap(Service serviceConfig) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Enumeration serviceParms = serviceConfig.enumerateParameter();
        while (serviceParms.hasMoreElements()) {
            Parameter serviceParm = (Parameter)serviceParms.nextElement();
            String value = serviceParm.getValue();
            if (value == null) {
                value = serviceParm.getAnyObject() == null ? "" : serviceParm.getAnyObject().toString();
            }
            paramMap.put(serviceParm.getKey(), value);
        }
        return paramMap;
    }

    @Override
    public boolean pollerCheckingIn(int locationMonitorId, Date currentConfigurationVersion) {
        OnmsLocationMonitor mon = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)Integer.valueOf(locationMonitorId));
        if (mon == null) {
            return false;
        }
        OnmsLocationMonitor.MonitorStatus oldStatus = mon.getStatus();
        mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        mon.setLastCheckInTime(this.m_timeKeeper.getCurrentDate());
        this.m_locMonDao.update((Object)mon);
        if (OnmsLocationMonitor.MonitorStatus.UNRESPONSIVE.equals((Object)oldStatus)) {
            EventBuilder eventBuilder = this.createEventBuilder(locationMonitorId, "uei.opennms.org/remote/locationMonitorReconnected");
            this.m_eventIpcManager.sendNow(eventBuilder.getEvent());
        }
        return this.m_configurationTimestamp.after(currentConfigurationVersion);
    }

    @Override
    public boolean pollerStarting(int locationMonitorId, Map<String, String> pollerDetails) {
        OnmsLocationMonitor mon = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)Integer.valueOf(locationMonitorId));
        if (mon == null) {
            return false;
        }
        mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        mon.setLastCheckInTime(this.m_timeKeeper.getCurrentDate());
        mon.setDetails(pollerDetails);
        this.m_locMonDao.update((Object)mon);
        EventBuilder eventBuilder = this.createEventBuilder(locationMonitorId, "uei.opennms.org/remote/locationMonitorStarted");
        this.m_eventIpcManager.sendNow(eventBuilder.getEvent());
        return true;
    }

    private EventBuilder createEventBuilder(int locationMonitorId, String uei) {
        EventBuilder eventBuilder = new EventBuilder(uei, "PollerBackEnd").addParam("locationMonitorId", locationMonitorId);
        return eventBuilder;
    }

    @Override
    public void pollerStopping(int locationMonitorId) {
        System.err.println("Looking up monitor " + locationMonitorId);
        OnmsLocationMonitor mon = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)Integer.valueOf(locationMonitorId));
        System.err.println("Found monitor " + mon);
        mon.setStatus(OnmsLocationMonitor.MonitorStatus.STOPPED);
        mon.setLastCheckInTime(this.m_timeKeeper.getCurrentDate());
        this.m_locMonDao.update((Object)mon);
        EventBuilder eventBuilder = this.createEventBuilder(locationMonitorId, "uei.opennms.org/remote/locationMonitorStopped");
        this.m_eventIpcManager.sendNow(eventBuilder.getEvent());
    }

    @Override
    public int registerLocationMonitor(String monitoringLocationId) {
        OnmsMonitoringLocationDefinition def = this.m_locMonDao.findMonitoringLocationDefinition(monitoringLocationId);
        if (def == null) {
            throw new ObjectRetrievalFailureException(OnmsMonitoringLocationDefinition.class, (Object)monitoringLocationId, "Location monitor definition with the id '" + monitoringLocationId + "' not found", null);
        }
        OnmsLocationMonitor mon = new OnmsLocationMonitor();
        mon.setDefinitionName(def.getName());
        mon.setStatus(OnmsLocationMonitor.MonitorStatus.REGISTERED);
        this.m_locMonDao.save((Object)mon);
        return mon.getId();
    }

    @Override
    public String getMonitorName(int locationMonitorId) {
        OnmsLocationMonitor locationMonitor = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)Integer.valueOf(locationMonitorId));
        return locationMonitor.getName();
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_locMonDao, (String)"The LocationMonitorDao must be set");
        Assert.notNull((Object)this.m_monSvcDao, (String)"The MonitoredServiceDao must be set");
        Assert.notNull((Object)this.m_pollerConfig, (String)"The PollerConfig must be set");
        Assert.notNull((Object)this.m_timeKeeper, (String)"The timeKeeper must be set");
        Assert.notNull((Object)this.m_eventIpcManager, (String)"The eventIpcManager must be set");
        Assert.state((this.m_unresponsiveTimeout > 0 ? 1 : 0) != 0, (String)"the unresponsiveTimeout property must be set");
        this.m_configurationTimestamp = this.m_timeKeeper.getCurrentDate();
    }

    public void setLocationMonitorDao(LocationMonitorDao locMonDao) {
        this.m_locMonDao = locMonDao;
    }

    public void setMonitoredServiceDao(MonitoredServiceDao monSvcDao) {
        this.m_monSvcDao = monSvcDao;
    }

    public void setPollerConfig(PollerConfig pollerConfig) {
        this.m_pollerConfig = pollerConfig;
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    @Override
    public void reportResult(int locationMonitorID, int serviceId, PollStatus pollResult) {
        OnmsMonitoredService monSvc;
        OnmsLocationMonitor locationMonitor = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)Integer.valueOf(locationMonitorID));
        OnmsLocationSpecificStatus newStatus = new OnmsLocationSpecificStatus(locationMonitor, monSvc = (OnmsMonitoredService)this.m_monSvcDao.get((Serializable)Integer.valueOf(serviceId)), pollResult);
        if (newStatus.getPollResult().getResponseTime() >= 0L) {
            Package pkg = this.getPollingPackageForMonitor(locationMonitor);
            this.m_pollerConfig.saveResponseTimeData(Integer.toString(locationMonitorID), monSvc, newStatus.getPollResult().getResponseTime(), pkg);
        }
        OnmsLocationSpecificStatus currentStatus = this.m_locMonDao.getMostRecentStatusChange(locationMonitor, monSvc);
        this.processStatusChange(currentStatus, newStatus);
    }

    private void processStatusChange(OnmsLocationSpecificStatus currentStatus, OnmsLocationSpecificStatus newStatus) {
        if (this.databaseStatusChanged(currentStatus, newStatus)) {
            this.m_locMonDao.saveStatusChange(newStatus);
            PollStatus pollResult = newStatus.getPollResult();
            if (this.logicalStatusChanged(currentStatus, newStatus)) {
                String uei = pollResult.isAvailable() ? "uei.opennms.org/remote/nodes/nodeRegainedService" : "uei.opennms.org/remote/nodes/nodeLostService";
                EventBuilder builder = this.createEventBuilder(newStatus.getLocationMonitor().getId(), uei).setMonitoredService(newStatus.getMonitoredService());
                if (!pollResult.isAvailable() && pollResult.getReason() != null) {
                    builder.addParam("eventReason", pollResult.getReason());
                }
                this.m_eventIpcManager.sendNow(builder.getEvent());
            }
        }
    }

    private boolean logicalStatusChanged(OnmsLocationSpecificStatus currentStatus, OnmsLocationSpecificStatus newStatus) {
        return currentStatus != null || currentStatus == null && !newStatus.getPollResult().isAvailable();
    }

    private boolean databaseStatusChanged(OnmsLocationSpecificStatus currentStatus, OnmsLocationSpecificStatus newStatus) {
        return currentStatus == null || !currentStatus.getPollResult().equals((Object)newStatus.getPollResult());
    }

    public void setTimeKeeper(TimeKeeper timeKeeper) {
        this.m_timeKeeper = timeKeeper;
    }

    @Override
    public void checkforUnresponsiveMonitors() {
        this.log().debug((Object)("Checking for Unresponsive monitors: UnresponsiveTimeout = " + this.m_unresponsiveTimeout));
        Date now = this.m_timeKeeper.getCurrentDate();
        Date earliestAcceptable = new Date(now.getTime() - (long)this.m_unresponsiveTimeout);
        List monitors = this.m_locMonDao.findAll();
        this.log().debug((Object)("Found " + monitors.size() + " monitors"));
        for (OnmsLocationMonitor monitor : monitors) {
            if (monitor.getStatus() == OnmsLocationMonitor.MonitorStatus.STARTED && monitor.getLastCheckInTime().before(earliestAcceptable)) {
                this.log().debug((Object)("Monitor " + monitor.getName() + " has stopped responding"));
                monitor.setStatus(OnmsLocationMonitor.MonitorStatus.UNRESPONSIVE);
                this.m_locMonDao.update((Object)monitor);
                EventBuilder eventBuilder = this.createEventBuilder(monitor.getId(), "uei.opennms.org/remote/locationMonitorDisconnected");
                this.m_eventIpcManager.sendNow(eventBuilder.getEvent());
                continue;
            }
            this.log().debug((Object)("Monitor " + monitor.getName() + "(" + monitor.getStatus() + ") last responded at " + monitor.getLastCheckInTime()));
        }
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void setUnresponsiveTimeout(int unresponsiveTimeout) {
        this.m_unresponsiveTimeout = unresponsiveTimeout;
    }

    private Date getConfigurationTimestamp() {
        return this.m_configurationTimestamp;
    }

    @Override
    public void configurationUpdated() {
        this.m_configurationTimestamp = this.m_timeKeeper.getCurrentDate();
    }

    @Override
    public Collection<ServiceMonitorLocator> getServiceMonitorLocators(DistributionContext context) {
        return this.m_pollerConfig.getServiceMonitorLocators(context);
    }

    private static class SimplePollerConfiguration
    implements PollerConfiguration,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Date m_timestamp;
        private PolledService[] m_polledServices;

        SimplePollerConfiguration(Date timestamp, PolledService[] polledSvcs) {
            this.m_timestamp = timestamp;
            this.m_polledServices = polledSvcs;
        }

        public Date getConfigurationTimestamp() {
            return this.m_timestamp;
        }

        public PolledService[] getPolledServices() {
            return this.m_polledServices;
        }
    }
}

