/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.Date;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.remote.ConfigurationChangedListener;
import org.opennms.netmgt.poller.remote.PollJob;
import org.opennms.netmgt.poller.remote.PollJobDetail;
import org.opennms.netmgt.poller.remote.PollObserver;
import org.opennms.netmgt.poller.remote.PolledService;
import org.opennms.netmgt.poller.remote.PolledServiceTrigger;
import org.opennms.netmgt.poller.remote.PollerFrontEnd;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class Poller
implements InitializingBean,
PollObserver,
ConfigurationChangedListener {
    private PollerFrontEnd m_pollerFrontEnd;
    private Scheduler m_scheduler;
    private long m_initialSpreadTime = 300000L;

    public void setPollerFrontEnd(PollerFrontEnd pollerFrontEnd) {
        this.m_pollerFrontEnd = pollerFrontEnd;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public void setInitialSpreadTime(long initialSpreadTime) {
        this.m_initialSpreadTime = initialSpreadTime;
    }

    public void afterPropertiesSet() throws Exception {
        this.assertNotNull(this.m_scheduler, "scheduler");
        this.assertNotNull(this.m_pollerFrontEnd, "pollerFrontEnd");
        this.m_pollerFrontEnd.addConfigurationChangedListener(this);
        if (this.m_pollerFrontEnd.isRegistered()) {
            this.schedulePolls();
        } else {
            this.log().debug((Object)"Poller not yet registered");
        }
    }

    private void unschedulePolls() throws Exception {
        for (String jobName : this.m_scheduler.getJobNames("pollJobGroup")) {
            this.m_scheduler.deleteJob(jobName, "pollJobGroup");
        }
    }

    private void schedulePolls() throws Exception {
        this.log().debug((Object)"Enter schedulePolls");
        Collection<PolledService> polledServices = this.m_pollerFrontEnd.getPolledServices();
        if (polledServices == null || polledServices.size() == 0) {
            this.log().warn((Object)"No polling scheduled.");
            this.log().debug((Object)"Exit schedulePolls");
            return;
        }
        long startTime = System.currentTimeMillis();
        long scheduleSpacing = this.m_initialSpreadTime / (long)polledServices.size();
        for (PolledService polledService : polledServices) {
            Date initialPollTime = new Date(startTime);
            this.m_pollerFrontEnd.setInitialPollTime(polledService.getServiceId(), initialPollTime);
            PolledServiceTrigger pollTrigger = new PolledServiceTrigger(polledService);
            pollTrigger.setStartTime(initialPollTime);
            PollJobDetail jobDetail = new PollJobDetail(polledService.toString(), PollJob.class);
            jobDetail.setPolledService(polledService);
            jobDetail.setPollerFrontEnd(this.m_pollerFrontEnd);
            this.log().debug((Object)("Scheduling job for " + polledService));
            this.m_scheduler.scheduleJob((JobDetail)jobDetail, (Trigger)pollTrigger);
            startTime += scheduleSpacing;
        }
        this.log().debug((Object)"Exit schedulePolls");
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private void assertNotNull(Object propertyValue, String propertyName) {
        Assert.state((propertyValue != null ? 1 : 0) != 0, (String)(propertyName + " must be set for instances of " + Poller.class));
    }

    public void pollCompleted(String pollId, PollStatus pollStatus) {
        System.err.println(new Date() + ": Complete Poll for " + pollId + " status = " + pollStatus);
    }

    public void pollStarted(String pollId) {
        System.err.println(new Date() + ": Begin Poll for " + pollId);
    }

    public void configurationChanged(PropertyChangeEvent e) {
        try {
            this.unschedulePolls();
            this.schedulePolls();
        }
        catch (Exception ex) {
            this.log().fatal((Object)"Unable to schedule polls!", (Throwable)ex);
            throw new RuntimeException("Unable to schedule polls!");
        }
    }
}

