/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.nsclient;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.poller.nsclient.NsclientCheckParams;
import org.opennms.netmgt.poller.nsclient.NsclientException;
import org.opennms.netmgt.poller.nsclient.NsclientPacket;

public class NsclientManager {
    public static int DEFAULT_SOCKET_TIMEOUT = 5000;
    public static int DEFAULT_PORT = 1248;
    private String m_HostName = null;
    private int m_PortNumber = DEFAULT_PORT;
    private String m_Password = "None";
    private Socket m_Socket = null;
    private BufferedInputStream m_BufInStream = null;
    private ByteArrayOutputStream m_ByteArrayOutStream = null;
    private int m_Timeout = DEFAULT_SOCKET_TIMEOUT;
    public static final short CHECK_NONE = 0;
    public static final short CHECK_CLIENTVERSION = 1;
    public static final short CHECK_CPULOAD = 2;
    public static final short CHECK_UPTIME = 3;
    public static final short CHECK_USEDDISKSPACE = 4;
    public static final short CHECK_SERVICESTATE = 5;
    public static final short CHECK_PROCSTATE = 6;
    public static final short CHECK_MEMUSE = 7;
    public static final short CHECK_COUNTER = 8;
    public static final short CHECK_FILEAGE = 9;
    public static final short CHECK_INSTANCES = 10;
    public static HashMap CheckStrings = new HashMap();

    public static String convertTypeToString(short type) {
        for (Map.Entry e : CheckStrings.entrySet()) {
            short val = (Short)e.getValue();
            if (val != type) continue;
            return (String)e.getKey();
        }
        return "NONE";
    }

    public static short convertStringToType(String type) {
        return (Short)CheckStrings.get(type);
    }

    public void setPassword(String pass) {
        this.m_Password = pass;
    }

    public void setPortNumber(int port) {
        this.m_PortNumber = port;
    }

    public int getPortNumber() {
        return this.m_PortNumber;
    }

    public void setHostName(String host) {
        this.m_HostName = host;
    }

    public String getHostName() {
        return this.m_HostName;
    }

    public void setTimeout(int timeout) {
        this.m_Timeout = timeout;
    }

    public int getTimeout() {
        return this.m_Timeout;
    }

    public NsclientManager(String host) {
        this.m_HostName = host;
    }

    public NsclientManager(String host, int port) {
        this.m_HostName = host;
        this.m_PortNumber = port;
    }

    public NsclientManager(String host, int port, String pass) {
        this.m_HostName = host;
        this.m_PortNumber = port;
        this.m_Password = pass;
    }

    public NsclientManager(String host, String pass) {
        this.m_HostName = host;
        this.m_Password = pass;
    }

    private NsclientManager() {
    }

    public void init() throws NsclientException {
        try {
            this.m_Socket = new Socket();
            this.m_Socket.connect(new InetSocketAddress(this.m_HostName, this.m_PortNumber), this.m_Timeout);
            this.m_Socket.setSoTimeout(this.m_Timeout);
            this.m_BufInStream = new BufferedInputStream(this.m_Socket.getInputStream());
            this.m_ByteArrayOutStream = new ByteArrayOutputStream();
        }
        catch (UnknownHostException e) {
            throw new NsclientException("Unknown host: " + this.m_HostName, e);
        }
        catch (ConnectException e) {
            throw new NsclientException("Connection refused to " + this.m_HostName + ":" + this.m_PortNumber, e);
        }
        catch (NoRouteToHostException e) {
            throw new NsclientException("Unable to connect to host: " + this.m_HostName + ", no route to host.", e);
        }
        catch (InterruptedIOException e) {
            throw new NsclientException("Unable to connect to host: " + this.m_HostName + ", exceeded timeout of " + this.m_Timeout);
        }
        catch (IOException e) {
            throw new NsclientException("An unexpected I/O exception occured connecting to host: " + this.m_HostName + ":" + this.m_PortNumber, e);
        }
    }

    public void close() {
        try {
            this.m_Socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private NsclientPacket sendCheckRequest(String request) throws NsclientException {
        byte[] buffer = new byte[1024];
        this.m_ByteArrayOutStream.reset();
        try {
            this.m_Socket.getOutputStream().write(request.getBytes());
            this.m_Socket.getOutputStream().flush();
            int read = this.m_BufInStream.read(buffer);
            if (read > 0) {
                this.m_ByteArrayOutStream.write(buffer, 0, read);
            }
            return new NsclientPacket(this.m_ByteArrayOutStream.toString());
        }
        catch (Exception e) {
            throw new NsclientException("Unknown exception: " + e.getMessage(), e);
        }
    }

    public NsclientPacket processCheckCommand(short type, NsclientCheckParams param) throws NsclientException {
        switch (type) {
            case 1: {
                return this.checkClientVersion(param);
            }
            case 2: {
                return this.checkCpuLoad(param);
            }
            case 3: {
                return this.checkUptime(param);
            }
            case 5: {
                return this.checkServiceState(param);
            }
            case 4: {
                return this.checkUsedDiskSpace(param);
            }
            case 6: {
                return this.checkProcState(param);
            }
            case 7: {
                return this.checkMemoryUsage(param);
            }
            case 8: {
                return this.checkPerfCounter(param);
            }
            case 9: {
                return this.checkFileAge(param);
            }
        }
        return null;
    }

    private NsclientPacket checkClientVersion(NsclientCheckParams param) throws NsclientException {
        Integer[] minVer;
        NsclientPacket pack = null;
        pack = this.sendCheckRequest(this.m_Password + "&" + 1);
        if (pack.getResponse().matches(".*ERROR.*")) {
            pack.setResultCode((short)-1);
            return pack;
        }
        if (param.getParamString() == null || param.getParamString().equals("")) {
            pack.setResultCode((short)0);
            return pack;
        }
        pack.setResultCode((short)2);
        String[] minimum = param.getParamString().split("\\.");
        String[] remote = pack.getResponse().split("\\.");
        if (remote.length != 4 || minimum.length != 4) {
            pack.setResultCode((short)-1);
            return pack;
        }
        Integer[] remVer = new Integer[]{new Integer(Integer.parseInt(remote[0])), new Integer(Integer.parseInt(remote[1])), new Integer(Integer.parseInt(remote[2])), new Integer(Integer.parseInt(remote[3]))};
        if (remVer[0].compareTo((minVer = new Integer[]{new Integer(Integer.parseInt(minimum[0])), new Integer(Integer.parseInt(minimum[1])), new Integer(Integer.parseInt(minimum[2])), new Integer(Integer.parseInt(minimum[3]))})[0]) > 0) {
            pack.setResultCode((short)0);
        } else if (remVer[0].compareTo(minVer[0]) == 0) {
            if (remVer[1].compareTo(minVer[1]) > 0) {
                pack.setResultCode((short)0);
            } else if (remVer[1].compareTo(minVer[1]) == 0) {
                if (remVer[2].compareTo(minVer[2]) > 0) {
                    pack.setResultCode((short)0);
                } else if (remVer[2].compareTo(minVer[2]) == 0) {
                    if (remVer[3].compareTo(minVer[3]) > 0) {
                        pack.setResultCode((short)0);
                    } else if (remVer[3].compareTo(minVer[3]) == 0) {
                        pack.setResultCode((short)0);
                    }
                }
            }
        }
        return pack;
    }

    private NsclientPacket checkCpuLoad(NsclientCheckParams param) throws NsclientException {
        NsclientPacket pack = null;
        pack = this.sendCheckRequest(this.m_Password + "&" + 2 + "&1&1&1");
        pack.setResultCode((short)0);
        if (pack.getResponse().matches(".*ERROR.*")) {
            pack.setResultCode((short)-1);
            return pack;
        }
        if (param.getWarningPercent() != 0 && Integer.parseInt(pack.getResponse()) > param.getWarningPercent()) {
            pack.setResultCode((short)1);
        }
        if (param.getCriticalPercent() != 0 && Integer.parseInt(pack.getResponse()) > param.getCriticalPercent()) {
            pack.setResultCode((short)2);
        }
        return pack;
    }

    private NsclientPacket checkUptime(NsclientCheckParams param) throws NsclientException {
        NsclientPacket pack = null;
        pack = this.sendCheckRequest(this.m_Password + "&" + 3);
        pack.setResultCode((short)0);
        if (pack.getResponse().matches(".*ERROR.*")) {
            pack.setResultCode((short)-1);
            return pack;
        }
        return pack;
    }

    private NsclientPacket checkServiceState(NsclientCheckParams param) throws NsclientException {
        NsclientPacket pack = null;
        pack = this.sendCheckRequest(this.m_Password + "&" + 5 + "&ShowAll&" + this.prepList(param.getParamString()));
        pack.setResultCode((short)0);
        String[] services = pack.getResponse().replaceFirst("^\\d&\\s+", "").split("\\s+-\\s+");
        for (int i = 0; i < services.length; ++i) {
            if (!services[i].split(":\\s+")[1].equals("Stopped")) continue;
            pack.setResultCode((short)2);
        }
        return pack;
    }

    private NsclientPacket checkProcState(NsclientCheckParams param) throws NsclientException {
        NsclientPacket pack = null;
        pack = this.sendCheckRequest(this.m_Password + "&" + 6 + "&ShowAll&" + this.prepList(param.getParamString()));
        pack.setResultCode((short)0);
        if (pack.getResponse().matches(".*ERROR.*")) {
            pack.setResultCode((short)-1);
            return pack;
        }
        String[] services = pack.getResponse().replaceFirst("^\\d&\\s+", "").split("\\s+-\\s+");
        for (int i = 0; i < services.length; ++i) {
            if (!services[i].split(":\\s+")[1].matches("not running\\s*")) continue;
            pack.setResultCode((short)2);
        }
        return pack;
    }

    private NsclientPacket checkUsedDiskSpace(NsclientCheckParams param) throws NsclientException {
        NsclientPacket pack = null;
        pack = this.sendCheckRequest(this.m_Password + "&" + 4 + "&" + param.getParamString());
        pack.setResultCode((short)0);
        if (pack.getResponse().matches(".*ERROR.*")) {
            pack.setResultCode((short)-1);
            return pack;
        }
        String[] results = pack.getResponse().split("&");
        double freeDisk = Double.parseDouble(results[0]);
        double totalDisk = Double.parseDouble(results[1]);
        double usedPerc = (totalDisk - freeDisk) / totalDisk * 100.0;
        if (freeDisk < 0.0 || totalDisk < 0.0) {
            pack.setResultCode((short)-1);
            return pack;
        }
        if (param.getWarningPercent() != 0 && usedPerc > (double)param.getWarningPercent()) {
            pack.setResultCode((short)1);
        }
        if (param.getCriticalPercent() != 0 && usedPerc > (double)param.getCriticalPercent()) {
            pack.setResultCode((short)2);
        }
        return pack;
    }

    private NsclientPacket checkMemoryUsage(NsclientCheckParams param) throws NsclientException {
        NsclientPacket pack = null;
        pack = this.sendCheckRequest(this.m_Password + "&" + 7 + "&7");
        pack.setResultCode((short)0);
        if (pack.getResponse().matches(".*ERROR.*")) {
            pack.setResultCode((short)-1);
            return pack;
        }
        String[] results = pack.getResponse().split("&");
        float memCommitLimit = Float.parseFloat(results[0]);
        float memCommitByte = Float.parseFloat(results[1]);
        float memUsedPerc = memCommitByte / memCommitLimit * 100.0f;
        if (param.getWarningPercent() != 0 && memUsedPerc > (float)param.getWarningPercent()) {
            pack.setResultCode((short)1);
        }
        if (param.getCriticalPercent() != 0 && memUsedPerc > (float)param.getCriticalPercent()) {
            pack.setResultCode((short)2);
        }
        return pack;
    }

    private NsclientPacket checkPerfCounter(NsclientCheckParams param) throws NsclientException {
        NsclientPacket pack = null;
        pack = this.sendCheckRequest(this.m_Password + "&" + 8 + "&" + this.prepList(param.getParamString()));
        pack.setResultCode((short)0);
        if (pack.getResponse().matches(".*ERROR.*")) {
            pack.setResultCode((short)-1);
            return pack;
        }
        float counterValue = Float.parseFloat(pack.getResponse());
        if (param.getWarningPercent() != 0 && counterValue > (float)param.getWarningPercent()) {
            pack.setResultCode((short)1);
        }
        if (param.getCriticalPercent() != 0 && counterValue > (float)param.getCriticalPercent()) {
            pack.setResultCode((short)2);
        }
        return pack;
    }

    private NsclientPacket checkFileAge(NsclientCheckParams param) throws NsclientException {
        NsclientPacket pack = null;
        pack = this.sendCheckRequest(this.m_Password + "&" + 9 + "&" + param.getParamString());
        pack.setResultCode((short)0);
        if (pack.getResponse().matches(".*ERROR.*")) {
            pack.setResultCode((short)-1);
            return pack;
        }
        String[] results = pack.getResponse().split("&");
        double minutes = Double.parseDouble(results[0]);
        if (param.getWarningPercent() != 0 && minutes < (double)param.getWarningPercent()) {
            pack.setResultCode((short)1);
        }
        if (param.getCriticalPercent() != 0 && minutes < (double)param.getCriticalPercent()) {
            pack.setResultCode((short)2);
        }
        return pack;
    }

    private String prepList(String list) {
        return list.replaceAll(",", "&");
    }

    static {
        CheckStrings.put("NONE", new Short(0));
        CheckStrings.put("CLIENTVERSION", new Short(1));
        CheckStrings.put("CPULOAD", new Short(2));
        CheckStrings.put("UPTIME", new Short(3));
        CheckStrings.put("USEDDISKSPACE", new Short(4));
        CheckStrings.put("SERVICESTATE", new Short(5));
        CheckStrings.put("PROCSTATE", new Short(6));
        CheckStrings.put("MEMUSE", new Short(7));
        CheckStrings.put("COUNTER", new Short(8));
        CheckStrings.put("FILEAGE", new Short(9));
        CheckStrings.put("INSTANCES", new Short(10));
    }
}

