/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable
public final class SmtpMonitor
extends IPv4Monitor {
    private static final int DEFAULT_PORT = 25;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static String LOCALHOST_NAME;
    private static RE MULTILINE;
    private RE ENDMULTILINE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        int retry = ParameterMap.getKeyedInteger(parameters, "retry", 0);
        int timeout = ParameterMap.getKeyedInteger(parameters, "timeout", 3000);
        int port = ParameterMap.getKeyedInteger(parameters, "port", 25);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        if (log.isDebugEnabled()) {
            log.debug((Object)("poll: address = " + ipv4Addr.getHostAddress() + ", port = " + port + ", timeout = " + timeout + ", retry = " + retry));
        }
        PollStatus serviceStatus = PollStatus.unavailable();
        long responseTime = -1L;
        for (int attempts = 0; attempts <= retry && !serviceStatus.isAvailable(); ++attempts) {
            Socket socket = null;
            try {
                StringTokenizer t;
                int rc;
                long sentTime = System.currentTimeMillis();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipv4Addr, port), timeout);
                socket.setSoTimeout(timeout);
                log.debug((Object)("SmtpMonitor: connected to host: " + ipv4Addr + " on port: " + port));
                serviceStatus = PollStatus.unresponsive();
                BufferedReader rdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String banner = rdr.readLine();
                if (banner == null) continue;
                if (MULTILINE.match(banner)) {
                    String multiLineRC = new String(banner.getBytes(), 0, 3) + " ";
                    try {
                        this.ENDMULTILINE = new RE(multiLineRC);
                    }
                    catch (RESyntaxException ex) {
                        throw new UndeclaredThrowableException(ex);
                    }
                    while ((banner = rdr.readLine()) != null && !this.ENDMULTILINE.match(banner)) {
                    }
                    if (banner == null) continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("poll: banner = " + banner));
                }
                if ((rc = Integer.parseInt((t = new StringTokenizer(banner)).nextToken())) == 220) {
                    String multiLineRC;
                    String cmd = "HELO " + LOCALHOST_NAME + "\r\n";
                    socket.getOutputStream().write(cmd.getBytes());
                    String response = rdr.readLine();
                    responseTime = System.currentTimeMillis() - sentTime;
                    if (response == null) continue;
                    if (MULTILINE.match(response)) {
                        multiLineRC = new String(response.getBytes(), 0, 3) + " ";
                        try {
                            this.ENDMULTILINE = new RE(multiLineRC);
                        }
                        catch (RESyntaxException ex) {
                            throw new UndeclaredThrowableException(ex);
                        }
                        while ((response = rdr.readLine()) != null && !this.ENDMULTILINE.match(response)) {
                        }
                        if (response == null) continue;
                    }
                    if ((rc = Integer.parseInt((t = new StringTokenizer(response)).nextToken())) == 250) {
                        cmd = "QUIT\r\n";
                        socket.getOutputStream().write(cmd.getBytes());
                        response = rdr.readLine();
                        if (response == null) continue;
                        if (MULTILINE.match(response)) {
                            multiLineRC = new String(response.getBytes(), 0, 3) + " ";
                            try {
                                this.ENDMULTILINE = new RE(multiLineRC);
                            }
                            catch (RESyntaxException ex) {
                                throw new UndeclaredThrowableException(ex);
                            }
                            while ((response = rdr.readLine()) != null && !this.ENDMULTILINE.match(response)) {
                            }
                            if (response == null) continue;
                        }
                        if ((rc = Integer.parseInt((t = new StringTokenizer(response)).nextToken())) == 221) {
                            serviceStatus = PollStatus.available((long)responseTime);
                        }
                    }
                }
                if (serviceStatus.isAvailable()) continue;
                serviceStatus = PollStatus.unavailable();
                continue;
            }
            catch (NumberFormatException e) {
                serviceStatus = this.logDown(Level.DEBUG, "NumberFormatException while polling address " + ipv4Addr.getHostAddress(), e);
                continue;
            }
            catch (NoRouteToHostException e) {
                serviceStatus = this.logDown(Level.DEBUG, "No route to host exception for address " + ipv4Addr.getHostAddress(), e);
                break;
            }
            catch (InterruptedIOException e) {
                serviceStatus = this.logDown(Level.DEBUG, "did not connect to host within timeout: " + timeout + " attempt: " + attempts);
                continue;
            }
            catch (ConnectException e) {
                serviceStatus = this.logDown(Level.DEBUG, "Connection exception for address " + ipv4Addr.getHostAddress(), e);
                continue;
            }
            catch (IOException e) {
                serviceStatus = this.logDown(Level.DEBUG, "IOException while polling address " + ipv4Addr.getHostAddress(), e);
                continue;
            }
            finally {
                block65: {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (!log.isDebugEnabled()) break block65;
                        log.debug((Object)"poll: Error closing socket.", (Throwable)e);
                    }
                }
            }
        }
        return serviceStatus;
    }

    static {
        MULTILINE = null;
        try {
            LOCALHOST_NAME = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhE) {
            ThreadCategory.getInstance(SmtpMonitor.class).error((Object)"Failed to resolve localhost name, using localhost");
            LOCALHOST_NAME = "localhost";
        }
        try {
            MULTILINE = new RE("^[0-9]{3}-");
        }
        catch (RESyntaxException ex) {
            throw new UndeclaredThrowableException(ex);
        }
    }
}

