/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Level;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable(value={DistributionContext.DAEMON})
public final class OmsaStorageMonitor
extends SnmpMonitorStrategy {
    private static final String m_serviceName = "OMSAStorage";
    static final String snmpAgentConfigKey = "org.opennms.netmgt.snmp.SnmpAgentConfig";
    private static final String virtualDiskRollUpStatus = ".1.3.6.1.4.1.674.10893.1.20.140.1.1.19";
    private static final String arrayDiskLogicalConnectionVirtualDiskNumber = ".1.3.6.1.4.1.674.10893.1.20.140.3.1.5";
    private static final String arrayDiskNexusID = ".1.3.6.1.4.1.674.10893.1.20.130.4.1.26";
    private static final String arrayDiskLogicalConnectionArrayDiskNumber = ".1.3.6.1.4.1.674.10893.1.20.140.3.1.3";
    private static final String arrayDiskState = ".1.3.6.1.4.1.674.10893.1.20.130.4.1.4";

    public String serviceName() {
        return m_serviceName;
    }

    public void initialize(Map parameters) {
        try {
            SnmpPeerFactory.init();
        }
        catch (MarshalException ex) {
            this.log().fatal((Object)"initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().fatal((Object)"initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().fatal((Object)"initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    public void initialize(MonitoredService svc) {
        NetworkInterface iface = svc.getNetInterface();
        super.initialize(svc);
        InetAddress ipAddr = (InetAddress)iface.getAddress();
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipAddr);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: SnmpAgentConfig address: " + agentConfig));
            this.log().debug((Object)("initialize: setting SNMP peer attribute for interface " + ipAddr.getHostAddress()));
        }
        iface.setAttribute(snmpAgentConfigKey, agentConfig);
        this.log().debug((Object)("initialize: interface: " + agentConfig.getAddress() + " initialized."));
    }

    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        PollStatus status = PollStatus.available();
        InetAddress ipaddr = (InetAddress)iface.getAddress();
        String returnValue = new String();
        SnmpAgentConfig agentConfig = this.configureAgent(parameters, iface, ipaddr);
        Integer virtualDiskNumber = ParameterMap.getKeyedInteger(parameters, "virtualDiskNumber", 1);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("poll: service= SNMP address= " + agentConfig));
        }
        try {
            SnmpObjId virtualDiskRollUpStatusSnmpObject;
            SnmpValue virtualDiskRollUpStatus;
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("OMSAStorageMonitor.poll: SnmpAgentConfig address: " + agentConfig));
            }
            if ((virtualDiskRollUpStatus = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)(virtualDiskRollUpStatusSnmpObject = new SnmpObjId(".1.3.6.1.4.1.674.10893.1.20.140.1.1.19." + virtualDiskNumber)))).isNull()) {
                this.log().debug((Object)("SNMP poll failed: no results, addr=" + ipaddr.getHostAddress() + " oid=" + virtualDiskRollUpStatusSnmpObject));
                return PollStatus.unavailable();
            }
            if (virtualDiskRollUpStatus.toInt() != 3) {
                returnValue = "log vol(" + virtualDiskNumber + ") degraded";
                SnmpObjId arrayDiskLogicalConnectionVirtualDiskNumberSnmpObject = new SnmpObjId(arrayDiskLogicalConnectionVirtualDiskNumber);
                Map arrayDisks = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"OMSAStorageMonitor", (SnmpObjId)arrayDiskLogicalConnectionVirtualDiskNumberSnmpObject);
                SnmpObjId arrayDiskLogicalConnectionArrayDiskNumberSnmpObject = new SnmpObjId(arrayDiskLogicalConnectionArrayDiskNumber);
                Map arrayDiskConnectionNumber = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"OMSAStorageMonitor", (SnmpObjId)arrayDiskLogicalConnectionArrayDiskNumberSnmpObject);
                for (Map.Entry disk : arrayDisks.entrySet()) {
                    this.log().debug((Object)("OMSAStorageMonitor :: arrayDiskNembers=" + disk.getValue()));
                    if (((SnmpValue)disk.getValue()).toInt() != virtualDiskNumber.intValue()) continue;
                    this.log().debug((Object)"OMSAStorageMonitor :: Disk Found! ");
                    this.log().debug((Object)("OMSAStorageMonitor :: Found This Array Disk Value " + disk.getKey()));
                    SnmpObjId arrayDiskStateSnmpObject = new SnmpObjId(".1.3.6.1.4.1.674.10893.1.20.130.4.1.4." + arrayDiskConnectionNumber.get(disk.getKey()));
                    SnmpValue diskValue = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)arrayDiskStateSnmpObject);
                    this.log().debug((Object)("OmsaStorageMonitor :: Disk State=" + diskValue));
                    if (diskValue.toInt() == 3) continue;
                    String arrayDiskState = this.getArrayDiskStatus(diskValue);
                    SnmpObjId arrayDiskNexusIDSnmpObject = new SnmpObjId(".1.3.6.1.4.1.674.10893.1.20.130.4.1.26." + ((SnmpInstId)disk.getKey()).toString());
                    SnmpValue nexusValue = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)arrayDiskNexusIDSnmpObject);
                    returnValue = returnValue + " phy drv(" + nexusValue + ") " + arrayDiskState;
                }
                return PollStatus.unavailable((String)returnValue);
            }
        }
        catch (NumberFormatException e) {
            status = this.logDown(Level.ERROR, "Number operator used on a non-number " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            status = this.logDown(Level.ERROR, "Invalid Snmp Criteria: " + e.getMessage());
        }
        catch (Throwable t) {
            status = this.logDown(Level.WARN, "Unexpected exception during SNMP poll of interface " + ipaddr.getHostAddress(), t);
        }
        return status;
    }

    private SnmpAgentConfig configureAgent(Map parameters, NetworkInterface iface, InetAddress ipaddr) throws RuntimeException {
        SnmpAgentConfig agentConfig = (SnmpAgentConfig)iface.getAttribute(snmpAgentConfigKey);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, "timeout", agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, "retries", agentConfig.getRetries()));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, "port", agentConfig.getPort()));
        return agentConfig;
    }

    private String getArrayDiskStatus(SnmpValue diskValue) {
        switch (diskValue.toInt()) {
            case 1: {
                return "Ready";
            }
            case 2: {
                return "Failed";
            }
            case 3: {
                return "Online";
            }
            case 4: {
                return "Offline";
            }
            case 6: {
                return "Degraded";
            }
            case 7: {
                return "Recovering";
            }
            case 11: {
                return "Removed";
            }
            case 15: {
                return "Resynching";
            }
            case 24: {
                return "Rebuilding";
            }
            case 25: {
                return "noMedia";
            }
            case 26: {
                return "Formating";
            }
            case 28: {
                return "Running Diagnostics";
            }
            case 35: {
                return "Initializing";
            }
        }
        return null;
    }
}

