/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.utils.ParameterMap;
import org.opennms.protocols.ntp.NtpMessage;

@Distributable
public final class NtpMonitor
extends IPv4Monitor {
    private static final int DEFAULT_PORT = 123;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        int retry = ParameterMap.getKeyedInteger(parameters, "retry", 0);
        int port = ParameterMap.getKeyedInteger(parameters, "port", 123);
        int timeout = ParameterMap.getKeyedInteger(parameters, "timeout", 5000);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        PollStatus serviceStatus = PollStatus.unavailable();
        DatagramSocket socket = null;
        long responseTime = -1L;
        try {
            socket = new DatagramSocket();
            socket.setSoTimeout(timeout);
            for (int attempts = 0; attempts <= retry && !serviceStatus.isAvailable(); ++attempts) {
                try {
                    byte[] data = new NtpMessage().toByteArray();
                    DatagramPacket outgoing = new DatagramPacket(data, data.length, ipv4Addr, port);
                    long sentTime = System.currentTimeMillis();
                    socket.send(outgoing);
                    DatagramPacket incoming = new DatagramPacket(data, data.length);
                    socket.receive(incoming);
                    responseTime = System.currentTimeMillis() - sentTime;
                    double destinationTimestamp = (double)System.currentTimeMillis() / 1000.0 + 2.2089888E9;
                    NtpMessage msg = new NtpMessage(incoming.getData());
                    double localClockOffset = (msg.receiveTimestamp - msg.originateTimestamp + (msg.transmitTimestamp - destinationTimestamp)) / 2.0;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("poll: valid NTP request received the local clock offset is " + localClockOffset + ", responseTime= " + responseTime + "ms"));
                    }
                    log.debug((Object)("poll: NTP message : " + msg.toString()));
                    serviceStatus = PollStatus.available((long)responseTime);
                    continue;
                }
                catch (InterruptedIOException ex) {
                    // empty catch block
                }
            }
        }
        catch (NoRouteToHostException e) {
            serviceStatus = this.logDown(Level.DEBUG, "No route to host exception for address: " + ipv4Addr, e);
        }
        catch (ConnectException e) {
            serviceStatus = this.logDown(Level.DEBUG, "Connection exception for address: " + ipv4Addr, e);
        }
        catch (IOException ex) {
            serviceStatus = this.logDown(Level.INFO, "IOException while polling address: " + ipv4Addr, ex);
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
        return serviceStatus;
    }
}

