/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.monitors.JDBCMonitor;
import org.opennms.netmgt.utils.ParameterMap;

public final class JDBCStoredProcedureMonitor
extends JDBCMonitor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus checkDatabaseStatus(Connection con, Map parameters) {
        CallableStatement cs;
        PollStatus status;
        block6: {
            String storedProcedure;
            boolean bPass;
            block5: {
                status = PollStatus.unavailable();
                cs = null;
                bPass = false;
                storedProcedure = ParameterMap.getKeyedString(parameters, "stored-procedure", null);
                if (storedProcedure != null) break block5;
                PollStatus pollStatus = status;
                this.closeStmt(cs);
                return pollStatus;
            }
            try {
                String procedureCall = "{ ? = call test." + storedProcedure + "()}";
                cs = con.prepareCall(procedureCall);
                this.log().debug((Object)("Calling stored procedure: " + procedureCall));
                cs.registerOutParameter(1, -7);
                cs.executeUpdate();
                bPass = cs.getBoolean(1);
                this.log().debug((Object)("Stored procedure returned: " + bPass));
                if (!bPass) break block6;
                status = PollStatus.available();
            }
            catch (SQLException sqlEx) {
                try {
                    status = this.logDown(Level.DEBUG, "JDBC stored procedure call not functional: " + sqlEx.getSQLState() + ", " + sqlEx.toString(), sqlEx);
                }
                catch (Throwable throwable) {
                    this.closeStmt(cs);
                    throw throwable;
                }
                this.closeStmt(cs);
            }
        }
        this.closeStmt(cs);
        return status;
    }
}

