/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.apache.log4j.Category;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueImpl;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.ping.Packet;
import org.opennms.netmgt.ping.Reply;
import org.opennms.netmgt.ping.ReplyReceiver;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.utils.ParameterMap;
import org.opennms.protocols.icmp.IcmpSocket;

@Distributable(value={DistributionContext.DAEMON})
public final class IcmpMonitor
extends IPv4Monitor {
    private static final int DEFAULT_RETRY = 2;
    private static final int DEFAULT_TIMEOUT = 800;
    private static final short FILTER_ID = (short)new Random(System.currentTimeMillis()).nextInt();
    private static short m_seqid = (short)-17730;
    private static ReplyReceiver m_receiver = null;
    private static IcmpSocket m_icmpSock = null;
    private static Map m_waiting = Collections.synchronizedMap(new TreeMap());
    private static Thread m_worker = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IcmpMonitor() throws IOException {
        Class<IcmpMonitor> clazz = IcmpMonitor.class;
        synchronized (IcmpMonitor.class) {
            if (m_worker == null) {
                final FifoQueueImpl q = new FifoQueueImpl();
                m_icmpSock = new IcmpSocket();
                m_receiver = new ReplyReceiver(m_icmpSock, (FifoQueue)q, FILTER_ID);
                m_receiver.start();
                m_worker = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        while (true) {
                            Reply pong = null;
                            try {
                                pong = (Reply)q.remove();
                            }
                            catch (InterruptedException ex) {
                                break;
                            }
                            catch (Exception ex) {
                                ThreadCategory.getInstance(this.getClass()).error((Object)"Error processing response queue", (Throwable)ex);
                            }
                            Long key = new Long(pong.getPacket().getTID());
                            Ping ping = null;
                            Map map = m_waiting;
                            synchronized (map) {
                                ping = (Ping)m_waiting.get(key);
                            }
                            if (ping == null || !ping.isTarget(pong.getAddress())) continue;
                            ping.setPacket(pong.getPacket());
                            ping.signal();
                        }
                    }
                }, "IcmpMonitor-Receiver");
                m_worker.setDaemon(true);
                m_worker.start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static synchronized DatagramPacket getDatagram(InetAddress addr, long tid) {
        Packet iPkt = new Packet(tid);
        iPkt.setIdentity(FILTER_ID);
        short s = m_seqid;
        m_seqid = (short)(s + 1);
        iPkt.setSequenceId(s);
        byte[] data = iPkt.toBytes();
        return new DatagramPacket(data, data.length, addr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        int retry = ParameterMap.getKeyedInteger(parameters, "retry", 2);
        int timeout = ParameterMap.getKeyedInteger(parameters, "timeout", 800);
        Long tidKey = null;
        long tid = Thread.currentThread().hashCode();
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        Ping reply = new Ping(ipv4Addr);
        Map map = m_waiting;
        synchronized (map) {
            while (m_waiting.containsKey(tidKey = new Long(tid))) {
                ++tid;
            }
            m_waiting.put(tidKey, reply);
        }
        DatagramPacket pkt = IcmpMonitor.getDatagram(ipv4Addr, tid);
        PollStatus serviceStatus = PollStatus.unavailable();
        for (int attempts = 0; attempts <= retry && !reply.isSignaled(); ++attempts) {
            Ping ping = reply;
            synchronized (ping) {
                try {
                    m_icmpSock.send(pkt);
                }
                catch (IOException ioE) {
                    log.info((Object)("Failed to send to address " + ipv4Addr), (Throwable)ioE);
                    break;
                }
                catch (Throwable t) {
                    log.info((Object)("Undeclared throwable exception caught sending to " + ipv4Addr), t);
                    break;
                }
                try {
                    reply.wait(timeout);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        Map attempts = m_waiting;
        synchronized (attempts) {
            m_waiting.remove(tidKey);
        }
        if (reply.isSignaled()) {
            serviceStatus = PollStatus.available();
            Packet replyPkt = reply.getPacket();
            if (replyPkt != null) {
                long rtt = replyPkt.getPingRTT();
                serviceStatus.setResponseTime(rtt);
                log.debug((Object)("Ping round trip time for " + ipv4Addr + ": " + rtt + "us"));
            }
        }
        return serviceStatus;
    }

    private static final class Ping {
        private final InetAddress m_addr;
        private boolean m_signaled;
        private Packet m_packet;

        Ping(InetAddress addr) {
            this.m_addr = addr;
        }

        synchronized boolean isSignaled() {
            return this.m_signaled;
        }

        synchronized void signal() {
            this.m_signaled = true;
            this.notifyAll();
        }

        boolean isTarget(InetAddress addr) {
            return this.m_addr.equals(addr);
        }

        void setPacket(Packet packet) {
            this.m_packet = packet;
        }

        Packet getPacket() {
            return this.m_packet;
        }
    }
}

