/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.jmx;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.poller.Poller;
import org.opennms.netmgt.poller.jmx.PollerdMBean;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;

public class Pollerd
implements PollerdMBean {
    public static final String LOG4J_CATEGORY = "OpenNMS.Pollers";

    public void init() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        try {
            PollerConfigFactory.init();
            PollOutagesConfigFactory.init();
            DataSourceFactory.init();
            RrdUtils.initialize();
        }
        catch (MarshalException e) {
            this.log().error((Object)"Could not unmarshall configuration", (Throwable)e);
        }
        catch (ValidationException e) {
            this.log().error((Object)"validation error ", (Throwable)e);
        }
        catch (IOException e) {
            this.log().error((Object)"IOException: ", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            this.log().error((Object)"Unable to locate class ", (Throwable)e);
        }
        catch (SQLException e) {
            this.log().error((Object)"SQLException: ", (Throwable)e);
        }
        catch (PropertyVetoException e) {
            this.log().error((Object)"PropertyVetoException: ", (Throwable)e);
        }
        catch (RrdException e) {
            this.log().error((Object)"RrdException: ", (Throwable)e);
        }
        Poller poller = this.getPoller();
        poller.setPollerConfig(PollerConfigFactory.getInstance());
        poller.setPollOutagesConfig(PollOutagesConfigFactory.getInstance());
        poller.setDbConnectionFactory(DataSourceFactory.getInstance());
        EventIpcManagerFactory.init();
        EventIpcManager mgr = EventIpcManagerFactory.getIpcManager();
        poller.setEventManager(mgr);
        poller.init();
    }

    private Category log() {
        return ThreadCategory.getInstance();
    }

    public void start() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.getPoller().start();
    }

    public void stop() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.getPoller().stop();
    }

    public int getStatus() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return this.getPoller().getStatus();
    }

    public String status() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return Fiber.STATUS_NAMES[this.getStatus()];
    }

    public String getStatusText() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return Fiber.STATUS_NAMES[this.getStatus()];
    }

    private Poller getPoller() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return Poller.getInstance();
    }
}

