/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd.jmx;

import java.lang.reflect.UndeclaredThrowableException;
import org.apache.log4j.Category;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.DestinationPathFactory;
import org.opennms.netmgt.config.GroupFactory;
import org.opennms.netmgt.config.NotifdConfigFactory;
import org.opennms.netmgt.config.NotificationCommandFactory;
import org.opennms.netmgt.config.NotificationFactory;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.config.UserFactory;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.notifd.jmx.NotifdMBean;

public class Notifd
implements NotifdMBean {
    private static String LOG4J_CATEGORY = "OpenNMS.Notifd";

    public void init() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        Category log = ThreadCategory.getInstance(this.getClass());
        EventIpcManagerFactory.init();
        try {
            NotifdConfigFactory.init();
        }
        catch (Throwable t) {
            log.error((Object)"start: Failed to init NotifdConfigFactory.", t);
            throw new UndeclaredThrowableException(t);
        }
        try {
            NotificationFactory.init();
        }
        catch (Throwable t) {
            log.error((Object)"start: Failed to init NotificationFactory.", t);
            throw new UndeclaredThrowableException(t);
        }
        try {
            DataSourceFactory.init();
        }
        catch (Throwable t) {
            log.error((Object)"start: Failed to init database connection factory.", t);
            throw new UndeclaredThrowableException(t);
        }
        try {
            GroupFactory.init();
        }
        catch (Throwable t) {
            log.error((Object)"start: Failed to init group factory.", t);
            throw new UndeclaredThrowableException(t);
        }
        try {
            UserFactory.init();
        }
        catch (Throwable t) {
            log.error((Object)"start: Failed to init user factory.", t);
            throw new UndeclaredThrowableException(t);
        }
        try {
            DestinationPathFactory.init();
        }
        catch (Throwable t) {
            log.error((Object)"start: Failed to init destination path factory.", t);
            throw new UndeclaredThrowableException(t);
        }
        try {
            NotificationCommandFactory.init();
        }
        catch (Throwable t) {
            log.error((Object)"start: Failed to init notification command factory.", t);
            throw new UndeclaredThrowableException(t);
        }
        try {
            PollOutagesConfigFactory.init();
        }
        catch (Throwable t) {
            log.error((Object)"start: Failed to init poll outage config factory.", t);
            throw new UndeclaredThrowableException(t);
        }
        this.getNotifd().setEventManager(EventIpcManagerFactory.getIpcManager());
        this.getNotifd().setConfigManager(NotifdConfigFactory.getInstance());
        this.getNotifd().setNotificationManager(NotificationFactory.getInstance());
        this.getNotifd().setGroupManager(GroupFactory.getInstance());
        this.getNotifd().setUserManager(UserFactory.getInstance());
        this.getNotifd().setDestinationPathManager(DestinationPathFactory.getInstance());
        this.getNotifd().setNotificationCommandManager(NotificationCommandFactory.getInstance());
        this.getNotifd().setPollOutagesConfigManager(PollOutagesConfigFactory.getInstance());
        this.getNotifd().init();
    }

    private org.opennms.netmgt.notifd.Notifd getNotifd() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return org.opennms.netmgt.notifd.Notifd.getInstance();
    }

    public void start() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.getNotifd().start();
    }

    public void stop() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.getNotifd().stop();
    }

    public int getStatus() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return this.getNotifd().getStatus();
    }

    public String status() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return Fiber.STATUS_NAMES[this.getStatus()];
    }

    public String getStatusText() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return Fiber.STATUS_NAMES[this.getStatus()];
    }
}

