/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.util.List;
import org.opennms.core.utils.Argument;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.notifd.NotificationStrategy;
import org.opennms.netmgt.notifd.XMPPNotificationManager;

public class XMPPNotificationStrategy
implements NotificationStrategy {
    private static final int XMPP_TO = 0;
    private static final int XMPP_MESSAGE = 1;
    private static final int XMPP_MAX = 2;
    private static final String[] INDEX_TO_NAME = new String[XMPP_MAX];

    public int send(List arguments) {
        try {
            String[] parsedArgs = this.parseArguments(arguments);
            XMPPNotificationManager xmppManager = XMPPNotificationManager.getInstance();
            xmppManager.sendMessage(parsedArgs[XMPP_TO], parsedArgs[XMPP_MESSAGE]);
        }
        catch (Exception e) {
            ThreadCategory.getInstance(this.getClass()).error((Object)e.getMessage());
            return 1;
        }
        return 0;
    }

    private String[] parseArguments(List arguments) throws Exception {
        int i;
        String[] parsedArgs = new String[XMPP_MAX];
        for (i = 0; i < arguments.size(); ++i) {
            Argument arg = (Argument)arguments.get(i);
            if ("-xmpp".equals(arg.getSwitch())) {
                parsedArgs[XMPPNotificationStrategy.XMPP_TO] = arg.getValue();
                continue;
            }
            if (!"-tm".equals(arg.getSwitch())) continue;
            parsedArgs[XMPPNotificationStrategy.XMPP_MESSAGE] = arg.getValue();
        }
        for (i = 0; i < XMPP_MAX; ++i) {
            if (parsedArgs[i] != null) continue;
            throw new Exception("Incomplete argument set, missing argument: " + INDEX_TO_NAME[i]);
        }
        return parsedArgs;
    }

    static {
        XMPPNotificationStrategy.INDEX_TO_NAME[XMPPNotificationStrategy.XMPP_TO] = "To";
        XMPPNotificationStrategy.INDEX_TO_NAME[XMPPNotificationStrategy.XMPP_MESSAGE] = "Message";
    }
}

