/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.Argument;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.notifd.NotificationStrategy;
import org.opennms.netmgt.utils.JavaMailer;
import org.opennms.netmgt.utils.JavaMailerException;

public class JavaMailNotificationStrategy
implements NotificationStrategy {
    public int send(List arguments) {
        this.log().debug((Object)"In the JavaMailNotification class.");
        JavaMailer jm = this.buildMessage(arguments);
        try {
            jm.mailSend();
        }
        catch (JavaMailerException e) {
            this.log().error((Object)"send: Error sending notification.", (Throwable)e);
            return 1;
        }
        return 0;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private JavaMailer buildMessage(List arguments) {
        JavaMailer jm = new JavaMailer();
        for (int i = 0; i < arguments.size(); ++i) {
            Argument arg = (Argument)arguments.get(i);
            this.log().debug((Object)("Current arg switch: " + i + " of " + arguments.size() + " is: " + arg.getSwitch()));
            this.log().debug((Object)("Current arg  value: " + i + " of " + arguments.size() + " is: " + arg.getValue()));
            if ("-email".equals(arg.getSwitch())) {
                this.log().debug((Object)"Found: PARAM_EMAIL");
                jm.setTo(arg.getValue());
                continue;
            }
            if ("-pemail".equals(arg.getSwitch())) {
                this.log().debug((Object)"Found: PARAM_PAGER_EMAIL");
                jm.setTo(arg.getValue());
                continue;
            }
            if ("-subject".equals(arg.getSwitch())) {
                this.log().debug((Object)"Found: PARAM_SUBJECT");
                jm.setSubject(arg.getValue());
                continue;
            }
            if (!"-tm".equals(arg.getSwitch())) continue;
            this.log().debug((Object)"Found: PARAM_TEXT_MSG");
            jm.setMessageText(arg.getValue());
        }
        return jm;
    }
}

