/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import org.opennms.netmgt.capsd.snmp.NamedSnmpVar;
import org.opennms.netmgt.capsd.snmp.SnmpTableEntry;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

public final class QBridgeDot1dTpFdbTableEntry
extends SnmpTableEntry {
    public static final String FDB_ADDRESS = "dot1dTpFdbAddress";
    public static final String FDB_ADDRESS_OID = ".1.3.6.1.2.1.17.7.1.2.2.1.1";
    public static final String FDB_PORT = "dot1dTpFdbPort";
    public static final String FDB_STATUS = "dot1dTpFdbStatus";
    private boolean hasFdbAddress = false;
    public static NamedSnmpVar[] ms_elemList = null;
    public static final String TABLE_OID = ".1.3.6.1.2.1.17.7.1.2.2";

    public QBridgeDot1dTpFdbTableEntry() {
        super(ms_elemList);
    }

    public void storeResult(SnmpObjId base, SnmpInstId inst, SnmpValue val) {
        if (!this.hasFdbAddress) {
            int[] identifiers = inst.getIds();
            String mac = "";
            for (int i = identifiers.length - 6; i < identifiers.length; ++i) {
                mac = identifiers[i] >= 16 ? mac + Integer.toHexString(identifiers[i]) : mac + "0" + Integer.toHexString(identifiers[i]);
            }
            super.storeResult(new SnmpObjId(FDB_ADDRESS_OID), inst, SnmpUtils.getValueFactory().getOctetString(mac.getBytes()));
            this.hasFdbAddress = true;
        }
        super.storeResult(base, inst, val);
    }

    static {
        ms_elemList = new NamedSnmpVar[3];
        int ndx = 0;
        QBridgeDot1dTpFdbTableEntry.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", FDB_ADDRESS, FDB_ADDRESS_OID, 1);
        QBridgeDot1dTpFdbTableEntry.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", FDB_PORT, ".1.3.6.1.2.1.17.7.1.2.2.1.2", 2);
        QBridgeDot1dTpFdbTableEntry.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", FDB_STATUS, ".1.3.6.1.2.1.17.7.1.2.2.1.3", 3);
    }
}

