/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import org.opennms.netmgt.capsd.snmp.NamedSnmpVar;
import org.opennms.netmgt.capsd.snmp.SnmpTableEntry;
import org.opennms.netmgt.linkd.snmp.VlanCollectorEntry;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

public final class IntelVlanTableEntry
extends SnmpTableEntry
implements VlanCollectorEntry {
    public static final String VLAN_CREATEOBJ = "policyVlanCreateObj";
    public static final String VLAN_DELETEOBJ = "policyVlanDeleteObj";
    private static String VLAN_INDEX_OID = ".1.3.6.1.4.1.343.6.11.1.9.1.1";
    private static String VLAN_NAME_OID = ".1.3.6.1.4.1.343.6.11.1.9.1.2";
    private boolean hasVlanIndex = false;
    public static NamedSnmpVar[] intelVlan_elemList = null;
    public static final String TABLE_OID = ".1.3.6.1.4.1.343.6.11.1.9.1";

    public IntelVlanTableEntry() {
        super(intelVlan_elemList);
    }

    public void storeResult(SnmpObjId base, SnmpInstId inst, SnmpValue val) {
        if (!this.hasVlanIndex) {
            int vlanid = inst.getLastSubId();
            super.storeResult(new SnmpObjId(VLAN_INDEX_OID), inst, SnmpUtils.getValueFactory().getInt32(vlanid));
            super.storeResult(new SnmpObjId(VLAN_NAME_OID), inst, SnmpUtils.getValueFactory().getOctetString("default".getBytes()));
            this.hasVlanIndex = true;
        }
        super.storeResult(base, inst, val);
    }

    static {
        intelVlan_elemList = new NamedSnmpVar[4];
        int ndx = 0;
        IntelVlanTableEntry.intelVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "vtpVlanIndex", ".1.3.6.1.4.1.343.6.11.1.9.1.1", 1);
        IntelVlanTableEntry.intelVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "vtpVlanName", ".1.3.6.1.4.1.343.6.11.1.9.1.2", 2);
        IntelVlanTableEntry.intelVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", VLAN_CREATEOBJ, ".1.3.6.1.4.1.343.6.11.1.9.1.3", 3);
        IntelVlanTableEntry.intelVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", VLAN_DELETEOBJ, ".1.3.6.1.4.1.343.6.11.1.9.1.4", 4);
    }
}

