/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import org.opennms.netmgt.capsd.snmp.NamedSnmpVar;
import org.opennms.netmgt.capsd.snmp.SnmpTableEntry;
import org.opennms.netmgt.linkd.snmp.VlanCollectorEntry;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

public final class Dot1qStaticVlanTableEntry
extends SnmpTableEntry
implements VlanCollectorEntry {
    public static final String VLAN_STATICEGRESSPORTS = "dot1qVlanStaticEgressPorts";
    public static final String VLAN_FORBIDDENEGRESSPORTS = "dot1qVlanStaticForbiddenEgressPorts";
    public static final String VLAN_STATICUNTAGGEDPORTS = "dot1qVlanStaticUntaggedPorts";
    private static String VLAN_INDEX_OID = ".1.3.6.1.2.1.17.7.1.4.3.1.0";
    private static String VLAN_NAME_OID = ".1.3.6.1.2.1.17.7.1.4.3.1.1";
    private boolean hasVlanIndex = false;
    public static NamedSnmpVar[] hpVlan_elemList = null;
    public static final String TABLE_OID = ".1.3.6.1.2.1.17.7.1.4.3.1";

    public Dot1qStaticVlanTableEntry() {
        super(hpVlan_elemList);
    }

    public void storeResult(SnmpObjId base, SnmpInstId inst, SnmpValue val) {
        if (!this.hasVlanIndex) {
            int vlanid = inst.getLastSubId();
            super.storeResult(new SnmpObjId(VLAN_INDEX_OID), inst, SnmpUtils.getValueFactory().getInt32(vlanid));
            this.hasVlanIndex = true;
        }
        super.storeResult(base, inst, val);
    }

    static {
        hpVlan_elemList = new NamedSnmpVar[6];
        int ndx = 0;
        Dot1qStaticVlanTableEntry.hpVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "vtpVlanIndex", VLAN_INDEX_OID, 1);
        Dot1qStaticVlanTableEntry.hpVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "vtpVlanName", VLAN_NAME_OID, 2);
        Dot1qStaticVlanTableEntry.hpVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", VLAN_STATICEGRESSPORTS, ".1.3.6.1.2.1.17.7.1.4.3.1.2", 4);
        Dot1qStaticVlanTableEntry.hpVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", VLAN_FORBIDDENEGRESSPORTS, ".1.3.6.1.2.1.17.7.1.4.3.1.3", 5);
        Dot1qStaticVlanTableEntry.hpVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", VLAN_STATICUNTAGGEDPORTS, ".1.3.6.1.2.1.17.7.1.4.3.1.4", 6);
        Dot1qStaticVlanTableEntry.hpVlan_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "vtpVlanStatus", ".1.3.6.1.2.1.17.7.1.4.3.1.5", 5);
    }
}

