/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.InsufficientInformationException;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.eventd.EventListener;
import org.opennms.netmgt.linkd.EventUtils;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.utils.XmlrpcUtil;
import org.opennms.netmgt.xml.event.Event;

final class LinkdEventProcessor
implements EventListener {
    private String m_localServer = null;
    private Set m_notifySet = new HashSet();
    private Linkd m_linkd;

    public static boolean isXmlRpcEnabled() {
        return CapsdConfigFactory.getInstance().getXmlrpc().equals("true");
    }

    LinkdEventProcessor(Linkd linkd) {
        this.m_linkd = linkd;
        this.m_localServer = OpennmsServerConfigFactory.getInstance().getServerName();
        this.createMessageSelectorAndSubscribe();
    }

    public void close() {
        this.getLinkd().getIpcManager().removeEventListener(this);
    }

    private void createMessageSelectorAndSubscribe() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/nodes/nodeGainedService");
        ueiList.add("uei.opennms.org/nodes/nodeLostService");
        ueiList.add("uei.opennms.org/nodes/nodeDeleted");
        ueiList.add("uei.opennms.org/nodes/nodeRegainedService");
        this.getLinkd().getIpcManager().addEventListener((EventListener)this, ueiList);
    }

    public String getLocalServer() {
        return this.m_localServer;
    }

    public String getName() {
        return "Linkd:LinkdEventProcessor";
    }

    private Linkd getLinkd() {
        return this.m_linkd;
    }

    private void handleNodeDeleted(Event event) throws InsufficientInformationException, UnknownHostException, Throwable {
        EventUtils.checkNodeId(event);
        this.getLinkd().unscheduleNode((int)event.getNodeid());
    }

    private void handleNodeGainedService(Event event) throws InsufficientInformationException, UnknownHostException, Throwable {
        EventUtils.checkNodeId(event);
        this.getLinkd().scheduleNode((int)event.getNodeid());
    }

    private void handleNodeLostService(Event event) throws InsufficientInformationException, UnknownHostException, Throwable {
        EventUtils.checkNodeId(event);
        this.getLinkd().suspendNode((int)event.getNodeid());
    }

    private void handleRegainedService(Event event) throws InsufficientInformationException, UnknownHostException, Throwable {
        EventUtils.checkNodeId(event);
        this.getLinkd().wakeUpNode((int)event.getNodeid());
    }

    private void notifyEventError(Event event, String msg, Exception ex) {
        if (!LinkdEventProcessor.isXmlRpcEnabled()) {
            return;
        }
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        if (txNo != -1L && this.m_notifySet.contains(event.getUei())) {
            int status = 2;
            XmlrpcUtil.createAndSendXmlrpcNotificationEvent(txNo, event.getUei(), msg + ex.getMessage(), status, "OpenNMS.Capsd");
        }
    }

    private void notifyEventReceived(Event event) {
        if (!LinkdEventProcessor.isXmlRpcEnabled()) {
            return;
        }
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        if (txNo != -1L && this.m_notifySet.contains(event.getUei())) {
            StringBuffer message = new StringBuffer("Received event: ");
            message.append(event.getUei());
            message.append(" : ");
            message.append(event);
            int status = 0;
            XmlrpcUtil.createAndSendXmlrpcNotificationEvent(txNo, event.getUei(), message.toString(), status, "OpenNMS.Capsd");
        }
    }

    private void notifyEventSuccess(Event event) {
        if (!LinkdEventProcessor.isXmlRpcEnabled()) {
            return;
        }
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        if (txNo != -1L && this.m_notifySet.contains(event.getUei())) {
            StringBuffer message = new StringBuffer("Completed processing event: ");
            message.append(event.getUei());
            message.append(" : ");
            message.append(event);
            int status = 1;
            XmlrpcUtil.createAndSendXmlrpcNotificationEvent(txNo, event.getUei(), message.toString(), status, "OpenNMS.Capsd");
        }
    }

    public void onEvent(Event event) {
        Category log = ThreadCategory.getInstance(this.getClass());
        try {
            int eventid = event.getDbid();
            String eventUei = event.getUei();
            String eventService = event.getService();
            if (eventUei == null) {
                return;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("onEvent: Received event " + eventid + " UEI " + eventUei + "; service " + eventService));
            }
            this.notifyEventReceived(event);
            if (eventUei.equals("uei.opennms.org/nodes/nodeGainedService") && eventService.equals("SNMP")) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("onEvent: calling handleNodeGainedService for event " + eventid));
                }
                this.handleNodeGainedService(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/nodeLostService") && eventService.equals("SNMP")) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("onEvent: calling handleNodeLostService for event " + eventid));
                }
                this.handleNodeLostService(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/nodeRegainedService") && eventService.equals("SNMP")) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("onEvent: calling handleRegainedService for event " + eventid));
                }
                this.handleRegainedService(event);
            } else if (eventUei.equals("uei.opennms.org/nodes/nodeDeleted")) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("onEvent: calling handleNodeDeleted for event " + eventid));
                }
                this.handleNodeDeleted(event);
            }
            this.notifyEventSuccess(event);
        }
        catch (InsufficientInformationException ex) {
            log.info((Object)("onEvent: insufficient information in event, discarding it: " + ex.getMessage()));
            this.notifyEventError(event, "Invalid parameters: ", ex);
        }
        catch (UnknownHostException ex) {
            log.error((Object)("onEvent: operation failed for event: " + event.getUei() + ", exception: " + ex.getMessage()));
            this.notifyEventError(event, "processing failed: ", ex);
        }
        catch (Throwable t) {
            log.error((Object)("onEvent: operation failed for event: " + event.getUei() + ", exception: " + t.getMessage()));
        }
    }
}

