/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.LinkdConfigFactory;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.linkd.DbEventWriter;
import org.opennms.netmgt.linkd.DiscoveryLink;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.LinkdEventProcessor;
import org.opennms.netmgt.linkd.SnmpCollection;
import org.opennms.netmgt.linkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.linkd.scheduler.Scheduler;
import org.opennms.netmgt.xml.event.Event;

public class Linkd
implements PausableFiber {
    private static final String LOG4J_CATEGORY = "OpenNMS.Linkd";
    private static final Linkd m_singleton = new Linkd();
    private int m_status = 0;
    private Scheduler m_scheduler = null;
    private LinkdEventProcessor m_receiver;
    private HashMap<String, LinkableNode> snmpprimaryip2nodes;
    private EventIpcManager m_eventMgr;
    private boolean scheduledDiscoveryLink = false;
    private static long m_snmp_poll_interval = 1800000L;
    private static long m_initial_sleep_time = 300000L;
    private static long m_discovery_link_interval = 600000L;
    private static boolean m_auto_discovery = true;
    private List<String> ipaddressNewSuspenctevents = null;

    private Linkd() {
    }

    public static Linkd getInstance() {
        return m_singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        Category log = ThreadCategory.getInstance();
        if (log.isInfoEnabled()) {
            log.info((Object)("init: Category Level Set to " + log.getLevel().toString()));
        }
        try {
            CapsdConfigFactory.init();
        }
        catch (MarshalException ex) {
            log.error((Object)"Failed to load Capsd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            log.error((Object)"Failed to load Capsd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            log.error((Object)"Failed to load Capsd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        try {
            LinkdConfigFactory.init();
        }
        catch (ClassNotFoundException ex) {
            log.error((Object)"init: Failed to load linkd configuration file ", (Throwable)ex);
            return;
        }
        catch (MarshalException ex) {
            log.error((Object)"init: Failed to load linkd configuration file ", (Throwable)ex);
            return;
        }
        catch (ValidationException ex) {
            log.error((Object)"init: Failed to load linkd configuration file ", (Throwable)ex);
            return;
        }
        catch (IOException ex) {
            log.error((Object)"init: Failed to load linkd configuration file ", (Throwable)ex);
            return;
        }
        this.snmpprimaryip2nodes = new HashMap();
        try {
            SnmpPeerFactory.reload();
        }
        catch (MarshalException ex) {
            log.error((Object)"Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            log.error((Object)"Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            log.error((Object)"Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        try {
            DataSourceFactory.init();
        }
        catch (IOException ie) {
            log.fatal((Object)"IOException loading database config", (Throwable)ie);
            throw new UndeclaredThrowableException(ie);
        }
        catch (MarshalException me) {
            log.fatal((Object)"Marshall Exception loading database config", (Throwable)me);
            throw new UndeclaredThrowableException(me);
        }
        catch (ValidationException ve) {
            log.fatal((Object)"Validation Exception loading database config", (Throwable)ve);
            throw new UndeclaredThrowableException(ve);
        }
        catch (ClassNotFoundException ce) {
            log.fatal((Object)"Class lookup failure loading database config", (Throwable)ce);
            throw new UndeclaredThrowableException(ce);
        }
        catch (PropertyVetoException pve) {
            log.fatal((Object)"Property veto failure loading database config", (Throwable)pve);
            throw new UndeclaredThrowableException(pve);
        }
        catch (SQLException sqle) {
            log.fatal((Object)"SQL exception loading database config", (Throwable)sqle);
            throw new UndeclaredThrowableException(sqle);
        }
        try {
            m_initial_sleep_time = LinkdConfigFactory.getInstance().getInitialSleepTime();
        }
        catch (Throwable t) {
            log.error((Object)("init: Failed to load Initial Sleep Time from linkd configuration file " + t));
        }
        try {
            m_snmp_poll_interval = LinkdConfigFactory.getInstance().getSnmpPollInterval();
        }
        catch (Throwable t) {
            log.error((Object)("init: Failed to load Snmp Poll Interval from linkd configuration file " + t));
        }
        try {
            m_discovery_link_interval = LinkdConfigFactory.getInstance().getDiscoveryLinkInterval();
        }
        catch (Throwable t) {
            log.error((Object)("init: Failed to load Discovery Link Interval from linkd configuration file " + t));
        }
        try {
            m_auto_discovery = LinkdConfigFactory.getInstance().autoDiscovery();
        }
        catch (Throwable t) {
            log.error((Object)("init: Failed to load Auto Discovery from linkd configuration file " + t));
        }
        Connection dbConn = null;
        SnmpCollection[] snmpcolls = null;
        try {
            dbConn = DataSourceFactory.getInstance().getConnection();
            if (log.isDebugEnabled()) {
                log.debug((Object)"init: Loading Snmp nodes");
            }
            this.snmpprimaryip2nodes = LinkdConfigFactory.getInstance().getLinkableNodes(dbConn);
            snmpcolls = LinkdConfigFactory.getInstance().getSnmpColls(dbConn).values().toArray(new SnmpCollection[0]);
            LinkdConfigFactory.getInstance().updateDeletedNodes(dbConn);
        }
        catch (SQLException sqlE) {
            log.fatal((Object)"SQL Exception while syncing node object with database information.", (Throwable)sqlE);
            throw new UndeclaredThrowableException(sqlE);
        }
        catch (Throwable t) {
            log.fatal((Object)"Unknown error while syncing node object with database information.", t);
            throw new UndeclaredThrowableException(t);
        }
        finally {
            try {
                if (dbConn != null) {
                    dbConn.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"init: Creating link scheduler");
            }
            this.m_scheduler = new Scheduler("Linkd", LinkdConfigFactory.getInstance().getThreads());
        }
        catch (RuntimeException e) {
            log.fatal((Object)"init: Failed to create linkd scheduler", (Throwable)e);
            throw e;
        }
        catch (Throwable t) {
            log.error((Object)("init: Failed to load threads from linkd configuration file " + t));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init: scheduling " + this.snmpprimaryip2nodes.size() + " Snmp Collections "));
        }
        SnmpCollection snmpCollector = null;
        if (snmpcolls.length != 0) {
            ReadyRunnable readyRunnable;
            for (int i = 0; i < snmpcolls.length; ++i) {
                snmpCollector = snmpcolls[i];
                snmpCollector.setAutoDiscovery(m_auto_discovery);
                log.debug((Object)("init: scheduling Snmp Collection for ip " + snmpCollector.getSnmpIpPrimary().getHostAddress()));
                readyRunnable = snmpCollector;
                synchronized (readyRunnable) {
                    if (snmpCollector.getScheduler() == null) {
                        snmpCollector.setScheduler(this.m_scheduler);
                    }
                    snmpCollector.setPollInterval(m_snmp_poll_interval);
                    snmpCollector.setInitialSleepTime(m_initial_sleep_time);
                    m_initial_sleep_time += 5000L;
                }
                snmpCollector.schedule();
            }
            DiscoveryLink discoveryLink = new DiscoveryLink();
            if (log.isDebugEnabled()) {
                log.debug((Object)"init: scheduling Discovery Link");
            }
            readyRunnable = discoveryLink;
            synchronized (readyRunnable) {
                if (discoveryLink.getScheduler() == null) {
                    discoveryLink.setScheduler(this.m_scheduler);
                }
                discoveryLink.setSnmpPollInterval(m_snmp_poll_interval);
                discoveryLink.setDiscoveryInterval(m_discovery_link_interval);
                discoveryLink.setInitialSleepTime(m_initial_sleep_time);
            }
            discoveryLink.schedule();
            this.scheduledDiscoveryLink = true;
        }
        EventIpcManagerFactory.init();
        this.m_eventMgr = EventIpcManagerFactory.getIpcManager();
        if (log.isDebugEnabled()) {
            log.debug((Object)"init: Creating event Manager");
        }
        this.ipaddressNewSuspenctevents = new ArrayList<String>();
        this.ipaddressNewSuspenctevents.add("127.0.0.1");
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"init: Creating event broadcast event receiver");
            }
            this.m_receiver = new LinkdEventProcessor(this);
        }
        catch (Throwable t) {
            log.error((Object)"init: Failed to initialized the broadcast event receiver", t);
            throw new UndeclaredThrowableException(t);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"init: LINKD CONFIGURATION INITIALIZED");
        }
    }

    public synchronized void start() {
        this.m_status = 1;
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        Category log = ThreadCategory.getInstance();
        if (log.isDebugEnabled()) {
            log.debug((Object)"start: Starting Linkd");
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"start: Starting linkd scheduler");
            }
            this.m_scheduler.start();
        }
        catch (RuntimeException e) {
            log.fatal((Object)"start: Failed to start scheduler", (Throwable)e);
            throw e;
        }
        this.m_status = 2;
        if (log.isInfoEnabled()) {
            log.info((Object)"start: Linkd running");
        }
    }

    public synchronized void stop() {
        this.m_status = 3;
        this.m_scheduler.stop();
        this.m_receiver.close();
        this.m_scheduler = null;
        this.m_status = 4;
        Category log = ThreadCategory.getInstance();
        if (log.isInfoEnabled()) {
            log.info((Object)"stop: Linkd stopped");
        }
    }

    public synchronized void reload() throws IOException {
    }

    public synchronized void pause() {
        if (this.m_status != 2) {
            return;
        }
        this.m_status = 5;
        this.m_scheduler.pause();
        this.m_status = 6;
        Category log = ThreadCategory.getInstance();
        if (log.isInfoEnabled()) {
            log.info((Object)"pause: Linkd paused");
        }
    }

    public synchronized void resume() {
        if (this.m_status != 6) {
            return;
        }
        this.m_status = 7;
        this.m_scheduler.resume();
        this.m_status = 2;
        Category log = ThreadCategory.getInstance();
        if (log.isInfoEnabled()) {
            log.info((Object)"resume: Linkd resumed");
        }
    }

    public String getName() {
        return LOG4J_CATEGORY;
    }

    public int getStatus() {
        return this.m_status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkableNode[] getSnmpLinkableNodes() {
        HashMap<String, LinkableNode> hashMap = this.snmpprimaryip2nodes;
        synchronized (hashMap) {
            return this.snmpprimaryip2nodes.values().toArray(new LinkableNode[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleNode(int nid) throws UnknownHostException, Throwable {
        ReadyRunnable readyRunnable;
        Category log = ThreadCategory.getInstance();
        Connection dbConn = null;
        SnmpCollection coll = null;
        try {
            dbConn = DataSourceFactory.getInstance().getConnection();
            if (log.isDebugEnabled()) {
                log.debug((Object)("scheduleNode: Loading node " + nid + " from database"));
            }
            try {
                coll = LinkdConfigFactory.getInstance().getSnmpCollection(dbConn, nid);
            }
            catch (UnknownHostException h) {
                log.warn((Object)("scheduleNode: Failed to get Linkable node from LinkdConfigFactory" + h));
            }
        }
        catch (SQLException sqlE) {
            log.fatal((Object)"scheduleNode: SQL Exception while syncing node object with database information.", (Throwable)sqlE);
            throw new UndeclaredThrowableException(sqlE);
        }
        catch (Throwable t) {
            log.fatal((Object)"scheduleNode: Unknown error while syncing node object with database information.", t);
            throw new UndeclaredThrowableException(t);
        }
        finally {
            try {
                if (dbConn != null) {
                    dbConn.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"scheduleNode: SQL Exception while syncing node object with database information.", (Throwable)e);
            }
        }
        InetAddress ipAddr = coll.getSnmpIpPrimary();
        String ip = ipAddr.getHostAddress();
        LinkableNode node = new LinkableNode(nid, ip);
        HashMap<String, LinkableNode> hashMap = this.snmpprimaryip2nodes;
        synchronized (hashMap) {
            if (this.snmpprimaryip2nodes.containsKey(ip)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Node collection exists: skipping schedule, performing DB cleaning");
                }
                LinkableNode oldNode = this.snmpprimaryip2nodes.get(ip);
                if (node.getNodeId() != oldNode.getNodeId()) {
                    DbEventWriter dbwriter = new DbEventWriter(oldNode.getNodeId(), 'D');
                    dbwriter.run();
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Node collection does not exists: scheduling");
                }
                readyRunnable = coll;
                synchronized (readyRunnable) {
                    if (coll.getScheduler() == null) {
                        coll.setScheduler(this.m_scheduler);
                    }
                    coll.setPollInterval(m_snmp_poll_interval);
                    coll.setInitialSleepTime(0L);
                    coll.setAutoDiscovery(m_auto_discovery);
                    coll.schedule();
                }
            }
            this.snmpprimaryip2nodes.put(ip, node);
        }
        if (!this.scheduledDiscoveryLink) {
            DiscoveryLink discoveryLink = new DiscoveryLink();
            if (log.isDebugEnabled()) {
                log.debug((Object)"scheduleNode: scheduling Discovery Link");
            }
            readyRunnable = discoveryLink;
            synchronized (readyRunnable) {
                if (discoveryLink.getScheduler() == null) {
                    discoveryLink.setScheduler(this.m_scheduler);
                }
                discoveryLink.setSnmpPollInterval(m_snmp_poll_interval);
                discoveryLink.setDiscoveryInterval(m_discovery_link_interval);
                discoveryLink.setInitialSleepTime(0L);
            }
            discoveryLink.schedule();
            this.scheduledDiscoveryLink = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeUpNode(int nid) throws UnknownHostException, Throwable {
        Category log = ThreadCategory.getInstance();
        Connection dbConn = null;
        InetAddress ipAddr = null;
        try {
            dbConn = DataSourceFactory.getInstance().getConnection();
            if (log.isDebugEnabled()) {
                log.debug((Object)("wakeUpNode: Loading node " + nid + " from database"));
            }
            try {
                ipAddr = LinkdConfigFactory.getInstance().getSnmpPrimaryIp(dbConn, nid);
            }
            catch (UnknownHostException h) {
                log.warn((Object)("wakeUpNode: Failed to get Linkable node from LinkdConfigFactory" + h));
            }
        }
        catch (SQLException sqlE) {
            log.fatal((Object)"wakeUpNode: SQL Exception while syncing node object with database information.", (Throwable)sqlE);
            throw new UndeclaredThrowableException(sqlE);
        }
        catch (Throwable t) {
            log.fatal((Object)"wakeUpNode: Unknown error while syncing node object with database information.", t);
            throw new UndeclaredThrowableException(t);
        }
        finally {
            try {
                if (dbConn != null) {
                    dbConn.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"wakeUpNode: SQL Exception while syncing node object with database information.", (Throwable)e);
            }
        }
        String ip = ipAddr.getHostAddress();
        LinkableNode node = new LinkableNode(nid, ip);
        HashMap<String, LinkableNode> e = this.snmpprimaryip2nodes;
        synchronized (e) {
            if (this.snmpprimaryip2nodes.containsKey(ip)) {
                LinkableNode oldNode = this.snmpprimaryip2nodes.get(ip);
                if (node.getNodeId() != oldNode.getNodeId()) {
                    DbEventWriter dbwriter = new DbEventWriter(oldNode.getNodeId(), 'D');
                    dbwriter.run();
                }
            }
            this.snmpprimaryip2nodes.put(ip, node);
        }
        ReadyRunnable rr = this.m_scheduler.getReadyRunnable(ipAddr);
        if (rr == null) {
            this.scheduleNode(nid);
        } else {
            rr.wakeUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unscheduleNode(int nid) throws UnknownHostException, Throwable {
        Category log = ThreadCategory.getInstance();
        boolean passed = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("unscheduleNode: deleting snmp collection for node " + nid));
        }
        InetAddress ipAddr = null;
        HashMap<String, LinkableNode> hashMap = this.snmpprimaryip2nodes;
        synchronized (hashMap) {
            for (LinkableNode node : this.snmpprimaryip2nodes.values()) {
                if (node.getNodeId() != nid) continue;
                this.snmpprimaryip2nodes.remove(node.getSnmpPrimaryIpAddr());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("unscheduleNode: removed linkable node from snmp collection for node " + nid));
                }
                ipAddr = InetAddress.getByName(node.getSnmpPrimaryIpAddr());
                passed = true;
                break;
            }
        }
        if (!passed) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("unscheduleNode: linkable node not found on snmp collection for node " + nid));
            }
            Connection dbConn = null;
            try {
                dbConn = DataSourceFactory.getInstance().getConnection();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("unscheduleNode: Loading node " + nid + " from database"));
                }
                try {
                    ipAddr = LinkdConfigFactory.getInstance().getSnmpPrimaryIp(dbConn, nid);
                }
                catch (UnknownHostException h) {
                    log.warn((Object)("unscheduleNode: Failed to get Linkable node from LinkdConfigFactory" + h));
                }
            }
            catch (SQLException sqlE) {
                log.fatal((Object)"unscheduleNode: SQL Exception while syncing node object with database information.", (Throwable)sqlE);
                throw new UndeclaredThrowableException(sqlE);
            }
            catch (Throwable t) {
                log.fatal((Object)"unscheduleNode: Unknown error while syncing node object with database information.", t);
                throw new UndeclaredThrowableException(t);
            }
            finally {
                try {
                    if (dbConn != null) {
                        dbConn.close();
                    }
                }
                catch (SQLException e) {
                    log.error((Object)"unscheduleNode: SQL Exception while syncing node object with database information.", (Throwable)e);
                }
            }
        }
        if (ipAddr != null) {
            ReadyRunnable rr = this.m_scheduler.getReadyRunnable(ipAddr);
            if (rr != null) {
                rr.unschedule();
            } else if (log.isInfoEnabled()) {
                log.info((Object)("unscheduleNode: Failed to get Ready Runnable for ipaddress " + ipAddr.getHostAddress() + " with nodeid " + nid));
            }
        } else {
            log.warn((Object)("unscheduleNode: Failed to get ipaddress for node " + nid));
        }
        DbEventWriter dbwriter = new DbEventWriter(nid, 'D');
        dbwriter.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void suspendNode(int nid) throws UnknownHostException, Throwable {
        Category log = ThreadCategory.getInstance();
        boolean passed = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("suspendNode: suspend snmp collection for node " + nid));
        }
        InetAddress ipAddr = null;
        HashMap<String, LinkableNode> hashMap = this.snmpprimaryip2nodes;
        synchronized (hashMap) {
            for (LinkableNode node : this.snmpprimaryip2nodes.values()) {
                if (node.getNodeId() != nid) continue;
                this.snmpprimaryip2nodes.remove(node.getSnmpPrimaryIpAddr());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("suspendNode: removed linkable node from snmp collection for node " + nid));
                }
                ipAddr = InetAddress.getByName(node.getSnmpPrimaryIpAddr());
                passed = true;
                break;
            }
        }
        if (!passed) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("suspendNode: linkable node not found on snmp collection for node " + nid));
            }
            Connection dbConn = null;
            try {
                dbConn = DataSourceFactory.getInstance().getConnection();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("suspendNode: Loading node " + nid + " from database"));
                }
                try {
                    ipAddr = LinkdConfigFactory.getInstance().getSnmpPrimaryIp(dbConn, nid);
                }
                catch (UnknownHostException h) {
                    log.warn((Object)("suspendNode: Failed to get Linkable node from LinkdConfigFactory" + h));
                }
            }
            catch (SQLException sqlE) {
                log.fatal((Object)"suspendNode: SQL Exception while syncing node object with database information.", (Throwable)sqlE);
                throw new UndeclaredThrowableException(sqlE);
            }
            catch (Throwable t) {
                log.fatal((Object)"suspendNode: Unknown error while syncing node object with database information.", t);
                throw new UndeclaredThrowableException(t);
            }
            finally {
                try {
                    if (dbConn != null) {
                        dbConn.close();
                    }
                }
                catch (SQLException e) {
                    log.error((Object)"suspendNode: SQL Exception while syncing node object with database information.", (Throwable)e);
                }
            }
        }
        if (ipAddr != null) {
            ReadyRunnable rr = this.m_scheduler.getReadyRunnable(ipAddr);
            if (rr != null) {
                rr.suspend();
            } else if (log.isInfoEnabled()) {
                log.info((Object)("suspendNode: Failed to get Ready Runnable for ipaddress " + ipAddr.getHostAddress() + " with nodeid " + nid));
            }
        } else {
            log.warn((Object)("suspendNode: Failed to get ipaddress for node " + nid));
        }
        DbEventWriter dbwriter = new DbEventWriter(nid, 'N');
        dbwriter.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateNodeSnmpCollection(SnmpCollection snmpcoll) {
        Category log = ThreadCategory.getInstance();
        HashMap<String, LinkableNode> hashMap = this.snmpprimaryip2nodes;
        synchronized (hashMap) {
            if (this.snmpprimaryip2nodes.containsKey(snmpcoll.getTarget().getHostAddress())) {
                LinkableNode node = this.snmpprimaryip2nodes.get(snmpcoll.getTarget().getHostAddress());
                DbEventWriter dbwriter = new DbEventWriter(node.getNodeId(), snmpcoll);
                dbwriter.run();
                node = dbwriter.getLinkableNode();
                this.snmpprimaryip2nodes.put(snmpcoll.getTarget().getHostAddress(), node);
            } else {
                log.warn((Object)"updateNodeSnmpCollection: cannot find Linkable SNMP Node element in hash snmpprimaryip2nodes");
            }
        }
    }

    void updateDiscoveryLinkCollection(DiscoveryLink discover) {
        DbEventWriter dbwriter = new DbEventWriter(discover);
        dbwriter.run();
    }

    void sendNewSuspectEvent(String ipInterface, String ipowner) {
        if (!this.ipaddressNewSuspenctevents.contains(ipInterface)) {
            Event event = new Event();
            event.setSource("linkd");
            event.setUei("uei.opennms.org/internal/discovery/newSuspect");
            event.setHost(ipowner);
            event.setInterface(ipInterface);
            event.setTime(EventConstants.formatToString(new Date()));
            this.m_eventMgr.sendNow(event);
            this.ipaddressNewSuspenctevents.add(ipInterface);
        }
    }

    EventIpcManager getIpcManager() {
        return this.m_eventMgr;
    }
}

