/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.linkd.AtInterface;
import org.opennms.netmgt.linkd.BridgeStpInterface;
import org.opennms.netmgt.linkd.CdpInterface;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.linkd.MacToNodeLink;
import org.opennms.netmgt.linkd.NodeToNodeLink;
import org.opennms.netmgt.linkd.RouterInterface;
import org.opennms.netmgt.linkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.linkd.scheduler.Scheduler;

final class DiscoveryLink
implements ReadyRunnable {
    private static final int SNMP_IF_TYPE_ETHERNET = 6;
    private static final int SNMP_IF_TYPE_PROP_VIRTUAL = 53;
    private List<LinkableNode> activenode = new ArrayList<LinkableNode>();
    private List<NodeToNodeLink> links = new ArrayList<NodeToNodeLink>();
    private List<MacToNodeLink> maclinks = new ArrayList<MacToNodeLink>();
    private HashMap<Integer, LinkableNode> m_bridge = new HashMap();
    private List<LinkableNode> routerNodes = new ArrayList<LinkableNode>();
    private List<LinkableNode> cdpNodes = new ArrayList<LinkableNode>();
    private List<String> macsParsed = new ArrayList<String>();
    private Map<String, AtInterface> macToAtinterface = new HashMap<String, AtInterface>();
    private Map<Integer, Set<String>> nodeToMac = new HashMap<Integer, Set<String>>();
    private boolean suspendCollection = false;
    private boolean isRunned = false;
    private Scheduler m_scheduler;
    private long snmp_poll_interval = 1800000L;
    private long discovery_interval = 300000L;
    private long initial_sleep_time = 600000L;

    DiscoveryLink() {
    }

    public void run() {
        Category log = ThreadCategory.getInstance(this.getClass());
        if (this.suspendCollection) {
            log.debug((Object)"DiscoveryLink.run: Suspended!");
        } else {
            LinkableNode[] all_snmplinknodes = Linkd.getInstance().getSnmpLinkableNodes();
            Iterator<Object> ite = null;
            for (int i = 0; i < all_snmplinknodes.length; ++i) {
                LinkableNode curNode = all_snmplinknodes[i];
                if (curNode == null) {
                    log.error((Object)("run: null linkable node found for iterator " + i));
                    continue;
                }
                int curNodeId = curNode.getNodeId();
                this.activenode.add(curNode);
                if (curNode.isBridgeNode) {
                    this.m_bridge.put(new Integer(curNodeId), curNode);
                }
                if (curNode.hasCdpInterfaces()) {
                    this.cdpNodes.add(curNode);
                }
                if (curNode.hasRouteInterfaces()) {
                    this.routerNodes.add(curNode);
                }
                if (!curNode.hasAtInterfaces()) continue;
                for (AtInterface at : curNode.getAtInterfaces()) {
                    String macAddress = at.getMacAddress();
                    this.macToAtinterface.put(macAddress, at);
                    Integer node = new Integer(at.getNodeId());
                    Set<String> macs = new HashSet<String>();
                    if (this.nodeToMac.containsKey(node)) {
                        macs = this.nodeToMac.get(node);
                    }
                    macs.add(macAddress);
                    this.nodeToMac.put(node, macs);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"run: finding links among nodes using Cisco Discovery Protocol");
            }
            for (LinkableNode curNode : this.cdpNodes) {
                int curCdpNodeId = curNode.getNodeId();
                String curCdpIpAddr = curNode.getSnmpPrimaryIpAddr();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("run: parsing nodeid " + curCdpNodeId + " ip address " + curCdpIpAddr + " with " + curNode.getCdpInterfaces().size() + " Cdp Interfaces. "));
                }
                for (CdpInterface cdpIface : curNode.getCdpInterfaces()) {
                    LinkableNode targetNode;
                    int cdpIfIndex = cdpIface.getCdpIfIndex();
                    if (cdpIfIndex < 0) {
                        log.warn((Object)("run: found not valid CDP IfIndex " + cdpIfIndex + " . Skipping"));
                        continue;
                    }
                    InetAddress targetIpAddr = cdpIface.getCdpTargetIpAddr();
                    int targetCdpNodeId = cdpIface.getCdpTargetNodeId();
                    if (targetCdpNodeId == -1) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("run: no node id found for ip address " + targetIpAddr.getHostAddress() + ". Skipping"));
                        continue;
                    }
                    if (targetCdpNodeId == curCdpNodeId) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("run: node id found for ip address " + targetIpAddr.getHostAddress() + " is itself. Skipping"));
                        continue;
                    }
                    int cdpDestIfindex = cdpIface.getCdpTargetIfIndex();
                    if (cdpDestIfindex < 0) {
                        log.warn((Object)("run: found not valid CDP destination IfIndex " + cdpDestIfindex + " . Skipping"));
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("run: CDP link found: nodeid=" + curCdpNodeId + " ifindex=" + cdpIfIndex + " nodeparentid=" + targetCdpNodeId + " parentifindex=" + cdpDestIfindex));
                    }
                    boolean add = true;
                    if (curNode.isBridgeNode() && this.isBridgeNode(targetCdpNodeId)) {
                        targetNode = this.m_bridge.get(new Integer(targetCdpNodeId));
                        add = this.parseCdpLinkOn(curNode, cdpIfIndex, targetNode, cdpDestIfindex, log);
                    } else if (curNode.isBridgeNode) {
                        add = this.parseCdpLinkOn(curNode, cdpIfIndex, targetCdpNodeId, log);
                    } else if (this.isBridgeNode(targetCdpNodeId)) {
                        targetNode = this.m_bridge.get(new Integer(targetCdpNodeId));
                        add = this.parseCdpLinkOn(targetNode, cdpDestIfindex, curCdpNodeId, log);
                    }
                    if (!add) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"run: try add CDP link found ");
                    }
                    NodeToNodeLink lk = new NodeToNodeLink(targetCdpNodeId, cdpDestIfindex);
                    lk.setNodeparentid(curCdpNodeId);
                    lk.setParentifindex(cdpIfIndex);
                    this.addNodetoNodeLink(lk, log);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"run: try to found backbone ethernet links among bridge nodes using Spanning Tree Protocol");
            }
            for (LinkableNode curNode : this.m_bridge.values()) {
                int curNodeId = curNode.getNodeId();
                String cupIpAddr = curNode.getSnmpPrimaryIpAddr();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("run: parsing bridge nodeid " + curNodeId + " ip address " + cupIpAddr));
                }
                Iterator<Object> sub_ite = curNode.getStpInterfaces().entrySet().iterator();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("run: parsing " + curNode.getStpInterfaces().size() + " Vlan. "));
                }
                while (sub_ite.hasNext()) {
                    Map.Entry me = (Map.Entry)sub_ite.next();
                    String vlan = (String)me.getKey();
                    String curBaseBridgeAddress = curNode.getBridgeIdentifier(vlan);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("run: found bridge identifier " + curBaseBridgeAddress));
                    }
                    String designatedRoot = null;
                    if (!curNode.hasStpRoot(vlan)) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("run: desigated root bridge identifier not found. Skipping" + curBaseBridgeAddress));
                        continue;
                    }
                    designatedRoot = curNode.getStpRoot(vlan);
                    if (designatedRoot.equals("0000000000000000")) {
                        log.warn((Object)"run: designated root is invalid. Skipping");
                        continue;
                    }
                    if (curNode.isBridgeIdentifier(designatedRoot.substring(4))) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"run: STP designated root is the bridge itself. Skipping");
                        continue;
                    }
                    Iterator stp_ite = ((List)me.getValue()).iterator();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"run: STP designated root is another bridge. Parsing Stp Interface");
                    }
                    while (stp_ite.hasNext()) {
                        BridgeStpInterface stpIface = (BridgeStpInterface)stp_ite.next();
                        int stpbridgeport = stpIface.getBridgeport();
                        if (curNode.isBackBoneBridgePort(stpbridgeport)) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("run: bridge port " + stpbridgeport + " already found .... Skipping"));
                            continue;
                        }
                        String stpPortDesignatedPort = stpIface.getStpPortDesignatedPort();
                        String stpPortDesignatedBridge = stpIface.getStpPortDesignatedBridge();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("run: parsing bridge port " + stpbridgeport + " with stp designated bridge " + stpPortDesignatedBridge + " and with stp designated port " + stpPortDesignatedPort));
                        }
                        if (stpPortDesignatedBridge.equals("0000000000000000")) {
                            log.warn((Object)("run: designated bridge is invalid " + stpPortDesignatedBridge));
                            continue;
                        }
                        if (curNode.isBridgeIdentifier(stpPortDesignatedBridge.substring(4))) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("run: designated bridge for port " + stpbridgeport + " is bridge itself "));
                            continue;
                        }
                        if (stpPortDesignatedPort.equals("0000")) {
                            log.warn((Object)("run: designated port is invalid " + stpPortDesignatedPort));
                            continue;
                        }
                        int designatedbridgeport = Integer.parseInt(stpPortDesignatedPort.substring(1), 16);
                        LinkableNode designatedNode = this.getNodeFromMacIdentifierOfBridgeNode(stpPortDesignatedBridge.substring(4));
                        if (designatedNode == null) {
                            log.warn((Object)("run: no nodeid found for stp bridge address " + stpPortDesignatedBridge + " . Nothing to save to db"));
                            continue;
                        }
                        int designatednodeid = designatedNode.getNodeId();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("run: found designated nodeid " + designatednodeid));
                        }
                        if (!this.isNearestBridgeLink(curNode, stpbridgeport, designatedNode, designatedbridgeport)) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"run: other bridge found between nodes. Nothing to save to db");
                            continue;
                        }
                        int curIfIndex = curNode.getIfindex(stpbridgeport);
                        if (curIfIndex == -1) {
                            log.warn((Object)"run: got invalid ifindex");
                            continue;
                        }
                        int designatedifindex = designatedNode.getIfindex(designatedbridgeport);
                        if (designatedifindex == -1) {
                            log.warn((Object)"run: got invalid ifindex on designated node");
                            continue;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("run: backbone port found for node " + curNodeId + ". Adding to bridge" + stpbridgeport));
                        }
                        curNode.addBackBoneBridgePorts(stpbridgeport);
                        this.m_bridge.put(new Integer(curNodeId), curNode);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("run: backbone port found for node " + designatednodeid + " .Adding to helper class bb port " + " bridge port " + designatedbridgeport));
                        }
                        designatedNode.addBackBoneBridgePorts(designatedbridgeport);
                        this.m_bridge.put(new Integer(designatednodeid), designatedNode);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("run: adding links on bb bridge port " + designatedbridgeport));
                        }
                        this.addLinks(this.getMacsOnBridgeLink(curNode, stpbridgeport, designatedNode, designatedbridgeport), curNodeId, curIfIndex, log);
                        NodeToNodeLink lk = new NodeToNodeLink(curNodeId, curIfIndex);
                        lk.setNodeparentid(designatednodeid);
                        lk.setParentifindex(designatedifindex);
                        this.addNodetoNodeLink(lk, log);
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"run: try to found links using Mac Address Forwarding Table");
            }
            for (LinkableNode curNode : this.m_bridge.values()) {
                int curNodeId = curNode.getNodeId();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("run: parsing node bridge " + curNodeId));
                }
                block8: for (Integer intePort : curNode.getPortMacs().keySet()) {
                    int curBridgePort = intePort;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("run: parsing bridge port " + curBridgePort + " with mac addresses " + curNode.getMacAddressesOnBridgePort(curBridgePort).toString()));
                    }
                    if (curNode.isBackBoneBridgePort(curBridgePort)) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("run: parsing backbone bridge port " + curBridgePort + " .... Skipping"));
                        continue;
                    }
                    Set<String> macs = curNode.getMacAddressesOnBridgePort(curBridgePort);
                    HashMap bridgesOnPort = new HashMap();
                    bridgesOnPort = this.getBridgesFromMacs(macs);
                    if (bridgesOnPort.isEmpty()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("run: no bridge info found on port " + curBridgePort + " .... Saving Macs"));
                        }
                        int curIfIndex = curNode.getIfindex(curBridgePort);
                        this.addLinks(macs, curNodeId, curIfIndex, log);
                        continue;
                    }
                    block9: for (LinkableNode endNode : bridgesOnPort.values()) {
                        LinkableNode targetNode;
                        int endNodeid = endNode.getNodeId();
                        int endBridgePort = this.getBridgePortOnEndBridge(curNode, endNode);
                        if (endNode.isBackBoneBridgePort(endBridgePort)) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("run: testing backbone bridge port " + endBridgePort + " .... Skipping"));
                            continue;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("run: using mac address table found bridge port " + endBridgePort + " on node " + endNodeid));
                        }
                        if (endBridgePort == -1) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("run: no port found on bridge nodeid " + endNodeid + " for node bridge identifiers nodeid " + curNodeId + " . .....Skipping"));
                            continue;
                        }
                        while ((targetNode = this.findNearestBridgeLink(curNode, curBridgePort, endNode, endBridgePort)).getNodeId() != endNode.getNodeId()) {
                            endNode = targetNode;
                            endNodeid = endNode.getNodeId();
                            endBridgePort = this.getBridgePortOnEndBridge(curNode, endNode);
                            if (endNode.isBackBoneBridgePort(endBridgePort)) {
                                if (!log.isDebugEnabled()) continue block9;
                                log.debug((Object)("run: testing backbone bridge port " + endBridgePort + " .... Skipping"));
                                continue block9;
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("run: using mac address table found bridge port " + endBridgePort + " on node " + endNodeid));
                            }
                            if (endBridgePort == -1) {
                                if (!log.isDebugEnabled()) continue block9;
                                log.debug((Object)("run: no port found on bridge nodeid " + endNodeid + " for node bridge identifiers nodeid " + curNodeId + " . .....Skipping"));
                                continue block9;
                            }
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"run: other bridge found between nodes. Iteration on bridge node");
                        }
                        int curIfIndex = curNode.getIfindex(curBridgePort);
                        if (curIfIndex == -1) {
                            log.warn((Object)("run: got invalid ifindex on bridge port " + curBridgePort));
                            continue;
                        }
                        int endIfindex = endNode.getIfindex(endBridgePort);
                        if (endIfindex == -1) {
                            log.warn((Object)("run: got invalid ifindex o designated bridge port " + endBridgePort));
                            continue;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("run: backbone port found for node " + curNodeId + ". Adding backbone port " + curBridgePort + " to bridge"));
                        }
                        curNode.addBackBoneBridgePorts(curBridgePort);
                        this.m_bridge.put(new Integer(curNodeId), curNode);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("run: backbone port found for node " + endNodeid + " .Adding to helper class bb port " + " bridge port " + endBridgePort));
                        }
                        endNode.addBackBoneBridgePorts(endBridgePort);
                        this.m_bridge.put(new Integer(endNodeid), endNode);
                        this.addLinks(this.getMacsOnBridgeLink(curNode, curBridgePort, endNode, endBridgePort), curNodeId, curIfIndex, log);
                        NodeToNodeLink lk = new NodeToNodeLink(curNodeId, curIfIndex);
                        lk.setNodeparentid(endNodeid);
                        lk.setParentifindex(endIfindex);
                        this.addNodetoNodeLink(lk, log);
                        continue block8;
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"run: try to found remaining links (Orfani!) on BackBoneBridgePort");
            }
            for (LinkableNode curNode : this.m_bridge.values()) {
                for (Integer intePort : curNode.getBackBoneBridgePorts()) {
                    int bridgePort = intePort;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("run: parsing backbone bridge port " + bridgePort + " on node " + curNode.getSnmpPrimaryIpAddr()));
                    }
                    if (!curNode.hasMacAddressesOnBridgePort(bridgePort)) {
                        log.warn((Object)"run: bridge port has no mac address on.   Skipping. ");
                        continue;
                    }
                    int curIfIndex = curNode.getIfindex(bridgePort);
                    if (curIfIndex == -1) {
                        log.warn((Object)("run: got invalid ifindex on backbone bridge port " + bridgePort));
                        continue;
                    }
                    this.addLinks(curNode.getMacAddressesOnBridgePort(bridgePort), curNode.getNodeId(), curIfIndex, log);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"run: try to found  not ethernet links on Router nodes");
            }
            for (LinkableNode curNode : this.routerNodes) {
                int curNodeId = curNode.getNodeId();
                String curIpAddr = curNode.getSnmpPrimaryIpAddr();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("run: parsing router nodeid " + curNodeId + " ip address " + curIpAddr));
                }
                Iterator<RouterInterface> sub_ite = curNode.getRouteInterfaces().iterator();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("run: parsing " + curNode.getRouteInterfaces().size() + " Route Interface. "));
                }
                while (sub_ite.hasNext()) {
                    InetAddress nexthop;
                    RouterInterface routeIface = sub_ite.next();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("run: parsing RouterInterface: " + routeIface.toString()));
                    }
                    if (routeIface.getMetric() == -1) {
                        if (!log.isInfoEnabled()) continue;
                        log.info((Object)("run: Router interface has invalid metric " + routeIface.getMetric() + ". Skipping"));
                        continue;
                    }
                    int snmpiftype = routeIface.getSnmpiftype();
                    if (snmpiftype == 6) {
                        if (!log.isInfoEnabled()) continue;
                        log.info((Object)"run: Ethernet interface for nodeid. Skipping ");
                        continue;
                    }
                    if (snmpiftype == 53) {
                        if (!log.isInfoEnabled()) continue;
                        log.info((Object)"run: PropVirtual interface for nodeid. Skipping ");
                        continue;
                    }
                    if (snmpiftype == -1 && log.isInfoEnabled()) {
                        log.info((Object)("store: interface has unknown snmpiftype " + snmpiftype + " . Skipping "));
                    }
                    if ((nexthop = routeIface.getNextHop()).getHostAddress().equals("0.0.0.0")) {
                        if (!log.isInfoEnabled()) continue;
                        log.info((Object)("run: nexthop address is broadcast address " + nexthop.getHostAddress() + " . Skipping "));
                        continue;
                    }
                    if (nexthop.isLoopbackAddress()) {
                        if (!log.isInfoEnabled()) continue;
                        log.info((Object)("run: nexthop address is localhost address " + nexthop.getHostAddress() + " . Skipping "));
                        continue;
                    }
                    int nextHopNodeid = routeIface.getNextHopNodeid();
                    if (nextHopNodeid == -1) {
                        if (!log.isInfoEnabled()) continue;
                        log.info((Object)("run: no node id found for ip next hop address " + nexthop.getHostAddress() + " , skipping "));
                        continue;
                    }
                    if (nextHopNodeid == curNodeId) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("run: node id found for ip next hop address " + nexthop.getHostAddress() + " is itself, skipping "));
                        continue;
                    }
                    int ifindex = routeIface.getIfindex();
                    if (ifindex == 0) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("run: route interface has ifindex " + ifindex + " . trying to get ifindex from nextHopNet: " + routeIface.getNextHopNet()));
                        }
                        if ((ifindex = this.getIfIndexFromRouter(curNode, routeIface.getNextHopNet())) == -1) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("run: found not correct ifindex " + ifindex + " skipping."));
                            continue;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("run: found correct ifindex " + ifindex + " ."));
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"run: saving route link");
                    }
                    NodeToNodeLink lk = new NodeToNodeLink(nextHopNodeid, routeIface.getNextHopIfindex());
                    lk.setNodeparentid(curNodeId);
                    lk.setParentifindex(ifindex);
                    this.addNodetoNodeLink(lk, log);
                }
            }
            this.activenode.clear();
            this.m_bridge.clear();
            this.routerNodes.clear();
            this.cdpNodes.clear();
            this.macsParsed.clear();
            this.macToAtinterface.clear();
            this.nodeToMac.clear();
            Linkd.getInstance().updateDiscoveryLinkCollection(this);
            this.links.clear();
            this.maclinks.clear();
        }
        this.isRunned = true;
        this.reschedule();
    }

    private int getIfIndexFromRouter(LinkableNode parentnode, InetAddress nextHopNet) {
        if (!parentnode.hasRouteInterfaces()) {
            return -1;
        }
        for (RouterInterface curIface : parentnode.getRouteInterfaces()) {
            int ifindex;
            if (curIface.getMetric() == -1 || (ifindex = curIface.getIfindex()) == 0 || ifindex == -1 || !curIface.getRouteNet().equals(nextHopNet)) continue;
            return ifindex;
        }
        return -1;
    }

    LinkableNode getLinkableNodeFromNodeId(int nodeid) {
        for (LinkableNode curNode : this.activenode) {
            if (nodeid != curNode.getNodeId()) continue;
            return curNode;
        }
        return null;
    }

    boolean isBridgeNode(int nodeid) {
        for (LinkableNode curNode : this.m_bridge.values()) {
            if (nodeid != curNode.getNodeId()) continue;
            return true;
        }
        return false;
    }

    boolean isRouterNode(int nodeid) {
        for (LinkableNode curNode : this.routerNodes) {
            if (nodeid != curNode.getNodeId()) continue;
            return true;
        }
        return false;
    }

    boolean isCdpNode(int nodeid) {
        for (LinkableNode curNode : this.cdpNodes) {
            if (nodeid != curNode.getNodeId()) continue;
            return true;
        }
        return false;
    }

    private boolean isEndBridgePort(LinkableNode bridge, int bridgeport) {
        Set<String> macsOnBridge = bridge.getMacAddressesOnBridgePort(bridgeport);
        if (macsOnBridge == null || macsOnBridge.isEmpty()) {
            return true;
        }
        for (String macaddr : macsOnBridge) {
            if (!this.isMacIdentifierOfBridgeNode(macaddr)) continue;
            return false;
        }
        return true;
    }

    private boolean isNearestBridgeLink(LinkableNode bridge1, int bp1, LinkableNode bridge2, int bp2) {
        Set<String> macsOnBridge2 = bridge2.getMacAddressesOnBridgePort(bp2);
        Set<String> macsOnBridge1 = bridge1.getMacAddressesOnBridgePort(bp1);
        if (macsOnBridge2 == null || macsOnBridge1 == null) {
            return true;
        }
        if (macsOnBridge2.isEmpty() || macsOnBridge1.isEmpty()) {
            return true;
        }
        for (String curMacOnBridge1 : macsOnBridge1) {
            if (bridge2.isBridgeIdentifier(curMacOnBridge1) || bridge1.isBridgeIdentifier(curMacOnBridge1) || !macsOnBridge2.contains(curMacOnBridge1) || !this.isMacIdentifierOfBridgeNode(curMacOnBridge1)) continue;
            return false;
        }
        return true;
    }

    private LinkableNode findNearestBridgeLink(LinkableNode bridge1, int bp1, LinkableNode bridge2, int bp2) {
        Set<String> macsOnBridge2 = bridge2.getMacAddressesOnBridgePort(bp2);
        Set<String> macsOnBridge1 = bridge1.getMacAddressesOnBridgePort(bp1);
        if (macsOnBridge2 == null || macsOnBridge1 == null) {
            return bridge2;
        }
        if (macsOnBridge2.isEmpty() || macsOnBridge1.isEmpty()) {
            return bridge2;
        }
        for (String curMacOnBridge1 : macsOnBridge1) {
            if (bridge2.isBridgeIdentifier(curMacOnBridge1) || bridge1.isBridgeIdentifier(curMacOnBridge1) || !macsOnBridge2.contains(curMacOnBridge1) || !this.isMacIdentifierOfBridgeNode(curMacOnBridge1)) continue;
            return this.getNodeFromMacIdentifierOfBridgeNode(curMacOnBridge1);
        }
        return bridge2;
    }

    private Set getMacsOnBridgeLink(LinkableNode bridge1, int bp1, LinkableNode bridge2, int bp2) {
        HashSet<String> macsOnLink = new HashSet<String>();
        Set<String> macsOnBridge1 = bridge1.getMacAddressesOnBridgePort(bp1);
        Set<String> macsOnBridge2 = bridge2.getMacAddressesOnBridgePort(bp2);
        if (macsOnBridge2 == null || macsOnBridge1 == null) {
            return null;
        }
        if (macsOnBridge2.isEmpty() || macsOnBridge1.isEmpty()) {
            return null;
        }
        for (String curMacOnBridge1 : macsOnBridge1) {
            if (bridge2.isBridgeIdentifier(curMacOnBridge1) || !macsOnBridge2.contains(curMacOnBridge1)) continue;
            macsOnLink.add(curMacOnBridge1);
        }
        return macsOnLink;
    }

    private boolean isMacIdentifierOfBridgeNode(String macAddress) {
        for (LinkableNode curNode : this.m_bridge.values()) {
            if (!curNode.isBridgeIdentifier(macAddress)) continue;
            return true;
        }
        return false;
    }

    private LinkableNode getNodeFromMacIdentifierOfBridgeNode(String macAddress) {
        for (LinkableNode curNode : this.m_bridge.values()) {
            if (!curNode.isBridgeIdentifier(macAddress)) continue;
            return curNode;
        }
        return null;
    }

    private HashMap getBridgesFromMacs(Set macs) {
        HashMap<Integer, LinkableNode> bridges = new HashMap<Integer, LinkableNode>();
        for (LinkableNode curNode : this.m_bridge.values()) {
            for (String curBridgeIdentifier : curNode.getBridgeIdentifiers()) {
                if (!macs.contains(curBridgeIdentifier)) continue;
                bridges.put(new Integer(curNode.getNodeId()), curNode);
            }
        }
        return bridges;
    }

    private int getBridgePortOnEndBridge(LinkableNode startBridge, LinkableNode endBridge) {
        for (String curBridgeIdentifier : startBridge.getBridgeIdentifiers()) {
            if (!endBridge.hasMacAddress(curBridgeIdentifier)) continue;
            return endBridge.getBridgePort(curBridgeIdentifier);
        }
        return -1;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public void schedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("schedule: Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.snmp_poll_interval + this.discovery_interval + this.initial_sleep_time, this);
    }

    private void reschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("rescedule: Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.snmp_poll_interval, this);
    }

    public long getInitialSleepTime() {
        return this.initial_sleep_time;
    }

    public void setInitialSleepTime(long initial_sleep_time) {
        this.initial_sleep_time = initial_sleep_time;
    }

    public boolean isReady() {
        return true;
    }

    public long getDiscoveryInterval() {
        return this.discovery_interval;
    }

    public void setSnmpPollInterval(long interval) {
        this.snmp_poll_interval = interval;
    }

    public long getSnmpPollInterval() {
        return this.snmp_poll_interval;
    }

    public void setDiscoveryInterval(long interval) {
        this.discovery_interval = interval;
    }

    public NodeToNodeLink[] getLinks() {
        return this.links.toArray(new NodeToNodeLink[0]);
    }

    public MacToNodeLink[] getMacLinks() {
        return this.maclinks.toArray(new MacToNodeLink[0]);
    }

    public boolean isSnmpCollection() {
        return false;
    }

    public boolean isDiscoveryLink() {
        return true;
    }

    public InetAddress getTarget() throws UnknownHostException {
        return InetAddress.getLocalHost();
    }

    public boolean isSuspended() {
        return this.suspendCollection;
    }

    public void suspend() {
        this.suspendCollection = true;
    }

    public void wakeUp() {
        this.suspendCollection = false;
    }

    public void unschedule() throws UnknownHostException, Throwable {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("rescedule: Cannot schedule a service whose scheduler is set to null");
        }
        if (this.isRunned) {
            this.m_scheduler.unschedule(this.getTarget(), this.snmp_poll_interval);
        } else {
            this.m_scheduler.unschedule(this.getTarget(), this.snmp_poll_interval + this.initial_sleep_time + this.discovery_interval);
        }
    }

    private boolean parseCdpLinkOn(LinkableNode node1, int ifindex1, int nodeid2, Category log) {
        int bridgeport = node1.getBridgePort(ifindex1);
        if (node1.isBackBoneBridgePort(bridgeport)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("run: backbone bridge port " + bridgeport + " already parsed. Skipping"));
            }
            return false;
        }
        if (!this.isEndBridgePort(node1, bridgeport)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"run: link found not on nearest. Skipping");
            }
            return false;
        }
        node1.addBackBoneBridgePorts(bridgeport);
        this.m_bridge.put(new Integer(node1.getNodeId()), node1);
        Set<String> macs = node1.getMacAddressesOnBridgePort(bridgeport);
        macs.removeAll((Collection)this.nodeToMac.get(nodeid2));
        this.addLinks(macs, node1.getNodeId(), ifindex1, log);
        return true;
    }

    private boolean parseCdpLinkOn(LinkableNode node1, int ifindex1, LinkableNode node2, int ifindex2, Category log) {
        int bridgeport1 = node1.getBridgePort(ifindex1);
        if (node1.isBackBoneBridgePort(bridgeport1)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("parseCdpLinkOn: backbone bridge port " + bridgeport1 + " already parsed. Skipping"));
            }
            return false;
        }
        int bridgeport2 = node2.getBridgePort(ifindex2);
        if (node2.isBackBoneBridgePort(bridgeport2)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("parseCdpLinkOn: backbone bridge port " + bridgeport2 + " already parsed. Skipping"));
            }
            return false;
        }
        if (this.isNearestBridgeLink(node1, bridgeport1, node2, bridgeport2)) {
            node1.addBackBoneBridgePorts(bridgeport1);
            this.m_bridge.put(new Integer(node1.getNodeId()), node1);
            node2.addBackBoneBridgePorts(bridgeport2);
            this.m_bridge.put(new Integer(node2.getNodeId()), node2);
            if (log.isDebugEnabled()) {
                log.debug((Object)"parseCdpLinkOn: Adding node on links. Skipping");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"parseCdpLinkOn: link found not on nearest. Skipping");
            }
            return false;
        }
        this.addLinks(this.getMacsOnBridgeLink(node1, bridgeport1, node2, bridgeport2), node1.getNodeId(), ifindex1, log);
        return true;
    }

    private void addNodetoNodeLink(NodeToNodeLink nnlink, Category log) {
        if (nnlink == null) {
            log.warn((Object)"addNodetoNodeLink: node link is null.");
            return;
        }
        if (!this.links.isEmpty()) {
            for (NodeToNodeLink curNnLink : this.links) {
                if (!curNnLink.equals(nnlink)) continue;
                if (log.isInfoEnabled()) {
                    log.info((Object)("addNodetoNodeLink: link " + nnlink.toString() + " exists, not adding"));
                }
                return;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("addNodetoNodeLink: adding link " + nnlink.toString()));
        }
        this.links.add(nnlink);
    }

    private void addLinks(Set macs, int nodeid, int ifindex, Category log) {
        if (macs == null || macs.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"addLinks: mac's list on link is empty.");
            }
        } else {
            for (String curMacAddress : macs) {
                if (this.macsParsed.contains(curMacAddress)) {
                    log.warn((Object)("addLinks: mac address " + curMacAddress + " just found on other bridge port! Skipping..."));
                    continue;
                }
                this.macsParsed.add(curMacAddress);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("run: find ethernet mac address " + curMacAddress + " on port"));
                }
                if (this.macToAtinterface.containsKey(curMacAddress)) {
                    AtInterface at = this.macToAtinterface.get(curMacAddress);
                    NodeToNodeLink lNode = new NodeToNodeLink(at.getNodeId(), at.getIfindex());
                    lNode.setNodeparentid(nodeid);
                    lNode.setParentifindex(ifindex);
                    this.addNodetoNodeLink(lNode, log);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"run: no nodeid found, saving as mac link");
                }
                MacToNodeLink lMac = new MacToNodeLink(curMacAddress);
                lMac.setNodeparentid(nodeid);
                lMac.setParentifindex(ifindex);
                this.maclinks.add(lMac);
            }
        }
    }
}

