/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.snmp.SnmpTableEntry;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.linkd.AtInterface;
import org.opennms.netmgt.linkd.BridgeStpInterface;
import org.opennms.netmgt.linkd.CdpInterface;
import org.opennms.netmgt.linkd.DbAtInterfaceEntry;
import org.opennms.netmgt.linkd.DbDataLinkInterfaceEntry;
import org.opennms.netmgt.linkd.DbIpRouteInterfaceEntry;
import org.opennms.netmgt.linkd.DbStpInterfaceEntry;
import org.opennms.netmgt.linkd.DbStpNodeEntry;
import org.opennms.netmgt.linkd.DiscoveryLink;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.linkd.MacToNodeLink;
import org.opennms.netmgt.linkd.NodeToNodeLink;
import org.opennms.netmgt.linkd.RouterInterface;
import org.opennms.netmgt.linkd.SnmpCollection;
import org.opennms.netmgt.linkd.SnmpVlanCollection;
import org.opennms.netmgt.linkd.snmp.CdpCacheTableEntry;
import org.opennms.netmgt.linkd.snmp.Dot1dBaseGroup;
import org.opennms.netmgt.linkd.snmp.Dot1dBasePortTableEntry;
import org.opennms.netmgt.linkd.snmp.Dot1dStpGroup;
import org.opennms.netmgt.linkd.snmp.Dot1dStpPortTableEntry;
import org.opennms.netmgt.linkd.snmp.Dot1dTpFdbTableEntry;
import org.opennms.netmgt.linkd.snmp.IpNetToMediaTableEntry;
import org.opennms.netmgt.linkd.snmp.IpRouteTableEntry;
import org.opennms.netmgt.linkd.snmp.QBridgeDot1dTpFdbTableEntry;

public class DbEventWriter
implements Runnable {
    static final char ACTION_UPTODATE = 'N';
    static final char ACTION_DELETE = 'D';
    static final char ACTION_STORE = 'S';
    static final char ACTION_STORE_LINKS = 'A';
    private static final int SNMP_DOT1D_FDB_STATUS_OTHER = 1;
    private static final int SNMP_DOT1D_FDB_STATUS_INVALID = 2;
    private static final int SNMP_DOT1D_FDB_STATUS_LEARNED = 3;
    private static final int SNMP_DOT1D_FDB_STATUS_SELF = 4;
    private static final int SNMP_DOT1D_FDB_STATUS_MGMT = 5;
    LinkableNode m_node;
    SnmpCollection m_snmpcoll;
    DiscoveryLink m_discovery;
    int m_nodeId;
    private static final String SQL_GET_NODEID = "SELECT node.nodeid FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ?";
    private static final String SQL_GET_NODEID__IFINDEX_MASK = "SELECT node.nodeid,snmpinterface.snmpifindex,snmpinterface.snmpipadentnetmask FROM node LEFT JOIN snmpinterface ON node.nodeid = snmpinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ?";
    private static final String SQL_GET_NODEID_IFINDEX_IPINT = "SELECT node.nodeid,ipinterface.ifindex FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ?";
    private static final String SQL_UPDATE_DATAINTERFACE = "UPDATE datalinkinterface set status = 'N'  WHERE lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_ATINTERFACE = "UPDATE atinterface set status = 'N'  WHERE sourcenodeid = ? AND lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_IPROUTEINTERFACE = "UPDATE iprouteinterface set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_STPNODE = "UPDATE stpnode set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_STPINTERFACE = "UPDATE stpinterface set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_ATINTERFACE_STATUS = "UPDATE atinterface set status = ?  WHERE sourcenodeid = ? OR nodeid = ?";
    private static final String SQL_UPDATE_IPROUTEINTERFACE_STATUS = "UPDATE iprouteinterface set status = ? WHERE nodeid = ? ";
    private static final String SQL_UPDATE_STPNODE_STATUS = "UPDATE stpnode set status = ?  WHERE nodeid = ? ";
    private static final String SQL_UPDATE_STPINTERFACE_STATUS = "UPDATE stpinterface set status = ? WHERE nodeid = ? ";
    private static final String SQL_UPDATE_DATALINKINTERFACE_STATUS = "UPDATE datalinkinterface set status = ? WHERE nodeid = ? OR nodeparentid = ? ";
    private static final String SQL_GET_NODEID_IFINDEX = "SELECT atinterface.nodeid, snmpinterface.snmpifindex from atinterface left JOIN snmpinterface ON atinterface.nodeid = snmpinterface.nodeid AND atinterface.ipaddr = snmpinterface.ipaddr WHERE atphysaddr = ? AND status = 'A'";
    private static final String SQL_GET_SNMPIFTYPE = "SELECT snmpiftype FROM snmpinterface WHERE nodeid = ? AND snmpifindex = ?";
    private static final String SQL_GET_IFINDEX_SNMPINTERFACE_NAME = "SELECT snmpifindex FROM snmpinterface WHERE nodeid = ? AND (snmpifname = ? OR snmpifdescr = ?) ";
    private static final String SQL_GET_SNMPPHYSADDR_SNMPINTERFACE = "SELECT snmpphysaddr FROM snmpinterface WHERE nodeid = ? AND  snmpphysaddr <> ''";
    private char action = (char)83;

    public DbEventWriter(int nodeid, SnmpCollection m_snmpcoll) {
        this.m_nodeId = nodeid;
        this.m_node = new LinkableNode(nodeid, m_snmpcoll.getSnmpIpPrimary().getHostAddress());
        this.m_snmpcoll = m_snmpcoll;
    }

    public DbEventWriter(int nodeid, char action) {
        this.m_node = null;
        this.m_nodeId = nodeid;
        this.action = action;
    }

    public DbEventWriter(DiscoveryLink discoverLink) {
        this.m_node = null;
        this.m_discovery = discoverLink;
        this.action = (char)65;
    }

    public void run() {
        Category log = ThreadCategory.getInstance(this.getClass());
        Connection dbConn = null;
        Timestamp now = new Timestamp(System.currentTimeMillis());
        try {
            dbConn = DataSourceFactory.getInstance().getConnection();
            if (log.isDebugEnabled()) {
                log.debug((Object)"run: Storing information into database");
            }
            if (this.action == 'S') {
                this.storeSnmpCollection(dbConn, now);
            } else if (this.action == 'N' || this.action == 'D') {
                this.update(dbConn, this.action);
            } else if (this.action == 'A') {
                this.storeDiscoveryLink(dbConn, now);
            } else {
                log.warn((Object)("Unknown action: " + this.action + " . Exiting"));
            }
        }
        catch (SQLException sqlE) {
            log.fatal((Object)"SQL Exception while syncing node object with database information.", (Throwable)sqlE);
            throw new UndeclaredThrowableException(sqlE);
        }
        catch (Throwable t) {
            log.fatal((Object)"Unknown error while syncing node object with database information.", t);
            throw new UndeclaredThrowableException(t);
        }
        finally {
            try {
                if (dbConn != null) {
                    dbConn.close();
                }
            }
            catch (Exception e) {
                log.fatal((Object)"Unknown error while syncing node object with database information.", (Throwable)e);
            }
        }
    }

    private void storeDiscoveryLink(Connection dbConn, Timestamp now) throws SQLException, UnknownHostException {
        int i;
        int parentifindex;
        int nodeparentid;
        Category log = ThreadCategory.getInstance(this.getClass());
        PreparedStatement stmt = null;
        ResultSet rs = null;
        NodeToNodeLink[] links = this.m_discovery.getLinks();
        if (log.isDebugEnabled()) {
            log.debug((Object)("storelink: Storing " + links.length + " NodeToNodeLink information into database"));
        }
        for (int i2 = 0; i2 < links.length; ++i2) {
            NodeToNodeLink lk = links[i2];
            int nodeid = lk.getNodeId();
            int ifindex = lk.getIfindex();
            nodeparentid = lk.getNodeparentid();
            parentifindex = lk.getParentifindex();
            DbDataLinkInterfaceEntry dbentry = DbDataLinkInterfaceEntry.get(dbConn, nodeid, ifindex);
            if (dbentry == null) {
                dbentry = DbDataLinkInterfaceEntry.create(nodeid, ifindex);
            }
            dbentry.updateNodeParentId(nodeparentid);
            dbentry.updateParentIfIndex(parentifindex);
            dbentry.updateStatus('A');
            dbentry.set_lastpolltime(now);
            dbentry.store(dbConn);
            dbentry = DbDataLinkInterfaceEntry.get(dbConn, nodeparentid, parentifindex);
            if (dbentry == null || dbentry.get_nodeparentid() != nodeid || dbentry.get_parentifindex() != ifindex || dbentry.get_status() == 'D') continue;
            dbentry.updateStatus('D');
            dbentry.store(dbConn);
        }
        MacToNodeLink[] linkmacs = this.m_discovery.getMacLinks();
        if (log.isDebugEnabled()) {
            log.debug((Object)("storelink: Storing " + linkmacs.length + " MacToNodeLink information into database"));
        }
        for (i = 0; i < linkmacs.length; ++i) {
            MacToNodeLink lkm = linkmacs[i];
            String macaddr = lkm.getMacAddress();
            nodeparentid = lkm.getNodeparentid();
            parentifindex = lkm.getParentifindex();
            stmt = dbConn.prepareStatement(SQL_GET_NODEID_IFINDEX);
            stmt.setString(1, macaddr);
            rs = stmt.executeQuery();
            if (log.isDebugEnabled()) {
                log.debug((Object)("storelink: finding nodeid,ifindex on DB. Sql Statement SELECT atinterface.nodeid, snmpinterface.snmpifindex from atinterface left JOIN snmpinterface ON atinterface.nodeid = snmpinterface.nodeid AND atinterface.ipaddr = snmpinterface.ipaddr WHERE atphysaddr = ? AND status = 'A' with mac address " + macaddr));
            }
            if (!rs.next()) {
                rs.close();
                stmt.close();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("storelink: no nodeid found on DB for mac address " + macaddr + " on link. .... Skipping"));
                continue;
            }
            int ndx = 1;
            int nodeid = rs.getInt(ndx++);
            if (rs.wasNull()) {
                rs.close();
                stmt.close();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("storelink: no nodeid found on DB for mac address " + macaddr + " on link. .... Skipping"));
                continue;
            }
            int ifindex = rs.getInt(ndx++);
            if (rs.wasNull()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("storelink: no ifindex found on DB for mac address " + macaddr + " on link."));
                }
                ifindex = -1;
            }
            rs.close();
            stmt.close();
            DbDataLinkInterfaceEntry dbentry = DbDataLinkInterfaceEntry.get(dbConn, nodeid, ifindex);
            if (dbentry == null) {
                dbentry = DbDataLinkInterfaceEntry.create(nodeid, ifindex);
            }
            dbentry.updateNodeParentId(nodeparentid);
            dbentry.updateParentIfIndex(parentifindex);
            dbentry.updateStatus('A');
            dbentry.set_lastpolltime(now);
            dbentry.store(dbConn);
        }
        stmt = dbConn.prepareStatement(SQL_UPDATE_DATAINTERFACE);
        stmt.setTimestamp(1, now);
        i = stmt.executeUpdate();
        stmt.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("storelink: datalinkinterface - updated to NOT ACTIVE status " + i + " rows "));
        }
    }

    private void storeSnmpCollection(Connection dbConn, Timestamp now) throws SQLException, UnknownHostException {
        SnmpTableEntry ent;
        Category log = ThreadCategory.getInstance(this.getClass());
        Iterator<Object> ite = null;
        int nodeid = this.m_node.getNodeId();
        if (this.m_snmpcoll.hasIpNetToMediaTable()) {
            ite = this.m_snmpcoll.getIpNetToMediaTable().getEntries().iterator();
            if (log.isDebugEnabled()) {
                log.debug((Object)"store: saving IpNetToMediaTable to atinterface table in DB");
            }
            ArrayList<AtInterface> atInterfaces = new ArrayList<AtInterface>();
            while (ite.hasNext()) {
                AtInterface at;
                ent = (IpNetToMediaTableEntry)((Object)ite.next());
                int ifindex = ent.getInt32("ipNetToMediaIfIndex");
                InetAddress ipaddress = ent.getIPAddress("ipNetToMediaNetAddress");
                if (ipaddress.isLoopbackAddress() || ipaddress.getHostAddress().equals("0.0.0.0")) {
                    log.warn((Object)("store: invalid ip " + ipaddress.getHostAddress()));
                    continue;
                }
                String physAddr = ent.getHexString("ipNetToMediaPhysAddress");
                if (physAddr.equals("000000000000") || physAddr.equalsIgnoreCase("ffffffffffff")) {
                    log.warn((Object)("store: invalid mac address " + physAddr + " for ip " + ipaddress.getHostAddress()));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("store: trying save info for ipaddr " + ipaddress.getHostName() + " mac address " + physAddr + " found on ifindex " + ifindex));
                }
                if ((at = this.getNodeidIfindexFromIp(dbConn, ipaddress)) == null) {
                    log.warn((Object)("getNodeidIfindexFromIp: no nodeid found for ipaddress " + ipaddress + "."));
                    this.sendNewSuspectEvent(ipaddress);
                    continue;
                }
                at.setMacAddress(physAddr);
                atInterfaces.add(at);
                DbAtInterfaceEntry atInterfaceEntry = DbAtInterfaceEntry.get(dbConn, at.getNodeId(), ipaddress.getHostAddress());
                if (atInterfaceEntry == null) {
                    atInterfaceEntry = DbAtInterfaceEntry.create(at.getNodeId(), ipaddress.getHostAddress());
                }
                atInterfaceEntry.updateAtPhysAddr(physAddr);
                atInterfaceEntry.updateSourceNodeId(nodeid);
                atInterfaceEntry.updateIfIndex(ifindex);
                atInterfaceEntry.updateStatus('A');
                atInterfaceEntry.set_lastpolltime(now);
                atInterfaceEntry.store(dbConn);
            }
            this.m_node.setAtInterfaces(atInterfaces);
        }
        if (this.m_snmpcoll.hasCdpCacheTable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"store: saving CdpCacheTable into SnmpLinkableNode");
            }
            ArrayList<CdpInterface> cdpInterfaces = new ArrayList<CdpInterface>();
            for (CdpCacheTableEntry cdpEntry : this.m_snmpcoll.getCdpCacheTable().getEntries()) {
                int cdpAddrType = cdpEntry.getInt32("cdpCacheAddressType");
                if (cdpAddrType != 1) continue;
                String cdptargetipaddress = cdpEntry.getHexString("cdpCacheAddress");
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" cdp ip address octet string is " + cdptargetipaddress));
                }
                long ipAddr = Long.parseLong(cdptargetipaddress, 16);
                byte[] bytes = new byte[4];
                bytes[3] = (byte)(ipAddr & 0xFFL);
                bytes[2] = (byte)(ipAddr >> 8 & 0xFFL);
                bytes[1] = (byte)(ipAddr >> 16 & 0xFFL);
                bytes[0] = (byte)(ipAddr >> 24 & 0xFFL);
                InetAddress cdpTargetIpAddr = InetAddress.getByAddress(bytes);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" cdp ip address after parsing is " + cdpTargetIpAddr.getHostAddress()));
                }
                int cdpIfIndex = cdpEntry.getInt32("cdpCacheIfIndex");
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" cdp ifindex is " + cdpIfIndex));
                }
                String cdpTargetDevicePort = cdpEntry.getDisplayString("cdpCacheDevicePort");
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" cdp Target device port name is " + cdpTargetDevicePort));
                }
                CdpInterface cdpIface = new CdpInterface(cdpIfIndex);
                int targetCdpNodeId = this.getNodeidFromIp(dbConn, cdpTargetIpAddr);
                cdpIface.setCdpTargetNodeId(targetCdpNodeId);
                cdpIface.setCdpTargetIpAddr(cdpTargetIpAddr);
                int cdpTargetIfindex = this.getIfIndexByName(dbConn, targetCdpNodeId, cdpTargetDevicePort);
                if (targetCdpNodeId == -1 || cdpTargetIfindex == -1) {
                    log.warn((Object)"No nodeid found: cdp interface not added to Linkable Snmp Node. Skipping");
                    this.sendNewSuspectEvent(cdpTargetIpAddr);
                    continue;
                }
                cdpIface.setCdpTargetIfIndex(cdpTargetIfindex);
                cdpInterfaces.add(cdpIface);
            }
            this.m_node.setCdpInterfaces(cdpInterfaces);
        }
        if (this.m_snmpcoll.hasRouteTable()) {
            ArrayList<RouterInterface> routeInterfaces = new ArrayList<RouterInterface>();
            ite = this.m_snmpcoll.getIpRouteTable().getEntries().iterator();
            if (log.isDebugEnabled()) {
                log.debug((Object)"store: saving ipRouteTable to iprouteinterface table in DB");
            }
            while (ite.hasNext()) {
                ent = (IpRouteTableEntry)((Object)ite.next());
                Integer ifindex = ent.getInt32("ipRouteIfIndex");
                if (ifindex == null) {
                    log.warn((Object)("store: Not valid ifindex" + ifindex + " Skipping..."));
                    continue;
                }
                InetAddress routedest = ent.getIPAddress("ipRouteDest");
                InetAddress routemask = ent.getIPAddress("ipRouteMask");
                InetAddress nexthop = ent.getIPAddress("ipRouteNextHop");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("storeSnmpCollection: parsing routedest/routemask/nexthop: " + routedest + "/" + routemask + "/" + nexthop + " ifindex " + (ifindex < 1 ? "less than 1" : ifindex)));
                }
                if (nexthop.isLoopbackAddress()) {
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)"storeSnmpCollection: loopbackaddress found skipping.");
                    continue;
                }
                if (nexthop.getHostAddress().equals("0.0.0.0")) {
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)"storeSnmpCollection: broadcast address found skipping.");
                    continue;
                }
                if (nexthop.isMulticastAddress()) {
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)"storeSnmpCollection: multicast ddress found skipping.");
                    continue;
                }
                Integer routemetric1 = ent.getInt32("ipRouteMetric1");
                Integer routemetric2 = ent.getInt32("ipRouteMetric2");
                Integer routemetric3 = ent.getInt32("ipRouteMetric3");
                Integer routemetric4 = ent.getInt32("ipRouteMetric4");
                Integer routemetric5 = ent.getInt32("ipRouteMetric5");
                Integer routetype = ent.getInt32("ipRouteType");
                Integer routeproto = ent.getInt32("ipRouteProto");
                RouterInterface routeIface = this.getNodeidMaskFromIp(dbConn, nexthop);
                if (routeIface == null) {
                    routeIface = this.getNodeFromIp(dbConn, nexthop);
                }
                if (routeIface == null) {
                    log.warn((Object)("store: No nodeid found for next hop ip" + nexthop + " Skipping ip route interface add to Linkable Snmp Node"));
                    this.sendNewSuspectEvent(nexthop);
                } else {
                    int snmpiftype = -2;
                    if (ifindex != null && ifindex > 0) {
                        snmpiftype = this.getSnmpIfType(dbConn, nodeid, ifindex);
                    }
                    if (snmpiftype == -1) {
                        log.warn((Object)("store: interface has wrong or null snmpiftype " + snmpiftype + " . Skip adding to DiscoverLink "));
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("store: interface has snmpiftype " + snmpiftype + " . Adding to DiscoverLink "));
                        }
                        routeIface.setRouteDest(routedest);
                        routeIface.setRoutemask(routemask);
                        routeIface.setSnmpiftype(snmpiftype);
                        routeIface.setIfindex(ifindex);
                        routeIface.setMetric(routemetric1);
                        routeIface.setNextHop(nexthop);
                        routeInterfaces.add(routeIface);
                    }
                }
                DbIpRouteInterfaceEntry iprouteInterfaceEntry = DbIpRouteInterfaceEntry.get(dbConn, nodeid, routedest.getHostAddress());
                if (iprouteInterfaceEntry == null) {
                    iprouteInterfaceEntry = DbIpRouteInterfaceEntry.create(this.m_node.getNodeId(), routedest.getHostAddress());
                }
                iprouteInterfaceEntry.updateRouteMask(routemask.getHostAddress());
                iprouteInterfaceEntry.updateRouteNextHop(nexthop.getHostAddress());
                iprouteInterfaceEntry.updateIfIndex(ifindex);
                if (routemetric1 != null) {
                    iprouteInterfaceEntry.updateRouteMetric1(routemetric1);
                }
                if (routemetric2 != null) {
                    iprouteInterfaceEntry.updateRouteMetric2(routemetric2);
                }
                if (routemetric3 != null) {
                    iprouteInterfaceEntry.updateRouteMetric3(routemetric3);
                }
                if (routemetric4 != null) {
                    iprouteInterfaceEntry.updateRouteMetric4(routemetric4);
                }
                if (routemetric5 != null) {
                    iprouteInterfaceEntry.updateRouteMetric5(routemetric5);
                }
                if (routetype != null) {
                    iprouteInterfaceEntry.updateRouteType(routetype);
                }
                if (routeproto != null) {
                    iprouteInterfaceEntry.updateRouteProto(routeproto);
                }
                iprouteInterfaceEntry.updateStatus('A');
                iprouteInterfaceEntry.set_lastpolltime(now);
                iprouteInterfaceEntry.store(dbConn);
            }
            this.m_node.setRouteInterfaces(routeInterfaces);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"store: saving SnmpVlanCollection in DB");
        }
        ite = this.m_snmpcoll.getSnmpVlanCollections().entrySet().iterator();
        SnmpVlanCollection snmpVlanColl = null;
        SnmpCollection.Vlan vlan = null;
        while (ite.hasNext()) {
            int curfdbstatus;
            Map.Entry entry = (Map.Entry)ite.next();
            snmpVlanColl = (SnmpVlanCollection)entry.getValue();
            vlan = (SnmpCollection.Vlan)entry.getKey();
            int vlanid = vlan.getVlanindex();
            String vlanindex = Integer.toString(vlanid);
            String vlanname = vlan.getVlanname();
            if (log.isDebugEnabled()) {
                log.debug((Object)("store: parsing VLAN " + vlanindex + " VLAN_NAME " + vlanname));
            }
            if (!snmpVlanColl.hasDot1dBase()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"store: saving Dot1dBaseGroup in stpnode table");
            }
            Dot1dBaseGroup dod1db = snmpVlanColl.getDot1dBase();
            String baseBridgeAddress = dod1db.getBridgeAddress();
            int basenumports = dod1db.getNumberOfPorts();
            int bridgetype = dod1db.getBridgeType();
            if (baseBridgeAddress == "000000000000") {
                log.warn((Object)("store: base bridge address " + baseBridgeAddress + " is invalid for ipaddress "));
                continue;
            }
            this.m_node.addBridgeIdentifier(baseBridgeAddress, vlanindex);
            DbStpNodeEntry dbStpNodeEntry = DbStpNodeEntry.get(dbConn, this.m_node.getNodeId(), vlanid);
            if (dbStpNodeEntry == null) {
                dbStpNodeEntry = DbStpNodeEntry.create(this.m_node.getNodeId(), vlanid);
            }
            dbStpNodeEntry.updateBaseBridgeAddress(baseBridgeAddress);
            dbStpNodeEntry.updateBaseNumPorts(basenumports);
            dbStpNodeEntry.updateBaseType(bridgetype);
            dbStpNodeEntry.updateBaseVlanName(vlanname);
            if (snmpVlanColl.hasDot1dStp()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"store: adding Dot1dStpGroup in stpnode table");
                }
                Dot1dStpGroup dod1stp = snmpVlanColl.getDot1dStp();
                int protospec = dod1stp.getStpProtocolSpecification();
                int stppriority = dod1stp.getStpPriority();
                String stpDesignatedRoot = dod1stp.getStpDesignatedRoot();
                int stprootcost = dod1stp.getStpRootCost();
                int stprootport = dod1stp.getStpRootPort();
                if (stpDesignatedRoot != "0000000000000000") {
                    this.m_node.setVlanStpRoot(vlanindex, stpDesignatedRoot);
                }
                dbStpNodeEntry.updateStpProtocolSpecification(protospec);
                dbStpNodeEntry.updateStpPriority(stppriority);
                dbStpNodeEntry.updateStpDesignatedRoot(stpDesignatedRoot);
                dbStpNodeEntry.updateStpRootCost(stprootcost);
                dbStpNodeEntry.updateStpRootPort(stprootport);
            }
            dbStpNodeEntry.updateStatus('A');
            dbStpNodeEntry.set_lastpolltime(now);
            dbStpNodeEntry.store(dbConn);
            if (snmpVlanColl.hasDot1dBasePortTable()) {
                Iterator sub_ite = snmpVlanColl.getDot1dBasePortTable().getEntries().iterator();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"store: saving Dot1dBasePortTable in stpinterface table");
                }
                while (sub_ite.hasNext()) {
                    Dot1dBasePortTableEntry dot1dbaseptentry = (Dot1dBasePortTableEntry)((Object)sub_ite.next());
                    Integer baseport = dot1dbaseptentry.getInt32("dot1dBasePort");
                    Integer ifindex = dot1dbaseptentry.getInt32("dot1dBasePortIfIndex");
                    this.m_node.setIfIndexBridgePort(ifindex, baseport);
                    DbStpInterfaceEntry dbStpIntEntry = DbStpInterfaceEntry.get(dbConn, this.m_node.getNodeId(), baseport, vlanid);
                    if (dbStpIntEntry == null) {
                        dbStpIntEntry = DbStpInterfaceEntry.create(this.m_node.getNodeId(), baseport, vlanid);
                    }
                    dbStpIntEntry.updateIfIndex(ifindex);
                    dbStpIntEntry.updateStatus('A');
                    dbStpIntEntry.set_lastpolltime(now);
                    dbStpIntEntry.store(dbConn);
                }
            }
            if (snmpVlanColl.hasDot1dStpPortTable()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)" store: adding Dot1dStpPortTable in stpinterface table");
                }
                for (Dot1dStpPortTableEntry dot1dstpptentry : snmpVlanColl.getDot1dStpPortTable().getEntries()) {
                    int stpport = dot1dstpptentry.getInt32("dot1dStpPort");
                    DbStpInterfaceEntry dbStpIntEntry = DbStpInterfaceEntry.get(dbConn, this.m_node.getNodeId(), stpport, vlanid);
                    if (dbStpIntEntry == null) {
                        log.warn((Object)("store StpInterface: when storing STP info for bridge node with nodeid " + this.m_node.getNodeId() + " bridgeport number " + stpport + " and vlan index " + vlanindex + " info not found in database, ERROR skipping....."));
                        continue;
                    }
                    int stpportstate = dot1dstpptentry.getInt32("dot1dStpPortState");
                    int stpportpathcost = dot1dstpptentry.getInt32("dot1dStpPortPathCost");
                    String stpPortDesignatedBridge = dot1dstpptentry.getHexString("dot1dStpPortDesignatedBridge");
                    String stpPortDesignatedRoot = dot1dstpptentry.getHexString("dot1dStpPortDesignatedRoot");
                    int stpportdesignatedcost = dot1dstpptentry.getInt32("dot1dStpPortDesignatedCost");
                    String stpPortDesignatedPort = dot1dstpptentry.getHexString("dot1dStpPortDesignatedPort");
                    if (stpPortDesignatedBridge.equals("0000000000000000")) {
                        log.warn((Object)"storeSnmpCollection: designated bridge is invalid not adding to discoveryLink");
                    } else if (stpPortDesignatedPort.equals("0000")) {
                        log.warn((Object)"storeSnmpCollection: designated port is invalid not adding to discoveryLink");
                    } else {
                        BridgeStpInterface stpIface = new BridgeStpInterface(stpport, vlanindex);
                        stpIface.setStpPortDesignatedBridge(stpPortDesignatedBridge);
                        stpIface.setStpPortDesignatedPort(stpPortDesignatedPort);
                        this.m_node.addStpInterface(stpIface);
                    }
                    dbStpIntEntry.updateStpPortState(stpportstate);
                    dbStpIntEntry.updateStpPortPathCost(stpportpathcost);
                    dbStpIntEntry.updateStpportDesignatedBridge(stpPortDesignatedBridge);
                    dbStpIntEntry.updateStpportDesignatedRoot(stpPortDesignatedRoot);
                    dbStpIntEntry.updateStpPortDesignatedCost(stpportdesignatedcost);
                    dbStpIntEntry.updateStpportDesignatedPort(stpPortDesignatedPort);
                    dbStpIntEntry.updateStatus('A');
                    dbStpIntEntry.set_lastpolltime(now);
                    dbStpIntEntry.store(dbConn);
                }
            }
            if (snmpVlanColl.hasDot1dTpFdbTable()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"store: parsing Dot1dTpFdbTable");
                }
                for (Dot1dTpFdbTableEntry dot1dfdbentry : snmpVlanColl.getDot1dFdbTable().getEntries()) {
                    String curMacAddress = dot1dfdbentry.getHexString("dot1dTpFdbAddress");
                    int fdbport = dot1dfdbentry.getInt32("dot1dTpFdbPort");
                    if (fdbport == 0) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("populateBridge: macaddress " + curMacAddress + " learned on invalid port " + fdbport + " . Skipping"));
                        continue;
                    }
                    curfdbstatus = dot1dfdbentry.getInt32("dot1dTpFdbStatus");
                    if (curfdbstatus == 3) {
                        this.m_node.addMacAddress(fdbport, curMacAddress, vlanindex);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("storeSnmpCollection: found learned mac address " + curMacAddress + " on bridge port " + fdbport + " for VLAN " + vlanindex));
                        }
                    }
                    if (curfdbstatus == 4) {
                        this.m_node.addBridgeIdentifier(curMacAddress);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("storeSnmpCollection: found bridge identifier " + curMacAddress + " for VLAN " + vlanindex + " and bridge port " + fdbport));
                        }
                    }
                    if (curfdbstatus == 2) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("storeSnmpCollection: macaddress " + curMacAddress + " has INVALID status on port " + fdbport + " . Skipping"));
                        continue;
                    }
                    if (curfdbstatus == 5) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("storeSnmpCollection: macaddress " + curMacAddress + " has MGMT status on port " + fdbport + " . Skipping"));
                        continue;
                    }
                    if (curfdbstatus != 1 || !log.isDebugEnabled()) continue;
                    log.debug((Object)("storeSnmpCollection: macaddress " + curMacAddress + " has OTHER status on port " + fdbport + " . Skipping"));
                }
            }
            if (snmpVlanColl.hasQBridgeDot1dTpFdbTable()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"store: parsing QBridgeDot1dTpFdbTable");
                }
                for (QBridgeDot1dTpFdbTableEntry dot1dfdbentry : snmpVlanColl.getQBridgeDot1dFdbTable().getEntries()) {
                    String curMacAddress = dot1dfdbentry.getDisplayString("dot1dTpFdbAddress");
                    int fdbport = dot1dfdbentry.getInt32("dot1dTpFdbPort");
                    if (fdbport == 0) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("populateBridge: macaddress " + curMacAddress + " learned on invalid port " + fdbport + " . Skipping"));
                        continue;
                    }
                    curfdbstatus = dot1dfdbentry.getInt32("dot1dTpFdbStatus");
                    if (curfdbstatus == 3) {
                        this.m_node.addMacAddress(fdbport, curMacAddress, vlanindex);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("storeSnmpCollection: found learned mac address " + curMacAddress + " on bridge port " + fdbport + " for VLAN " + vlanindex));
                        }
                    }
                    if (curfdbstatus == 4) {
                        this.m_node.addBridgeIdentifier(curMacAddress);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("storeSnmpCollection: found bridge identifier " + curMacAddress + " for VLAN " + vlanindex + " and bridge port " + fdbport));
                        }
                    }
                    if (curfdbstatus == 2) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("storeSnmpCollection: macaddress " + curMacAddress + " has INVALID status on port " + fdbport + " . Skipping"));
                        continue;
                    }
                    if (curfdbstatus == 5) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("storeSnmpCollection: macaddress " + curMacAddress + " has MGMT status on port " + fdbport + " . Skipping"));
                        continue;
                    }
                    if (curfdbstatus != 1 || !log.isDebugEnabled()) continue;
                    log.debug((Object)("storeSnmpCollection: macaddress " + curMacAddress + " has OTHER status on port " + fdbport + " . Skipping"));
                }
            }
            this.setBridgeIdentifierFromSnmpInterface(dbConn);
        }
        this.update(dbConn, now);
    }

    private void update(Connection dbConn, Timestamp now) throws SQLException {
        Category log = ThreadCategory.getInstance(this.getClass());
        PreparedStatement stmt = null;
        int i = 0;
        stmt = dbConn.prepareStatement(SQL_UPDATE_ATINTERFACE);
        stmt.setInt(1, this.m_node.getNodeId());
        stmt.setTimestamp(2, now);
        i = stmt.executeUpdate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("store: SQL statement UPDATE atinterface set status = 'N'  WHERE sourcenodeid = ? AND lastpolltime < ? AND status = 'A'. " + i + " rows UPDATED for nodeid=" + this.m_node.getNodeId() + "."));
        }
        stmt.close();
        stmt = dbConn.prepareStatement(SQL_UPDATE_IPROUTEINTERFACE);
        stmt.setInt(1, this.m_node.getNodeId());
        stmt.setTimestamp(2, now);
        i = stmt.executeUpdate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("store: SQL statement UPDATE iprouteinterface set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'. " + i + " rows UPDATED for nodeid=" + this.m_node.getNodeId() + "."));
        }
        stmt.close();
        stmt = dbConn.prepareStatement(SQL_UPDATE_STPNODE);
        stmt.setInt(1, this.m_node.getNodeId());
        stmt.setTimestamp(2, now);
        i = stmt.executeUpdate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("store: SQL statement UPDATE stpnode set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'. " + i + " rows UPDATED for nodeid=" + this.m_node.getNodeId() + "."));
        }
        stmt.close();
        stmt = dbConn.prepareStatement(SQL_UPDATE_STPINTERFACE);
        stmt.setInt(1, this.m_node.getNodeId());
        stmt.setTimestamp(2, now);
        i = stmt.executeUpdate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("store: SQL statement UPDATE stpinterface set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'. " + i + " rows UPDATED for nodeid=" + this.m_node.getNodeId() + "."));
        }
        stmt.close();
    }

    private void update(Connection dbConn, char status) throws SQLException {
        Category log = ThreadCategory.getInstance(this.getClass());
        PreparedStatement stmt = null;
        int i = 0;
        stmt = dbConn.prepareStatement(SQL_UPDATE_ATINTERFACE_STATUS);
        stmt.setString(1, new String(new char[]{status}));
        stmt.setInt(2, this.m_nodeId);
        stmt.setInt(3, this.m_nodeId);
        i = stmt.executeUpdate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("update: SQL statement UPDATE atinterface set status = ?  WHERE sourcenodeid = ? OR nodeid = ?. " + i + " rows UPDATED for nodeid=" + this.m_nodeId + "."));
        }
        stmt.close();
        stmt = dbConn.prepareStatement(SQL_UPDATE_IPROUTEINTERFACE_STATUS);
        stmt.setString(1, new String(new char[]{status}));
        stmt.setInt(2, this.m_nodeId);
        i = stmt.executeUpdate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("update: SQL statement UPDATE iprouteinterface set status = ? WHERE nodeid = ? . " + i + " rows UPDATED for nodeid=" + this.m_nodeId + "."));
        }
        stmt.close();
        stmt = dbConn.prepareStatement(SQL_UPDATE_STPNODE_STATUS);
        stmt.setString(1, new String(new char[]{status}));
        stmt.setInt(2, this.m_nodeId);
        i = stmt.executeUpdate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("update: SQL statement UPDATE stpnode set status = ?  WHERE nodeid = ? . " + i + " rows UPDATED for nodeid=" + this.m_nodeId + "."));
        }
        stmt.close();
        stmt = dbConn.prepareStatement(SQL_UPDATE_STPINTERFACE_STATUS);
        stmt.setString(1, new String(new char[]{status}));
        stmt.setInt(2, this.m_nodeId);
        i = stmt.executeUpdate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("update: SQL statement UPDATE stpinterface set status = ? WHERE nodeid = ? . " + i + " rows UPDATED for nodeid=" + this.m_nodeId + "."));
        }
        stmt.close();
        stmt = dbConn.prepareStatement(SQL_UPDATE_DATALINKINTERFACE_STATUS);
        stmt.setString(1, new String(new char[]{status}));
        stmt.setInt(2, this.m_nodeId);
        stmt.setInt(3, this.m_nodeId);
        i = stmt.executeUpdate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("update: SQL statement UPDATE datalinkinterface set status = ? WHERE nodeid = ? OR nodeparentid = ? . " + i + " rows UPDATED for nodeid=" + this.m_nodeId + "."));
        }
        stmt.close();
    }

    private void setBridgeIdentifierFromSnmpInterface(Connection dbConn) throws SQLException {
        Category log = ThreadCategory.getInstance(this.getClass());
        PreparedStatement stmt = null;
        stmt = dbConn.prepareStatement(SQL_GET_SNMPPHYSADDR_SNMPINTERFACE);
        stmt.setInt(1, this.m_node.getNodeId());
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            String macaddr = rs.getString("snmpphysaddr");
            if (macaddr == null) continue;
            this.m_node.addBridgeIdentifier(macaddr);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("setBridgeIdentifierFromSnmpInterface: found bridge identifier " + macaddr + " from snmpinterface db table"));
        }
    }

    private int getNodeidFromIp(Connection dbConn, InetAddress ipaddr) throws SQLException {
        ResultSet rs;
        if (ipaddr.isLoopbackAddress() || ipaddr.getHostAddress().equals("0.0.0.0")) {
            return -1;
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        int nodeid = -1;
        PreparedStatement stmt = null;
        stmt = dbConn.prepareStatement(SQL_GET_NODEID);
        stmt.setString(1, ipaddr.getHostAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNodeidFromIp: executing query SELECT node.nodeid FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ? with ip address=" + ipaddr.getHostAddress()));
        }
        if (!(rs = stmt.executeQuery()).next()) {
            rs.close();
            stmt.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)"getNodeidFromIp: no entries found in ipinterface");
            }
            return -1;
        }
        int ndx = 1;
        nodeid = rs.getInt(ndx++);
        if (rs.wasNull()) {
            nodeid = -1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNodeidFromIp: found nodeid " + nodeid));
        }
        stmt.close();
        return nodeid;
    }

    private RouterInterface getNodeidMaskFromIp(Connection dbConn, InetAddress ipaddr) throws SQLException {
        ResultSet rs;
        if (ipaddr.isLoopbackAddress() || ipaddr.getHostAddress().equals("0.0.0.0")) {
            return null;
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        int nodeid = -1;
        int ifindex = -1;
        String netmask = null;
        PreparedStatement stmt = null;
        stmt = dbConn.prepareStatement(SQL_GET_NODEID__IFINDEX_MASK);
        stmt.setString(1, ipaddr.getHostAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNodeidMaskFromIp: executing query SELECT node.nodeid,snmpinterface.snmpifindex,snmpinterface.snmpipadentnetmask FROM node LEFT JOIN snmpinterface ON node.nodeid = snmpinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ? with ip address=" + ipaddr.getHostAddress()));
        }
        if (!(rs = stmt.executeQuery()).next()) {
            rs.close();
            stmt.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)"getNodeidMaskFromIp: no entries found in snmpinterface");
            }
            return null;
        }
        nodeid = rs.getInt("nodeid");
        if (rs.wasNull()) {
            rs.close();
            stmt.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)"getNodeidMaskFromIp: no nodeid found");
            }
            return null;
        }
        ifindex = rs.getInt("snmpifindex");
        if (rs.wasNull()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getNodeidMaskFromIp: no snmsnmpifindex found");
            }
            ifindex = -1;
        }
        netmask = rs.getString("snmpipadentnetmask");
        if (rs.wasNull()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getNodeidMaskFromIp: no snmpipadentnetmask found");
            }
            netmask = "255.255.255.255";
        }
        rs.close();
        stmt.close();
        RouterInterface ri = new RouterInterface(nodeid, ifindex, netmask);
        return ri;
    }

    private RouterInterface getNodeFromIp(Connection dbConn, InetAddress ipaddr) throws SQLException {
        ResultSet rs;
        if (ipaddr.isLoopbackAddress() || ipaddr.getHostAddress().equals("0.0.0.0")) {
            return null;
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        int nodeid = -1;
        int ifindex = -1;
        PreparedStatement stmt = null;
        stmt = dbConn.prepareStatement(SQL_GET_NODEID);
        stmt.setString(1, ipaddr.getHostAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNodeFromIp: executing query SELECT node.nodeid FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ? with ip address=" + ipaddr.getHostAddress()));
        }
        if (!(rs = stmt.executeQuery()).next()) {
            rs.close();
            stmt.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)"getNodeFromIp: no entries found in snmpinterface");
            }
            return null;
        }
        nodeid = rs.getInt("nodeid");
        if (rs.wasNull()) {
            rs.close();
            stmt.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)"getNodeFromIp: no nodeid found");
            }
            return null;
        }
        rs.close();
        stmt.close();
        RouterInterface ri = new RouterInterface(nodeid, ifindex);
        return ri;
    }

    private AtInterface getNodeidIfindexFromIp(Connection dbConn, InetAddress ipaddr) throws SQLException {
        ResultSet rs;
        if (ipaddr.isLoopbackAddress() || ipaddr.getHostAddress().equals("0.0.0.0")) {
            return null;
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        int atnodeid = -1;
        int atifindex = -1;
        PreparedStatement stmt = dbConn.prepareStatement(SQL_GET_NODEID_IFINDEX_IPINT);
        stmt.setString(1, ipaddr.getHostAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNodeidIfindexFromIp: executing SQL Statement SELECT node.nodeid,ipinterface.ifindex FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ? with ip address=" + ipaddr.getHostAddress()));
        }
        if (!(rs = stmt.executeQuery()).next()) {
            rs.close();
            stmt.close();
            return null;
        }
        atnodeid = rs.getInt("nodeid");
        if (rs.wasNull()) {
            return null;
        }
        AtInterface ati = new AtInterface(atnodeid, ipaddr.getHostAddress());
        atifindex = rs.getInt("ifindex");
        if (rs.wasNull()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("getNodeidIfindexFromIp: nodeid " + atnodeid + " no ifindex (-1) found for ipaddress " + ipaddr + "."));
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("getNodeidIfindexFromIp: nodeid " + atnodeid + " ifindex " + atifindex + " found for ipaddress " + ipaddr + "."));
            }
            ati.setIfindex(atifindex);
        }
        return ati;
    }

    private int getSnmpIfType(Connection dbConn, int nodeid, int ifindex) throws SQLException {
        ResultSet rs;
        Category log = ThreadCategory.getInstance(this.getClass());
        int snmpiftype = -1;
        PreparedStatement stmt = null;
        stmt = dbConn.prepareStatement(SQL_GET_SNMPIFTYPE);
        stmt.setInt(1, nodeid);
        stmt.setInt(2, ifindex);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSnmpIfType: executing query SELECT snmpiftype FROM snmpinterface WHERE nodeid = ? AND snmpifindex = ? with nodeid=" + nodeid + " and ifindex=" + ifindex));
        }
        if (!(rs = stmt.executeQuery()).next()) {
            rs.close();
            stmt.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)"getSnmpIfType: no entries found in snmpinterface");
            }
            return -1;
        }
        int ndx = 1;
        snmpiftype = rs.getInt(ndx++);
        if (rs.wasNull()) {
            snmpiftype = -1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSnmpIfType: found in snmpinterface snmpiftype=" + snmpiftype));
        }
        stmt.close();
        return snmpiftype;
    }

    private int getIfIndexByName(Connection dbConn, int nodeid, String ifName) throws SQLException {
        ResultSet rs;
        Category log = ThreadCategory.getInstance(this.getClass());
        PreparedStatement stmt = null;
        stmt = dbConn.prepareStatement(SQL_GET_IFINDEX_SNMPINTERFACE_NAME);
        stmt.setInt(1, nodeid);
        stmt.setString(2, ifName);
        stmt.setString(3, ifName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getIfIndexByName: executing querySELECT snmpifindex FROM snmpinterface WHERE nodeid = ? AND (snmpifname = ? OR snmpifdescr = ?) nodeid =" + nodeid + "and ifName=" + ifName));
        }
        if (!(rs = stmt.executeQuery()).next()) {
            rs.close();
            stmt.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)"getIfIndexByName: no entries found in snmpinterface");
            }
            return -1;
        }
        int ndx = 1;
        if (rs.wasNull()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getIfIndexByName: no entries found in snmpinterface");
            }
            return -1;
        }
        int ifindex = rs.getInt(ndx++);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getIfIndexByName: found ifindex=" + ifindex));
        }
        stmt.close();
        return ifindex;
    }

    public LinkableNode getLinkableNode() {
        return this.m_node;
    }

    private void sendNewSuspectEvent(InetAddress ipaddress) {
        if (this.m_snmpcoll.isAutoDiscoveryEnabled()) {
            Category log = ThreadCategory.getInstance(this.getClass());
            if (log.isDebugEnabled()) {
                log.debug((Object)("sendNewSuspectEvent:  found ip address to send :" + ipaddress));
            }
            if (ipaddress.isLoopbackAddress() || ipaddress.isMulticastAddress() || ipaddress.getHostAddress().equals("0.0.0.0")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sendNewSuspectEvent: not sending event for invalid ip address");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sendNewSuspectEvent: sending event for valid ip address");
                }
                Linkd.getInstance().sendNewSuspectEvent(ipaddress.getHostAddress(), this.m_snmpcoll.getSnmpIpPrimary().getHostAddress());
            }
        }
    }
}

