/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.db;

import java.util.Iterator;
import java.util.List;

public class Constants {
    public static final int SEV_INDETERMINATE = 1;
    public static final int SEV_CLEARED = 2;
    public static final int SEV_NORMAL = 3;
    public static final int SEV_WARNING = 4;
    public static final int SEV_MINOR = 5;
    public static final int SEV_MAJOR = 6;
    public static final int SEV_CRITICAL = 7;
    static final int STATE_ON = 1;
    static final int STATE_OFF = 0;
    static final char NAME_VAL_DELIM = '=';
    static final char MULTIPLE_VAL_DELIM = ';';
    static final String ATTRIB_DELIM = "/\\";
    static final char DB_ATTRIB_DELIM = ',';
    static final String VALUE_TRUNCATE_INDICATOR = "...";

    public static String escape(String inStr, char delimchar) {
        char delim = delimchar;
        String delimEscStr = "%" + String.valueOf((int)delim);
        StringBuffer outBuffer = new StringBuffer(inStr);
        int index = 0;
        int delimIndex = inStr.indexOf(delimchar, index);
        while (delimIndex != -1) {
            outBuffer.deleteCharAt(delimIndex);
            outBuffer.insert(delimIndex, delimEscStr);
            index = delimIndex + delimEscStr.length() + 1;
            delimIndex = outBuffer.toString().indexOf(delimchar, index);
        }
        return outBuffer.toString();
    }

    public static String format(List strings, int maxlen) {
        if (strings == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        Iterator i = strings.iterator();
        while (i.hasNext() && buf.length() < maxlen) {
            String s = (String)i.next();
            s = Constants.escape(s, ';');
            if (!first) {
                buf.append(';');
            }
            buf.append(s);
            first = false;
        }
        if (buf.length() >= maxlen) {
            buf.setLength(maxlen - 4);
            buf.append(VALUE_TRUNCATE_INDICATOR);
        }
        return buf.toString();
    }

    public static String format(String[] strings, int maxlen) {
        if (strings == null || strings.length <= 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (int index = 0; index < strings.length && buf.length() < maxlen; ++index) {
            String s = strings[index];
            s = Constants.escape(s, ';');
            if (!first) {
                buf.append(';');
            }
            buf.append(s);
            first = false;
        }
        if (buf.length() >= maxlen) {
            buf.setLength(maxlen - 4);
            buf.append(VALUE_TRUNCATE_INDICATOR);
        }
        return buf.toString();
    }

    public static String format(String string, int maxlen) {
        if (string == null) {
            return null;
        }
        if (string.length() >= maxlen) {
            StringBuffer buf = new StringBuffer(string);
            buf.setLength(maxlen - 4);
            buf.append(VALUE_TRUNCATE_INDICATOR);
            return buf.toString();
        }
        return string;
    }

    public static int getSeverity(String sev) {
        int rc = 1;
        if (sev != null) {
            if ((sev = sev.trim()).equalsIgnoreCase("normal")) {
                rc = 3;
            } else if (sev.equalsIgnoreCase("warning")) {
                rc = 4;
            } else if (sev.equalsIgnoreCase("minor")) {
                rc = 5;
            } else if (sev.equalsIgnoreCase("major")) {
                rc = 6;
            } else if (sev.equalsIgnoreCase("critical")) {
                rc = 7;
            } else if (sev.equalsIgnoreCase("cleared")) {
                rc = 2;
            }
        }
        return rc;
    }

    public static String getSeverityString(int sev) {
        String retString = null;
        switch (sev) {
            case 2: {
                retString = "Cleared";
                break;
            }
            case 7: {
                retString = "Critical";
                break;
            }
            case 6: {
                retString = "Major";
                break;
            }
            case 5: {
                retString = "Minor";
                break;
            }
            case 3: {
                retString = "Normal";
                break;
            }
            case 4: {
                retString = "Warning";
                break;
            }
            default: {
                retString = "Indeterminate";
            }
        }
        return retString;
    }
}

