/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.tcp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.adaptors.tcp.TcpStreamHandler;

final class TcpServer
implements Runnable {
    static final int TCP_PORT = 5817;
    private int m_tcpPort;
    private ServerSocket m_tcpSock;
    private volatile boolean m_stop;
    private LinkedList m_receivers;
    private Thread m_context;
    private Fiber m_parent;
    private List m_handlers;
    private String m_logPrefix;
    private int m_recsPerConn;

    TcpServer(Fiber parent, List handlers) throws IOException {
        this.m_parent = parent;
        this.m_tcpPort = 5817;
        this.m_tcpSock = new ServerSocket(this.m_tcpPort);
        this.m_receivers = new LinkedList();
        this.m_stop = false;
        this.m_context = null;
        this.m_handlers = handlers;
        this.m_logPrefix = "OpenNMS.Eventd";
        this.m_recsPerConn = -1;
    }

    TcpServer(Fiber parent, List handlers, int port) throws IOException {
        this.m_parent = parent;
        this.m_tcpPort = port;
        this.m_tcpSock = new ServerSocket(this.m_tcpPort);
        this.m_receivers = new LinkedList();
        this.m_stop = false;
        this.m_context = null;
        this.m_handlers = handlers;
        this.m_logPrefix = "OpenNMS.Eventd";
        this.m_recsPerConn = -1;
    }

    void stop() throws InterruptedException {
        Category log = ThreadCategory.getInstance(this.getClass());
        boolean isTracing = log.isDebugEnabled();
        if (isTracing) {
            log.debug((Object)"stop method invoked.");
        }
        this.m_stop = true;
        if (this.m_context != null) {
            if (isTracing) {
                log.debug((Object)("Interrupting and joining context thread " + this.m_context.getName()));
            }
            this.m_context.interrupt();
            this.m_context.join();
            if (isTracing) {
                log.debug((Object)("Thread context stopped and joined " + this.m_context.getName()));
            }
            this.m_context = null;
        }
        if (isTracing) {
            log.debug((Object)"Attempting to stop and join all stream handlers");
            log.debug((Object)("There are " + this.m_receivers.size() + " receivers"));
        }
        int ndx = 0;
        Iterator i = this.m_receivers.iterator();
        while (i.hasNext()) {
            TcpStreamHandler t = (TcpStreamHandler)i.next();
            if (t.isAlive()) {
                if (isTracing) {
                    log.debug((Object)("Calling stop on handler index " + ndx));
                }
                t.stop();
                if (isTracing) {
                    log.debug((Object)("Stopped handler index " + ndx));
                }
            }
            ++ndx;
            i.remove();
        }
        if (isTracing) {
            log.debug((Object)"All TCP Handlers are stopped and removed");
        }
    }

    boolean isAlive() {
        boolean rc = false;
        if (this.m_context != null) {
            rc = this.m_context.isAlive();
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = this.m_context = Thread.currentThread();
        synchronized (thread) {
            this.m_context.notifyAll();
        }
        ThreadCategory.setPrefix((String)this.m_logPrefix);
        Category log = ThreadCategory.getInstance(this.getClass());
        boolean isTracing = log.isDebugEnabled();
        if (this.m_stop) {
            block32: {
                if (isTracing) {
                    log.debug((Object)"Stop flag set on thread startup");
                }
                try {
                    if (this.m_tcpSock != null) {
                        this.m_tcpSock.close();
                    }
                    if (isTracing) {
                        log.debug((Object)"The socket has been closed");
                    }
                }
                catch (Exception e) {
                    if (!isTracing) break block32;
                    log.debug((Object)"An exception occured closing the socket", (Throwable)e);
                }
            }
            if (isTracing) {
                log.debug((Object)"Thread exiting");
            }
            return;
        }
        if (isTracing) {
            log.debug((Object)("Server connection processor started on port " + this.m_tcpPort));
        }
        try {
            this.m_tcpSock.setSoTimeout(500);
        }
        catch (SocketException e) {
            if (!this.m_stop) {
                log.warn((Object)"An I/O exception occured setting the socket timeout", (Throwable)e);
            }
            if (isTracing) {
                log.debug((Object)"Thread exiting due to socket error");
            }
            return;
        }
        boolean ioInterrupted = false;
        while (this.m_parent.getStatus() != 4 && this.m_parent.getStatus() != 3 && !this.m_stop) {
            try {
                Thread processor;
                if (isTracing && !ioInterrupted) {
                    log.debug((Object)"Waiting for new connection");
                }
                Socket newbie = this.m_tcpSock.accept();
                ioInterrupted = false;
                StringBuffer connection = new StringBuffer(newbie.getInetAddress().getHostAddress());
                connection.append(":").append(newbie.getPort());
                if (isTracing) {
                    log.debug((Object)("New connection accepted from " + connection));
                }
                TcpStreamHandler handler = new TcpStreamHandler(this.m_parent, newbie, this.m_handlers, this.m_recsPerConn);
                Thread thread2 = processor = new Thread((Runnable)handler, this.m_parent.getName() + "[" + connection + "]");
                synchronized (thread2) {
                    processor.start();
                    try {
                        processor.wait();
                    }
                    catch (InterruptedException e) {
                        log.warn((Object)"The thread was interrupted", (Throwable)e);
                    }
                }
                if (isTracing) {
                    log.debug((Object)"A new stream handler thread has been started");
                }
                this.m_receivers.add(handler);
            }
            catch (InterruptedIOException e) {
                ioInterrupted = true;
            }
            catch (IOException e) {
                log.error((Object)"Server Socket I/O Error", (Throwable)e);
                break;
            }
            Iterator i = this.m_receivers.iterator();
            while (i.hasNext()) {
                TcpStreamHandler t = (TcpStreamHandler)i.next();
                if (t.isAlive()) continue;
                i.remove();
            }
        }
        try {
            if (isTracing) {
                log.debug((Object)"closing the server socket connection");
            }
            this.m_tcpSock.close();
        }
        catch (Throwable t) {
            log.error((Object)"An I/O Error Occcured Closing the Server Socket", t);
        }
        if (isTracing) {
            log.debug((Object)"TCP Server Shutdown");
        }
    }

    public void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }

    public void setEventsPerConnection(int number) {
        this.m_recsPerConn = number;
    }
}

