/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.tcp;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.log4j.Category;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.adaptors.EventHandler;
import org.opennms.netmgt.eventd.adaptors.EventHandlerMBeanProxy;
import org.opennms.netmgt.eventd.adaptors.EventReceiver;
import org.opennms.netmgt.eventd.adaptors.tcp.TcpEventReceiverMBean;
import org.opennms.netmgt.eventd.adaptors.tcp.TcpServer;

public final class TcpEventReceiver
implements EventReceiver,
TcpEventReceiverMBean {
    static final int UNLIMITED_EVENTS = -1;
    private Thread m_worker;
    private TcpServer m_server;
    private List m_handlers = new ArrayList(3);
    private volatile int m_status = 0;
    private int m_tcpPort;
    private String m_logPrefix;
    private int m_recsPerConn;

    public TcpEventReceiver() throws IOException {
        this.m_tcpPort = 5817;
        this.m_server = null;
        this.m_worker = null;
        this.m_logPrefix = null;
        this.m_recsPerConn = -1;
    }

    public TcpEventReceiver(int port) throws IOException {
        this.m_tcpPort = port;
        this.m_server = null;
        this.m_worker = null;
        this.m_logPrefix = null;
        this.m_recsPerConn = -1;
    }

    public synchronized void start() {
        if (this.m_status != 0 && this.m_status != 4) {
            throw new IllegalStateException("The Fiber is in an incorrect state");
        }
        this.m_status = 1;
        try {
            this.m_server = new TcpServer((Fiber)this, this.m_handlers, this.m_tcpPort);
            if (this.m_logPrefix != null) {
                this.m_server.setLogPrefix(this.m_logPrefix);
            }
            if (this.m_recsPerConn != -1) {
                this.m_server.setEventsPerConnection(this.m_recsPerConn);
            }
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e, "Error opening server socket");
        }
        this.m_worker = new Thread((Runnable)this.m_server, "Event TCP Server[" + this.m_tcpPort + "]");
        try {
            this.m_worker.start();
        }
        catch (RuntimeException e) {
            this.m_worker.interrupt();
            this.m_status = 4;
            throw e;
        }
        this.m_status = 2;
    }

    public synchronized void stop() {
        if (this.m_status == 4) {
            return;
        }
        if (this.m_status == 0) {
            this.m_status = 4;
            return;
        }
        this.m_status = 3;
        try {
            this.m_server.stop();
        }
        catch (InterruptedException e) {
            Category log = ThreadCategory.getInstance(this.getClass());
            log.warn((Object)"Thread Interrupted while attempting to join server socket thread", (Throwable)e);
        }
        this.m_server = null;
        this.m_worker = null;
        this.m_status = 4;
    }

    public String getName() {
        return "Event TCP Receiver[" + this.m_tcpPort + "]";
    }

    public int getStatus() {
        return this.m_status;
    }

    public void init() {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventHandler(EventHandler handler) {
        List list = this.m_handlers;
        synchronized (list) {
            if (!this.m_handlers.contains(handler)) {
                this.m_handlers.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventHandler(EventHandler handler) {
        List list = this.m_handlers;
        synchronized (list) {
            this.m_handlers.remove(handler);
        }
    }

    public Integer getPort() {
        return new Integer(this.m_tcpPort);
    }

    public void setPort(Integer port) {
        if (this.m_status != 0 && this.m_status != 4) {
            throw new IllegalStateException("The service is already running and cannot be modified");
        }
        this.m_tcpPort = port;
    }

    public void addEventHandler(String name) throws MalformedObjectNameException, InstanceNotFoundException {
        this.addEventHandler(new EventHandlerMBeanProxy(new ObjectName(name)));
    }

    public void removeEventHandler(String name) throws MalformedObjectNameException, InstanceNotFoundException {
        this.removeEventHandler(new EventHandlerMBeanProxy(new ObjectName(name)));
    }

    public void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }

    public void setEventsPerConnection(Integer number) {
        if (this.m_status != 0 && this.m_status != 4) {
            throw new IllegalStateException("The managed bean is already running and its state cannot be changed");
        }
        this.m_recsPerConn = number;
    }
}

