/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Iterator;
import org.opennms.netmgt.discovery.IPAddressRange;
import org.opennms.netmgt.discovery.IPPollAddress;

final class IPPollRange {
    private IPAddressRange m_range;
    private long m_timeout;
    private int m_retries;

    IPPollRange(String fromIP, String toIP, long timeout, int retries) throws UnknownHostException {
        this.m_range = new IPAddressRange(fromIP, toIP);
        this.m_timeout = timeout;
        this.m_retries = retries;
    }

    IPPollRange(InetAddress start, InetAddress end, long timeout, int retries) {
        this.m_range = new IPAddressRange(start, end);
        this.m_timeout = timeout;
        this.m_retries = retries;
    }

    IPPollRange(IPAddressRange range, long timeout, int retries) {
        this.m_range = range;
        this.m_timeout = timeout;
        this.m_retries = retries;
    }

    long getTimeout() {
        return this.m_timeout;
    }

    int getRetries() {
        return this.m_retries;
    }

    IPAddressRange getAddressRange() {
        return this.m_range;
    }

    Enumeration elements() {
        return new IPPollRangeGenerator(this.m_range.elements());
    }

    Iterator iterator() {
        return new IPPollRangeGenerator(this.m_range.elements());
    }

    final class IPPollRangeGenerator
    implements Enumeration,
    Iterator {
        private Enumeration m_range;

        public IPPollRangeGenerator(Enumeration en) {
            this.m_range = en;
        }

        public boolean hasMoreElements() {
            return this.m_range.hasMoreElements();
        }

        public Object nextElement() {
            return new IPPollAddress((InetAddress)this.m_range.nextElement(), IPPollRange.this.m_timeout, IPPollRange.this.m_retries);
        }

        public boolean hasNext() {
            return this.hasMoreElements();
        }

        public Object next() {
            return this.nextElement();
        }

        public void remove() {
            throw new UnsupportedOperationException("remove operation not supported");
        }
    }
}

