/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import org.apache.log4j.Category;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.discovery.DiscoveredIPMgr;
import org.opennms.netmgt.discovery.IPPollRange;

final class IPGenerator
implements FifoQueue {
    private List m_specificAddresses;
    private List m_includeRanges;
    private Iterator m_iter;
    private boolean m_isInitial;
    private long m_createTime;
    private boolean m_isRestarted;
    private long m_restartTime;
    private long m_initialWait;
    private long m_restartWait;

    private void sync() {
        try {
            DiscoveredIPMgr.dataSourceSync();
        }
        catch (SQLException sqlE) {
            ThreadCategory.getInstance(this.getClass()).error((Object)"Failed to synchronize discovered addresses with the database", (Throwable)sqlE);
        }
        catch (MissingResourceException fnfE) {
            ThreadCategory.getInstance(this.getClass()).error((Object)"Failed to synchronize discovered addresses with the database", (Throwable)fnfE);
        }
    }

    private synchronized boolean doWait(long maxWait) throws InterruptedException {
        boolean completed = true;
        if (this.m_isInitial) {
            Category log = ThreadCategory.getInstance(this.getClass());
            completed = false;
            long start = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug((Object)("doWait(initial): entry time " + start));
            }
            if (start - this.m_createTime >= this.m_initialWait) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"doWait(initial): wait over, setting complete flag");
                }
                completed = true;
                if (this.m_isInitial) {
                    this.sync();
                }
                this.m_isInitial = false;
                this.notifyAll();
            } else {
                long max_wait = start - this.m_createTime + this.m_initialWait;
                if (0L < maxWait && maxWait < max_wait) {
                    max_wait = maxWait;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("doWait(initial): maximum wait = " + max_wait));
                }
                long finish = start;
                do {
                    this.wait(max_wait - (finish - start));
                } while ((finish = System.currentTimeMillis()) - start < max_wait && this.m_isInitial);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"doWait(initial): finished wait loop");
                }
                if (finish - this.m_createTime >= this.m_initialWait) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"doWait(initial): wait over, setting complete flag");
                    }
                    completed = true;
                    if (this.m_isInitial) {
                        this.sync();
                    }
                    this.m_isInitial = false;
                    this.notifyAll();
                }
            }
        } else if (this.m_isRestarted) {
            Category log = ThreadCategory.getInstance(this.getClass());
            completed = false;
            long start = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug((Object)("doWait(restart): entry time " + start));
            }
            if (start - this.m_restartTime >= this.m_restartWait) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"doWait(restart): wait over, setting complete flag");
                }
                completed = true;
                if (this.m_isRestarted) {
                    this.sync();
                }
                this.m_isRestarted = false;
                this.notifyAll();
            } else {
                long max_wait = start - this.m_restartTime + this.m_restartWait;
                if (0L < maxWait && maxWait < max_wait) {
                    max_wait = maxWait;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("doWait(restart): maximum wait = " + max_wait));
                }
                long finish = start;
                do {
                    this.wait(max_wait - (finish - start));
                } while ((finish = System.currentTimeMillis()) - start < max_wait && this.m_isRestarted);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"doWait(restart): finished wait loop");
                }
                if (finish - this.m_restartTime >= this.m_restartWait) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"doWait(restart): wait over, setting complete flag");
                    }
                    completed = true;
                    if (this.m_isRestarted) {
                        this.sync();
                    }
                    this.m_isRestarted = false;
                    this.notifyAll();
                }
            }
        }
        return completed;
    }

    IPGenerator(List specifics, List ranges, long initialWait, long restartWait) {
        this.m_specificAddresses = specifics;
        this.m_includeRanges = ranges;
        this.m_iter = this.iterator();
        this.m_isInitial = true;
        this.m_createTime = System.currentTimeMillis();
        this.m_isRestarted = false;
        this.m_restartTime = this.m_createTime;
        this.m_initialWait = initialWait;
        this.m_restartWait = restartWait;
    }

    Iterator iterator() {
        IteratorChain chainedIter = new IteratorChain();
        chainedIter.add(this.m_specificAddresses.iterator());
        for (IPPollRange range : this.m_includeRanges) {
            chainedIter.add(range.iterator());
        }
        return chainedIter;
    }

    public void add(Object element) throws InterruptedException, FifoQueueException {
        throw new UnsupportedOperationException("Add operation is not supported");
    }

    public boolean add(Object element, long timeout) throws InterruptedException, FifoQueueException {
        throw new UnsupportedOperationException("Add operation is not supported");
    }

    public Object remove() throws InterruptedException, FifoQueueException {
        return this.remove(0L);
    }

    public synchronized Object remove(long timeout) throws InterruptedException, FifoQueueException {
        Category log = ThreadCategory.getInstance(this.getClass());
        if (!this.m_iter.hasNext()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"remove: end of iterator reached, resetting iterator");
            }
            this.m_restartTime = System.currentTimeMillis();
            this.m_isRestarted = true;
            this.m_iter = this.iterator();
        }
        this.doWait(timeout);
        Object rval = null;
        if (this.m_iter.hasNext()) {
            rval = this.m_iter.next();
        }
        return rval;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    static final class IteratorChain
    implements Iterator {
        private List m_iterators = new LinkedList();

        IteratorChain() {
        }

        void add(Iterator iter) {
            this.m_iterators.add(iter);
        }

        public boolean hasNext() {
            boolean rc = false;
            while (this.m_iterators.size() > 0 && !rc) {
                Iterator i = (Iterator)this.m_iterators.get(0);
                rc = i.hasNext();
                if (rc) continue;
                this.m_iterators.remove(0);
            }
            return rc;
        }

        public Object next() {
            Object obj = null;
            while (this.m_iterators.size() > 0 && obj == null) {
                Iterator i = (Iterator)this.m_iterators.get(0);
                if (i.hasNext()) {
                    obj = i.next();
                    continue;
                }
                this.m_iterators.remove(0);
            }
            if (obj == null) {
                throw new NoSuchElementException("No elements remain in the iterator chain");
            }
            return obj;
        }

        public void remove() {
            throw new UnsupportedOperationException("The remove method is not supported");
        }
    }
}

