/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Category;
import org.opennms.core.utils.IPSorter;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.discovery.ExcludeRange;
import org.opennms.netmgt.discovery.IPPollAddress;

final class DiscoveredIPMgr {
    private static final String IP_LOAD_SQL = "SELECT ipAddr FROM ipInterface where isManaged!='D'";
    private static Set m_discovered = new TreeSet(AddrComparator.comparator);
    private static ExcludeRange[] m_excluded;
    private static List m_specifics;

    private DiscoveredIPMgr() {
        throw new UnsupportedOperationException("Construction is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void dataSourceSync() throws SQLException {
        Connection c = null;
        try {
            c = DataSourceFactory.getInstance().getConnection();
            Statement s = c.createStatement();
            ResultSet rs = s.executeQuery(IP_LOAD_SQL);
            if (rs != null) {
                m_discovered.clear();
                while (rs.next()) {
                    String ipstr = rs.getString(1);
                    try {
                        m_discovered.add(InetAddress.getByName(ipstr));
                    }
                    catch (UnknownHostException uhE) {}
                }
                rs.close();
            }
            s.close();
        }
        finally {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    static synchronized void setExclusionList(ExcludeRange[] ranges) {
        m_excluded = ranges;
    }

    static synchronized void setSpecificsList(List specifics) {
        m_specifics = specifics;
    }

    static synchronized boolean isDiscovered(InetAddress addr) {
        return m_discovered.contains(addr);
    }

    static boolean isDiscovered(String ipAddr) throws UnknownHostException {
        return DiscoveredIPMgr.isDiscovered(InetAddress.getByName(ipAddr));
    }

    static synchronized boolean isExcluded(InetAddress addr) {
        boolean rc = false;
        if (m_excluded != null) {
            int x;
            long laddr = 0L;
            byte[] octets = addr.getAddress();
            for (x = 0; x < octets.length; ++x) {
                laddr = laddr << 8 | (octets[x] < 0 ? 256L + (long)octets[x] : (long)octets[x] + 0L);
            }
            for (x = 0; !rc && x < m_excluded.length; ++x) {
                try {
                    InetAddress abegin = InetAddress.getByName(m_excluded[x].getBegin());
                    InetAddress aend = InetAddress.getByName(m_excluded[x].getEnd());
                    long begin = IPSorter.convertToLong((byte[])abegin.getAddress());
                    long end = IPSorter.convertToLong((byte[])aend.getAddress());
                    if (begin > laddr || laddr > end) continue;
                    boolean inSpecifics = false;
                    for (IPPollAddress tmp : m_specifics) {
                        InetAddress specific = tmp.getAddress();
                        if (!specific.equals(addr)) continue;
                        inSpecifics = true;
                        break;
                    }
                    if (inSpecifics) continue;
                    rc = true;
                    break;
                }
                catch (UnknownHostException ex) {
                    Category log = ThreadCategory.getInstance(DiscoveredIPMgr.class);
                    log.error((Object)"DiscoveredIPMgr.isExcluded: failed to convert exclusion address to InetAddress", (Throwable)ex);
                }
            }
        }
        return rc;
    }

    static boolean isExcluded(String ipAddr) throws UnknownHostException {
        return DiscoveredIPMgr.isExcluded(InetAddress.getByName(ipAddr));
    }

    static synchronized boolean isDiscoveredOrExcluded(InetAddress addr) {
        return DiscoveredIPMgr.isDiscovered(addr) || DiscoveredIPMgr.isExcluded(addr);
    }

    static boolean isDiscoveredOrExcluded(String addr) throws UnknownHostException {
        return DiscoveredIPMgr.isDiscoveredOrExcluded(InetAddress.getByName(addr));
    }

    static synchronized boolean addDiscovered(InetAddress addr) {
        return m_discovered.add(addr);
    }

    static boolean addDiscovered(String addr) throws UnknownHostException {
        return DiscoveredIPMgr.addDiscovered(InetAddress.getByName(addr));
    }

    static synchronized boolean removeDiscovered(InetAddress addr) {
        return m_discovered.remove(addr);
    }

    static boolean removeDiscovered(String addr) throws UnknownHostException {
        return DiscoveredIPMgr.removeDiscovered(InetAddress.getByName(addr));
    }

    static final class AddrComparator
    implements Comparator {
        static final AddrComparator comparator = new AddrComparator();

        AddrComparator() {
        }

        public int compare(Object a, Object b) {
            int rc = 0;
            if (a != null && b == null) {
                rc = -1;
            } else if (a == null && b != null) {
                rc = 1;
            } else if (a != null) {
                byte[] ax = ((InetAddress)a).getAddress();
                byte[] bx = ((InetAddress)b).getAddress();
                for (int x = 0; x < ax.length && rc == 0; ++x) {
                    rc = (ax[x] < 0 ? 256 + ax[x] : ax[x]) - (bx[x] < 0 ? 256 + bx[x] : bx[x]);
                }
            }
            return rc;
        }
    }
}

