/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dhcpd;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DhcpdConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dhcpd.Client;
import org.opennms.netmgt.dhcpd.Poller;
import org.opennms.netmgt.dhcpd.Receiver;
import org.opennms.netmgt.dhcpd.Receiver2;
import org.opennms.netmgt.utils.IpValidator;

public final class Dhcpd
extends AbstractServiceDaemon
implements Runnable,
Observer {
    private static final Dhcpd m_singleton = new Dhcpd();
    private static List<Client> m_clients;
    private ServerSocket m_server;
    private Receiver m_listener;
    private Receiver2 m_listener2;
    private Thread m_worker;

    private Dhcpd() {
        super("OpenNMS.Dhcpd");
        m_clients = null;
        this.m_server = null;
        this.m_listener = null;
        this.m_worker = null;
    }

    protected void onStart() {
        boolean relayMode = false;
        this.log().debug((Object)"start: DHCP client daemon starting...");
        if (this.m_worker != null && this.m_worker.isAlive()) {
            throw new IllegalStateException("The server is already running");
        }
        if (this.m_worker != null) {
            this.stop();
        }
        m_clients = Collections.synchronizedList(new LinkedList());
        DhcpdConfigFactory dFactory = null;
        try {
            DhcpdConfigFactory.reload();
            dFactory = DhcpdConfigFactory.getInstance();
        }
        catch (MarshalException ex) {
            this.log().error((Object)"Failed to load dhcpd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().error((Object)"Failed to load dhcpd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().error((Object)"Failed to load dhcpd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("start: listening on TCP port " + dFactory.getPort() + " for incoming client requests."));
            }
            this.m_server = new ServerSocket(dFactory.getPort());
        }
        catch (IOException ex) {
            throw new UndeclaredThrowableException(ex);
        }
        String myIpStr = DhcpdConfigFactory.getInstance().getMyIpAddress();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Checking string \"" + myIpStr + "\" to see if we have an IP address"));
        }
        if (myIpStr != null && !myIpStr.equals("") && !myIpStr.equalsIgnoreCase("broadcast") && IpValidator.isIpValid(myIpStr)) {
            relayMode = true;
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Setting relay mode " + relayMode));
        }
        if (!relayMode || dFactory.getExtendedMode() != null && dFactory.getExtendedMode().equalsIgnoreCase("true")) {
            try {
                this.log().debug((Object)"start: starting receiver thread for port 68");
                this.m_listener = new Receiver(m_clients);
                this.m_listener.start();
            }
            catch (IOException ex) {
                try {
                    this.m_server.close();
                }
                catch (IOException ex1) {
                    // empty catch block
                }
                throw new UndeclaredThrowableException(ex);
            }
        }
        if (relayMode) {
            try {
                this.log().debug((Object)"start: starting receiver thread for port 67");
                this.m_listener2 = new Receiver2(m_clients);
                this.m_listener2.start();
            }
            catch (IOException ex) {
                try {
                    this.m_server.close();
                }
                catch (IOException ex1) {
                    // empty catch block
                }
                throw new UndeclaredThrowableException(ex);
            }
        }
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onStop() {
        if (this.m_worker == null) {
            return;
        }
        if (this.m_listener != null) {
            this.m_listener.stop();
        }
        try {
            this.m_server.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        Object[] list = null;
        List<Client> list2 = m_clients;
        synchronized (list2) {
            list = m_clients.toArray();
        }
        for (int x = 0; list != null && x < list.length; ++x) {
            ((Client)list[x]).stop();
        }
        this.m_server = null;
        m_clients = null;
        this.m_worker = null;
        this.m_listener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Category log = ThreadCategory.getInstance(this.getClass());
        Dhcpd dhcpd = this;
        synchronized (dhcpd) {
            if (!this.isStarting()) {
                return;
            }
            log.debug((Object)"run: setting status to running...");
            this.setStatus(2);
        }
        log.debug((Object)"run: DHCPD client daemon running...");
        try {
            this.m_server.setSoTimeout(1000);
            while (true) {
                Socket sock;
                dhcpd = this;
                synchronized (dhcpd) {
                    if (this.isPaused()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {}
                    } else if (!this.isRunning()) {
                        break;
                    }
                }
                try {
                    sock = this.m_server.accept();
                }
                catch (InterruptedIOException iE) {
                    continue;
                }
                log.debug((Object)"run: got connection request...creating client handler...");
                try {
                    Client clnt = new Client(sock);
                    m_clients.add(clnt);
                    clnt.addObserver(this);
                    clnt.start();
                }
                catch (IOException ioE) {
                    log.error((Object)"I/O exception occured creating client handler.", (Throwable)ioE);
                }
            }
        }
        catch (IOException ioE) {
            log.error((Object)"I/O exception occured processing incomming request", (Throwable)ioE);
        }
        catch (Throwable t) {
            log.error((Object)"An undeclared throwable was caught", t);
        }
        finally {
            log.debug((Object)"run: DHCPD client daemon run completed setting status to stopped");
            this.setStatus(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable inst, Object ignored) {
        Dhcpd dhcpd = this;
        synchronized (dhcpd) {
            if (m_clients != null) {
                m_clients.remove(inst);
            }
        }
    }

    public static Dhcpd getInstance() {
        return m_singleton;
    }

    public static long isServer(InetAddress address, long timeout, int retries) throws IOException {
        return Poller.isServer(address, timeout, retries);
    }

    public static long isServer(InetAddress address) throws IOException {
        return Poller.isServer(address, 3000L, 2);
    }

    protected void onInit() {
    }
}

