/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.daemon;

import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.ServiceDaemon;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractServiceDaemon
implements ServiceDaemon,
InitializingBean {
    private int m_status;
    private String m_name;

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    protected abstract void onInit();

    protected void onPause() {
    }

    protected void onResume() {
    }

    protected void onStart() {
    }

    protected void onStop() {
    }

    public final String getName() {
        return this.m_name;
    }

    protected AbstractServiceDaemon(String name) {
        this.m_name = name;
        this.setStatus(0);
    }

    protected synchronized void setStatus(int status) {
        this.m_status = status;
    }

    public synchronized int getStatus() {
        return this.m_status;
    }

    public String getStatusText() {
        return STATUS_NAMES[this.getStatus()];
    }

    public String status() {
        return this.getStatusText();
    }

    protected synchronized boolean isStartPending() {
        return this.m_status == 0;
    }

    protected synchronized boolean isRunning() {
        return this.m_status == 2;
    }

    protected synchronized boolean isPaused() {
        return this.m_status == 6;
    }

    protected synchronized boolean isStarting() {
        return this.m_status == 1;
    }

    protected Category log() {
        return ThreadCategory.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init() {
        String prefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)this.getName());
            this.log().debug((Object)(this.getName() + " initializing."));
            this.onInit();
            this.log().debug((Object)(this.getName() + " initialization complete."));
        }
        finally {
            ThreadCategory.setPrefix((String)prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        String prefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)this.getName());
            if (!this.isRunning()) {
                return;
            }
            this.setStatus(5);
            this.onPause();
            this.setStatus(6);
            this.log().debug((Object)(this.getName() + " paused."));
        }
        finally {
            ThreadCategory.setPrefix((String)prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        String prefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)this.getName());
            if (!this.isPaused()) {
                return;
            }
            this.setStatus(7);
            this.onResume();
            this.setStatus(2);
            this.log().debug((Object)(this.getName() + " resumed."));
        }
        finally {
            ThreadCategory.setPrefix((String)prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void start() {
        String prefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)this.getName());
            this.log().debug((Object)(this.getName() + " starting."));
            this.setStatus(1);
            this.onStart();
            this.setStatus(2);
            this.log().info((Object)(this.getName() + " started."));
        }
        finally {
            ThreadCategory.setPrefix((String)prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void stop() {
        String prefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)this.getName());
            this.log().debug((Object)(this.getName() + " stopping."));
            this.setStatus(3);
            this.onStop();
            this.setStatus(4);
            this.log().info((Object)(this.getName() + " stopped."));
        }
        finally {
            ThreadCategory.setPrefix((String)prefix);
        }
    }
}

