/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.vacuumd.Action;
import org.opennms.netmgt.config.vacuumd.AutoEvent;
import org.opennms.netmgt.config.vacuumd.Automation;
import org.opennms.netmgt.config.vacuumd.Statement;
import org.opennms.netmgt.config.vacuumd.Trigger;
import org.opennms.netmgt.config.vacuumd.VacuumdConfiguration;

public final class VacuumdConfigFactory {
    private static VacuumdConfigFactory m_singleton = null;
    private VacuumdConfiguration m_config;
    private static boolean m_loaded = false;
    private static Reader m_configReader;

    private VacuumdConfigFactory(Reader rdr) throws MarshalException, ValidationException {
        this.m_config = (VacuumdConfiguration)Unmarshaller.unmarshal(VacuumdConfiguration.class, (Reader)rdr);
    }

    public static void setConfigReader(Reader rdr) {
        m_configReader = rdr;
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        if (m_configReader == null) {
            m_configReader = new InputStreamReader(new FileInputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.VACUUMD_CONFIG_FILE_NAME)));
        }
        m_singleton = new VacuumdConfigFactory(m_configReader);
        m_configReader.close();
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        VacuumdConfigFactory.init();
    }

    public static synchronized VacuumdConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public synchronized Collection getAutomations() {
        return this.m_config.getAutomations().getAutomationCollection();
    }

    public synchronized Collection getTriggers() {
        return this.m_config.getTriggers().getTriggerCollection();
    }

    public synchronized Trigger getTrigger(String triggerName) {
        ArrayList triggers = this.m_config.getTriggers().getTriggerCollection();
        for (Trigger trig : triggers) {
            if (!trig.getName().equals(triggerName)) continue;
            return trig;
        }
        return null;
    }

    public synchronized Action getAction(String actionName) {
        ArrayList actions = this.m_config.getActions().getActionCollection();
        for (Action act : actions) {
            if (!act.getName().equals(actionName)) continue;
            return act;
        }
        return null;
    }

    public synchronized Automation getAutomation(String autoName) {
        ArrayList autos = this.m_config.getAutomations().getAutomationCollection();
        for (Automation auto : autos) {
            if (!auto.getName().equals(autoName)) continue;
            return auto;
        }
        return null;
    }

    public synchronized Collection getActions() {
        return this.m_config.getActions().getActionCollection();
    }

    public synchronized Collection getAutoEvents() {
        return this.m_config.getAutoEvents().getAutoEventCollection();
    }

    public synchronized AutoEvent getAutoEvent(String name) {
        Collection actions = this.getAutoEvents();
        for (AutoEvent ae : actions) {
            if (!ae.getName().equals(name)) continue;
            return ae;
        }
        return null;
    }

    public synchronized int getPeriod() {
        return this.m_config.getPeriod();
    }

    public synchronized String[] getStatements() {
        Statement[] stmts = this.m_config.getStatement();
        String[] sql = new String[stmts.length];
        for (int i = 0; i < stmts.length; ++i) {
            sql[i] = stmts[i].getContent();
        }
        return sql;
    }
}

