/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.threshd.Group;
import org.opennms.netmgt.config.threshd.ThresholdingConfig;

public final class ThresholdingConfigFactory {
    private static ThresholdingConfigFactory m_singleton = null;
    private ThresholdingConfig m_config;
    private static boolean m_loaded = false;
    private Map m_groupMap;

    private ThresholdingConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileReader cfgIn = new FileReader(configFile);
        this.parseXML(cfgIn);
        cfgIn.close();
    }

    public ThresholdingConfigFactory(Reader reader) throws MarshalException, ValidationException {
        this.parseXML(reader);
    }

    private void parseXML(Reader cfgIn) throws MarshalException, ValidationException {
        this.m_config = (ThresholdingConfig)Unmarshaller.unmarshal(ThresholdingConfig.class, (Reader)cfgIn);
        this.m_groupMap = new HashMap();
        for (Group group : this.m_config.getGroupCollection()) {
            this.m_groupMap.put(group.getName(), group);
        }
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.THRESHOLDING_CONF_FILE_NAME);
        ThreadCategory.getInstance(ThresholdingConfigFactory.class).debug((Object)("init: config file path: " + cfgFile.getPath()));
        m_singleton = new ThresholdingConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        ThresholdingConfigFactory.init();
    }

    public static synchronized ThresholdingConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(ThresholdingConfigFactory instance) {
        m_loaded = true;
        m_singleton = instance;
    }

    public String getRrdRepository(String groupName) {
        return this.getGroup(groupName).getRrdRepository();
    }

    public Group getGroup(String groupName) {
        Group group = (Group)this.m_groupMap.get(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Thresholding group " + groupName + " does not exist.");
        }
        return group;
    }

    public Collection getThresholds(String groupName) {
        return this.getGroup(groupName).getThresholdCollection();
    }
}

