/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.IPSorter;
import org.opennms.core.utils.IpListFromUrl;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.threshd.ExcludeRange;
import org.opennms.netmgt.config.threshd.IncludeRange;
import org.opennms.netmgt.config.threshd.Package;
import org.opennms.netmgt.config.threshd.Service;
import org.opennms.netmgt.config.threshd.ThreshdConfiguration;
import org.opennms.netmgt.filter.Filter;

public abstract class ThreshdConfigManager {
    protected ThreshdConfiguration m_config;
    private Map m_urlIPMap;
    private Map m_pkgIpMap;
    protected boolean m_verifyServer;
    protected String m_localServer;

    public ThreshdConfigManager(Reader rdr, String localServer, boolean verifyServer) throws MarshalException, ValidationException {
        this.m_config = (ThreshdConfiguration)Unmarshaller.unmarshal(ThreshdConfiguration.class, (Reader)rdr);
        this.createUrlIpMap();
        this.m_verifyServer = verifyServer;
        this.m_localServer = localServer;
        this.createPackageIpListMap();
    }

    protected void createUrlIpMap() {
        this.m_urlIPMap = new HashMap();
        Enumeration pkgEnum = this.m_config.enumeratePackage();
        while (pkgEnum.hasMoreElements()) {
            Package pkg = (Package)pkgEnum.nextElement();
            Enumeration urlEnum = pkg.enumerateIncludeUrl();
            while (urlEnum.hasMoreElements()) {
                String urlname = (String)urlEnum.nextElement();
                List iplist = IpListFromUrl.parse((String)urlname);
                if (iplist.size() <= 0) continue;
                this.m_urlIPMap.put(urlname, iplist);
            }
        }
    }

    protected void createPackageIpListMap() {
        Category log = ThreadCategory.getInstance(this.getClass());
        this.m_pkgIpMap = new HashMap();
        Enumeration pkgEnum = this.m_config.enumeratePackage();
        while (pkgEnum.hasMoreElements()) {
            Package pkg = (Package)pkgEnum.nextElement();
            Filter filter = new Filter();
            StringBuffer filterRules = new StringBuffer(pkg.getFilter().getContent());
            try {
                List ipList;
                if (this.m_verifyServer) {
                    filterRules.append(" & (serverName == ");
                    filterRules.append('\"');
                    filterRules.append(this.m_localServer);
                    filterRules.append('\"');
                    filterRules.append(")");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("createPackageIpMap: package is " + pkg.getName() + ". filer rules are  " + filterRules.toString()));
                }
                if ((ipList = filter.getIPList(filterRules.toString())).size() <= 0) continue;
                this.m_pkgIpMap.put(pkg, ipList);
            }
            catch (Throwable t) {
                if (!log.isEnabledFor(Priority.ERROR)) continue;
                log.error((Object)("createPackageIpMap: failed to map package: " + pkg.getName() + " to an IP List"), t);
            }
        }
    }

    public synchronized void rebuildPackageIpListMap() {
        this.createPackageIpListMap();
    }

    public synchronized void saveCurrent() throws MarshalException, IOException, ValidationException {
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)this.m_config, (Writer)stringWriter);
        String xmlString = stringWriter.toString();
        if (xmlString != null) {
            this.saveXML(xmlString);
        }
        this.reloadXML();
    }

    public abstract void reloadXML() throws IOException, MarshalException, ValidationException;

    protected abstract void saveXML(String var1) throws IOException;

    public synchronized ThreshdConfiguration getConfiguration() {
        return this.m_config;
    }

    public synchronized Package getPackage(String name) {
        Enumeration packageEnum = this.m_config.enumeratePackage();
        while (packageEnum.hasMoreElements()) {
            Package thisPackage = (Package)packageEnum.nextElement();
            if (!thisPackage.getName().equals(name)) continue;
            return thisPackage;
        }
        return null;
    }

    private boolean interfaceInUrl(String addr, String url) {
        boolean bRet = false;
        List iplist = (List)this.m_urlIPMap.get(url);
        if (iplist != null && iplist.size() > 0) {
            bRet = iplist.contains(addr);
        }
        return bRet;
    }

    public synchronized boolean interfaceInPackage(String iface, Package pkg) {
        Category log = ThreadCategory.getInstance(this.getClass());
        boolean filterPassed = false;
        List ipList = (List)this.m_pkgIpMap.get(pkg);
        if (ipList != null && ipList.size() > 0) {
            filterPassed = ipList.contains(iface);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("interfaceInPackage: Interface " + iface + " passed filter for package " + pkg.getName() + "?: " + filterPassed));
        }
        if (!filterPassed) {
            return false;
        }
        boolean has_specific = false;
        boolean has_range_include = false;
        boolean has_range_exclude = false;
        long addr = IPSorter.convertToLong((String)iface);
        Enumeration eincs = pkg.enumerateIncludeRange();
        while (!has_range_include && eincs.hasMoreElements()) {
            IncludeRange rng = (IncludeRange)eincs.nextElement();
            long start = IPSorter.convertToLong((String)rng.getBegin());
            if (addr > start) {
                long end = IPSorter.convertToLong((String)rng.getEnd());
                if (addr > end) continue;
                has_range_include = true;
                continue;
            }
            if (addr != start) continue;
            has_range_include = true;
        }
        Enumeration espec = pkg.enumerateSpecific();
        while (!has_specific && espec.hasMoreElements()) {
            long speca = IPSorter.convertToLong((String)espec.nextElement().toString());
            if (speca != addr) continue;
            has_specific = true;
        }
        Enumeration eurl = pkg.enumerateIncludeUrl();
        while (!has_specific && eurl.hasMoreElements()) {
            has_specific = this.interfaceInUrl(iface, (String)eurl.nextElement());
        }
        Enumeration eex = pkg.enumerateExcludeRange();
        while (!has_range_exclude && !has_specific && eex.hasMoreElements()) {
            ExcludeRange rng = (ExcludeRange)eex.nextElement();
            long start = IPSorter.convertToLong((String)rng.getBegin());
            if (addr > start) {
                long end = IPSorter.convertToLong((String)rng.getEnd());
                if (addr > end) continue;
                has_range_exclude = true;
                continue;
            }
            if (addr != start) continue;
            has_range_exclude = true;
        }
        return has_specific || has_range_include && !has_range_exclude;
    }

    public synchronized boolean serviceInPackageAndEnabled(String svcName, Package pkg) {
        boolean result = false;
        Enumeration esvcs = pkg.enumerateService();
        while (!result && esvcs.hasMoreElements()) {
            String status;
            Service tsvc = (Service)esvcs.nextElement();
            if (!tsvc.getName().equalsIgnoreCase(svcName) || !(status = tsvc.getStatus()).equals("on")) continue;
            result = true;
        }
        return result;
    }
}

